/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.FallConstants;
import ch.elexis.core.services.holder.BillingSystemServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.locks.IUnlockable;
import ch.elexis.core.ui.preferences.UserCasePreferences;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.core.ui.util.DayDateCombo;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.BillingSystem;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.elexis.data.dto.FallDTO;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import com.tiff.common.ui.datepicker.DatePickerCombo;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class FallDetailBlatt2
extends Composite
implements IUnlockable {
    private static final String SELECT_CONTACT_BODY = Messages.FallDetailBlatt2_PleaseSelectContactFor;
    private static final String SELECT_CONTACT_CAPTION = Messages.FallDetailBlatt2_PleaseSelectCpntactCaption;
    private static final String LABEL = Messages.FallDetailBlatt2_29;
    private static final String RECHNUNGSEMPFAENGER = Messages.FallDetailBlatt2_BillAdressee;
    private static final String VERSICHERUNGSNUMMER = Messages.FallDetailBlatt2_InsuranceNumber;
    private static final String KOSTENTRAEGER = Messages.FallDetailBlatt2_Guarantor;
    private static final String ABRECHNUNGSMETHODE = Messages.FallDetailBlatt2_BillingMethod;
    private static final String DEFINITIONSDELIMITER = ";";
    private static final String ARGUMENTSSDELIMITER = ":";
    private static final String ITEMDELIMITER = "\t";
    private final FormToolkit tk;
    private final ScrolledForm form;
    String[] Abrechnungstypen = UserCasePreferences.sortBillingSystems(BillingSystem.getAbrechnungsSysteme());
    private IFall actFall;
    DayDateCombo ddc;
    String itemsErrorMessage = "parameters not supplied;please control parameters;in preferences";
    public static final String[] dgsys = null;
    Combo cAbrechnung;
    ComboViewer cReason;
    CDateTime dpVon;
    CDateTime dpBis;
    Text tBezeichnung;
    Text tGarant;
    Text tCostBearer;
    Hyperlink autoFill;
    Hyperlink hlGarant;
    Hyperlink hlCostBearer;
    List<Control> lReqs = new ArrayList<Control>();
    List<Control> keepEditable = new ArrayList<Control>();
    Button btnCopyForPatient;
    Set<String> ignoreFocusreacts = new HashSet<String>();
    List<Focusreact> focusreacts = new ArrayList<Focusreact>();
    boolean lockUpdate = true;
    boolean invoiceCorrection = false;

    @Override
    public void setUnlocked(boolean unlock) {
        this.allowFieldUpdate(unlock);
    }

    public void setLockUpdate(boolean value) {
        this.lockUpdate = value;
    }

    public FallDetailBlatt2(Composite parent) {
        this(parent, null, false);
    }

    public FallDetailBlatt2(Composite parent, IFall fall, boolean invoiceCorrection) {
        super(parent, 0);
        this.invoiceCorrection = invoiceCorrection;
        this.actFall = fall;
        this.tk = UiDesk.getToolkit();
        this.form = this.tk.createScrolledForm((Composite)this);
        Composite top = this.form.getBody();
        this.setLayout((Layout)new FillLayout());
        top.setLayout((Layout)new GridLayout(2, false));
        this.tk.createLabel(top, ABRECHNUNGSMETHODE);
        Composite cpAbrechnung = new Composite(top, 0);
        cpAbrechnung.setBackground(new Color((Device)cpAbrechnung.getDisplay(), 255, 255, 255));
        GridLayout grid = new GridLayout(2, false);
        grid.marginWidth = 0;
        cpAbrechnung.setLayout((Layout)grid);
        this.cAbrechnung = new Combo(cpAbrechnung, 8);
        this.autoFill = this.tk.createHyperlink(cpAbrechnung, Messages.FallDetailBlatt2_ApplyData, 0);
        this.autoFill.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Fall[] faelle;
                Kontakt k;
                IFall f = FallDetailBlatt2.this.getSelectedFall();
                if (f == null) {
                    return;
                }
                String abr = f.getAbrechnungsSystem();
                String ktNew = f.getInfoString(KOSTENTRAEGER);
                String ktOld = f.get(Messages.FallDetailBlatt2_GuarantorNoSpecialChars);
                if (StringTool.isNothing((Object)ktNew) && (k = Kontakt.load((String)ktOld)).isValid()) {
                    f.setRequiredContact(KOSTENTRAEGER, k);
                }
                String vnNew = f.getInfoString(VERSICHERUNGSNUMMER);
                String vnOld = f.get(Messages.FallDetailBlatt2_InsNumber);
                if (StringTool.isNothing((Object)vnNew)) {
                    f.setRequiredString(VERSICHERUNGSNUMMER, vnOld);
                }
                Fall[] fallArray = faelle = f.getPatient().getFaelle();
                int n = faelle.length;
                int n2 = 0;
                while (n2 < n) {
                    Fall f0 = fallArray[n2];
                    if (!f0.getId().equals(f.getId()) && f0.getAbrechnungsSystem().equals(abr)) {
                        if (f.getInfoString(RECHNUNGSEMPFAENGER).isEmpty()) {
                            f.setInfoString(RECHNUNGSEMPFAENGER, f0.get("GarantID"));
                        }
                        if (f.getInfoString(KOSTENTRAEGER).isEmpty()) {
                            f.setInfoString(KOSTENTRAEGER, f0.get(Messages.FallDetailBlatt2_GuarantorNoSpecialChars));
                        }
                        if (!f.getInfoString(VERSICHERUNGSNUMMER).isEmpty()) break;
                        f.setInfoString(VERSICHERUNGSNUMMER, f0.getInfoString(VERSICHERUNGSNUMMER));
                        break;
                    }
                    ++n2;
                }
                FallDetailBlatt2.this.setFall(f);
            }
        });
        this.cAbrechnung.setItems(this.Abrechnungstypen);
        this.cAbrechnung.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = FallDetailBlatt2.this.cAbrechnung.getSelectionIndex();
                String abrechungsMethodeStr = FallDetailBlatt2.this.cAbrechnung.getItem(i);
                int separatorPos = UserCasePreferences.getBillingSystemsMenuSeparatorPos(FallDetailBlatt2.this.Abrechnungstypen);
                boolean isDisabled = BillingSystem.isDisabled((String)abrechungsMethodeStr);
                IFall fall = FallDetailBlatt2.this.getSelectedFall();
                String gesetz = "";
                if (fall != null) {
                    gesetz = fall.getAbrechnungsSystem();
                }
                if (StringTool.isNothing((Object)gesetz)) {
                    gesetz = Messages.FallDetailBlatt2_free;
                }
                if (i == separatorPos) {
                    FallDetailBlatt2.this.cAbrechnung.select(FallDetailBlatt2.this.cAbrechnung.indexOf(gesetz));
                } else if (isDisabled) {
                    SWTHelper.alert(Messages.FallDetailBlatt2_ChangeBillingSystemNotAllowedCaption, Messages.FallDetailBlatt2_ChangeBillingSystemNotAllowedBody);
                    FallDetailBlatt2.this.cAbrechnung.select(FallDetailBlatt2.this.cAbrechnung.indexOf(gesetz));
                } else if (fall != null) {
                    if (fall.getBehandlungen(false).length > 0) {
                        if (CoreHub.acl.request(AccessControlDefaults.CASE_MODIFY)) {
                            if (SWTHelper.askYesNo(Messages.FallDetailBlatt2_DontChangeBillingSystemCaption, Messages.FallDetailBlatt2_DontChangeBillingSystemBody)) {
                                fall.setAbrechnungsSystem(FallDetailBlatt2.this.cAbrechnung.getItem(i));
                                FallDetailBlatt2.this.setFall(fall);
                                return;
                            }
                        } else {
                            SWTHelper.alert(Messages.FallDetailBlatt2_CantChangeBillingSystemCaption, Messages.FallDetailBlatt2_CantChangeBillingSystemBody);
                        }
                        FallDetailBlatt2.this.cAbrechnung.select(FallDetailBlatt2.this.cAbrechnung.indexOf(gesetz));
                    } else {
                        fall.setAbrechnungsSystem(FallDetailBlatt2.this.Abrechnungstypen[i]);
                        FallDetailBlatt2.this.setFall(fall);
                    }
                }
                BillingSystemServiceHolder.get().getBillingSystem(abrechungsMethodeStr).ifPresent(bs -> FallDetailBlatt2.this.cReason.setSelection((ISelection)new StructuredSelection((Object)BillingSystemServiceHolder.get().getDefaultInsuranceReason(bs))));
            }
        });
        this.cAbrechnung.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                Object[] newItems;
                Object[] currItems = FallDetailBlatt2.this.cAbrechnung.getItems();
                if (!Arrays.equals(currItems, newItems = UserCasePreferences.sortBillingSystems(BillingSystem.getAbrechnungsSysteme()))) {
                    String savedItem = FallDetailBlatt2.this.cAbrechnung.getText();
                    FallDetailBlatt2.this.cAbrechnung.setItems((String[])newItems);
                    FallDetailBlatt2.this.cAbrechnung.setText(savedItem);
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.tk.createLabel(top, LABEL);
        this.tBezeichnung = this.tk.createText(top, "");
        this.tBezeichnung.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String newval = ((Text)e.getSource()).getText();
                IFall fall = FallDetailBlatt2.this.getSelectedFall();
                if (fall != null) {
                    fall.set("Bezeichnung", newval);
                    FallDetailBlatt2.this.fireSelectedFallUpdateEvent();
                }
                super.focusLost(e);
            }
        });
        this.tBezeichnung.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tk.createLabel(top, Messages.FallDetailBlatt2_ReasonForInsurance);
        this.cReason = new ComboViewer(top, 8);
        this.cReason.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cReason.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.cReason.setInput((Object)new String[]{FallConstants.TYPE_DISEASE, FallConstants.TYPE_ACCIDENT, FallConstants.TYPE_MATERNITY, FallConstants.TYPE_PREVENTION, FallConstants.TYPE_BIRTHDEFECT, FallConstants.TYPE_OTHER});
        this.cReason.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String selected = (String)event.getStructuredSelection().getFirstElement();
                IFall fall = FallDetailBlatt2.this.getSelectedFall();
                if (fall != null) {
                    fall.setGrund(selected);
                    FallDetailBlatt2.this.fireSelectedFallUpdateEvent();
                }
            }
        });
        this.cReason.getControl().setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tk.createLabel(top, Messages.FallDetailBlatt2_StartDate);
        this.dpVon = new CDateTime(top, 34605058);
        if (this.getSelectedFall() == null) {
            this.dpVon.setSelection(new TimeTool().getTime());
        } else {
            this.dpVon.setSelection(new TimeTool(this.getSelectedFall().getBeginnDatum()).getTime());
        }
        this.dpVon.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFall fall = FallDetailBlatt2.this.getSelectedFall();
                TimeTool selectedDate = new TimeTool(FallDetailBlatt2.this.dpVon.getSelection());
                fall.setBeginnDatum(selectedDate.dump());
                FallDetailBlatt2.this.fireSelectedFallUpdateEvent();
            }
        });
        this.dpVon.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.tk.createLabel(top, Messages.FallDetailBlatt2_EndDate);
        this.dpBis = new CDateTime(top, 34605058);
        this.dpBis.setSelection(new Date());
        this.dpBis.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFall fall = FallDetailBlatt2.this.getSelectedFall();
                if (FallDetailBlatt2.this.dpBis.getSelection() != null) {
                    TimeTool selectedDate = new TimeTool(FallDetailBlatt2.this.dpBis.getSelection());
                    fall.setEndDatum(selectedDate.dump());
                } else {
                    fall.setEndDatum(null);
                }
                FallDetailBlatt2.this.fireSelectedFallUpdateEvent();
            }
        });
        this.dpBis.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.ddc = new DayDateCombo(top, Messages.FallDetailBlatt2_ProposeForBillingIn, Messages.FallDetailBlatt2_DaysOrAfter, Messages.FallDetailBlatt2_ProposeForBillingNeg, Messages.FallDetailBlatt2_DaysOrAfterNeg);
        this.ddc.setLayoutData(SWTHelper.getFillGridData(2, true, 1, false));
        this.ddc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeTool nDate = FallDetailBlatt2.this.ddc.getDate();
                IFall fall = FallDetailBlatt2.this.getSelectedFall();
                if (fall != null) {
                    fall.setBillingDate(nDate);
                    FallDetailBlatt2.this.fireSelectedFallUpdateEvent();
                }
            }
        });
        this.tk.adapt((Composite)this.ddc);
        Composite separatorBar = new Composite(top, 0);
        separatorBar.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginTop = -1;
        separatorBar.setLayout((Layout)gridLayout);
        Label lbReq = new Label(separatorBar, 0);
        lbReq.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
        lbReq.setText(Messages.Leistungscodes_necessaryData);
        this.btnCopyForPatient = new Button(top, 32);
        this.btnCopyForPatient.setText(Messages.FallDetailBlatt2_CopyToPatient);
        this.btnCopyForPatient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean b = FallDetailBlatt2.this.btnCopyForPatient.getSelection();
                FallDetailBlatt2.this.getSelectedFall().setCopyForPatient(b);
                FallDetailBlatt2.this.fireSelectedFallUpdateEvent();
            }
        });
        this.ignoreFocusReact("CopyForPatient");
        new Label(top, 0);
        this.hlGarant = this.tk.createHyperlink(top, RECHNUNGSEMPFAENGER, 0);
        this.hlGarant.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                KontaktSelektor ksl = new KontaktSelektor(FallDetailBlatt2.this.getShell(), Kontakt.class, Messages.FallDetailBlatt2_SelectGuarantorCaption, Messages.FallDetailBlatt2_SelectGuarantorBody, true, Kontakt.DEFAULT_SORT);
                if (ksl.open() == 0) {
                    Kontakt sel = (Kontakt)ksl.getSelection();
                    IFall fall = FallDetailBlatt2.this.getSelectedFall();
                    if (fall != null) {
                        fall.setGarant(sel);
                        FallDetailBlatt2.this.setFall(fall);
                    }
                    FallDetailBlatt2.this.updateCopyForPatient(FallDetailBlatt2.this.getFall());
                }
            }
        });
        this.tGarant = this.tk.createText(top, "");
        this.tGarant.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.hlCostBearer = this.tk.createHyperlink(top, KOSTENTRAEGER, 0);
        this.hlCostBearer.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IFall fall;
                KontaktSelektor ksl = new KontaktSelektor(FallDetailBlatt2.this.getShell(), Kontakt.class, Messages.FallDetailBlatt2_SelectCostBearerCaption, Messages.FallDetailBlatt2_SelectCostBearerBody, true, Kontakt.DEFAULT_SORT);
                Kontakt selection = null;
                if (ksl.open() == 0) {
                    selection = (Kontakt)ksl.getSelection();
                }
                if ((fall = FallDetailBlatt2.this.getSelectedFall()) != null) {
                    fall.setCostBearer(selection);
                    FallDetailBlatt2.this.setFall(fall);
                }
                FallDetailBlatt2.this.updateCopyForPatient(FallDetailBlatt2.this.getFall());
            }
        });
        this.tCostBearer = this.tk.createText(top, "");
        this.tCostBearer.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tk.paintBordersFor(top);
        this.setFall(this.getSelectedFall());
    }

    private void updateCopyForPatient(Fall fall) {
        if (fall != null && ConfigServiceHolder.get().get("coverage/copytopatient", false) && fall.getTiersType() == Fall.Tiers.PAYANT) {
            this.getFall().setCopyForPatient(true);
            this.fireSelectedFallUpdateEvent();
            this.btnCopyForPatient.setSelection(true);
        }
    }

    public void reloadBillingSystemsMenu() {
        this.Abrechnungstypen = UserCasePreferences.sortBillingSystems(BillingSystem.getAbrechnungsSysteme());
        String currItem = this.cAbrechnung.getText();
        this.cAbrechnung.setItems(this.Abrechnungstypen);
        this.cAbrechnung.setText(currItem);
    }

    public void setFall(IFall f) {
        String optionals;
        if (this.actFall != null) {
            this.save();
        }
        this.actFall = f;
        for (Control c : this.lReqs) {
            c.dispose();
        }
        this.lReqs.clear();
        this.keepEditable.clear();
        this.cAbrechnung.setItems(this.Abrechnungstypen);
        if (f == null) {
            this.form.setText(Messages.FallDetailBlatt2_NoCaseSelected);
            this.tBezeichnung.setText("");
            this.tBezeichnung.setMessage(Messages.FallDetailBlatt2_29);
            this.cReason.setSelection((ISelection)new StructuredSelection((Object)FallConstants.TYPE_DISEASE));
            return;
        }
        this.form.setText(f.getLabel());
        this.tBezeichnung.setText(f.getBezeichnung());
        String grund = f.getGrund();
        this.cReason.setSelection((ISelection)new StructuredSelection((Object)grund));
        String billingSystem = f.getAbrechnungsSystem();
        this.cAbrechnung.setText(billingSystem);
        TimeTool tt = new TimeTool();
        if (tt.set(f.getBeginnDatum())) {
            this.dpVon.setSelection(tt.getTime());
        } else {
            this.dpVon.setSelection(null);
        }
        if (tt.set(f.getEndDatum())) {
            this.dpBis.setSelection(tt.getTime());
        } else {
            this.dpBis.setSelection(null);
        }
        this.btnCopyForPatient.setSelection(f.getCopyForPatient());
        this.tGarant.setBackground(null);
        this.tGarant.setToolTipText(null);
        Kontakt garant = f.getGarant();
        String garantLabel = garant.getLabel();
        if (garant.isDeleted()) {
            this.tGarant.setBackground(UiDesk.getColor("rot"));
            garantLabel = "*** " + garantLabel;
            this.tGarant.setToolTipText(Messages.Contact_is_marked_deleted);
        }
        this.tGarant.setText(garantLabel);
        boolean costBearerDisabled = BillingSystem.isCostBearerDisabled((String)billingSystem);
        this.tCostBearer.setVisible(!costBearerDisabled);
        this.hlCostBearer.setVisible(!costBearerDisabled);
        this.tCostBearer.setBackground(null);
        this.tCostBearer.setToolTipText(null);
        if (!costBearerDisabled) {
            String label;
            Kontakt costBearer = f.getCostBearer();
            String string = label = costBearer != null ? costBearer.getLabel() : null;
            if (costBearer != null && costBearer.isDeleted()) {
                this.tCostBearer.setBackground(UiDesk.getColor("rot"));
                label = "*** " + label;
                this.tCostBearer.setToolTipText(Messages.Contact_is_marked_deleted);
            }
            if (label != null) {
                this.tCostBearer.setText(label);
            } else {
                this.tCostBearer.setText("");
                this.tCostBearer.setMessage(Messages.FallDetailBlatt2_SelectCostBearerBody);
            }
        } else {
            this.tCostBearer.setText("");
        }
        String reqs = BillingSystem.getRequirementsBySystem((String)billingSystem);
        if (reqs != null && reqs.length() > 0) {
            this.setExtendedFields(f, reqs, "", false, false, false);
        }
        if ((optionals = f.getOptionals()) != null && optionals.length() > 0) {
            this.setExtendedFields(f, optionals, Messages.FallDetailBlatt2_optionalData, false, false, true);
        }
        String[] reqsArray = BillingSystem.getRequirementsBySystem((String)billingSystem).split(DEFINITIONSDELIMITER);
        int reqI = 0;
        while (reqI < reqsArray.length) {
            reqsArray[reqI] = reqsArray[reqI].split(ARGUMENTSSDELIMITER)[0];
            ++reqI;
        }
        String[] optsArray = f.getOptionals().split(DEFINITIONSDELIMITER);
        int reqI2 = 0;
        while (reqI2 < optsArray.length) {
            optsArray[reqI2] = optsArray[reqI2].split(ARGUMENTSSDELIMITER)[0];
            ++reqI2;
        }
        ArrayList<String> unused = new ArrayList<String>();
        LinkedHashMap<String, String> unusedHash = new LinkedHashMap<String, String>();
        String strUnused = f.getUnused();
        if (strUnused != null && !strUnused.isEmpty()) {
            String[] allUnused = strUnused.split(DEFINITIONSDELIMITER);
            Arrays.sort(allUnused, String.CASE_INSENSITIVE_ORDER);
            String[] stringArray = allUnused;
            int n = allUnused.length;
            int n2 = 0;
            while (n2 < n) {
                String unusedPart = stringArray[n2];
                int posColon = unusedPart.indexOf(ARGUMENTSSDELIMITER);
                String key = unusedPart.substring(0, posColon);
                boolean alreadyDisplayed = false;
                int reqI3 = 0;
                while (reqI3 < reqsArray.length) {
                    if (key.equalsIgnoreCase(reqsArray[reqI3])) {
                        alreadyDisplayed = true;
                    }
                    ++reqI3;
                }
                reqI3 = 0;
                while (reqI3 < optsArray.length) {
                    if (key.equalsIgnoreCase(optsArray[reqI3])) {
                        alreadyDisplayed = true;
                    }
                    ++reqI3;
                }
                if (!alreadyDisplayed) {
                    String value = unusedPart.substring(posColon + 1);
                    unusedHash.put(key, value);
                    unused.add(unusedPart);
                }
                ++n2;
            }
        }
        Map httmp = this.getSelectedFall().getMap("ExtInfo");
        HashMap ht = new HashMap(httmp);
        String[] unusedHashStringArray = new String[]{};
        if (unusedHash.size() > 0) {
            String unusedHashString = unusedHash.toString();
            unusedHashString = unusedHashString.substring(1);
            unusedHashString = unusedHashString.substring(0, unusedHashString.length() - 1);
            unusedHashStringArray = unusedHashString.split(", ");
        }
        String otherFieldsList_2 = "";
        String delim = "";
        int uhi = 0;
        while (uhi < unusedHashStringArray.length) {
            String unusedItem = unusedHashStringArray[uhi];
            String[] itemParts = unusedItem.split("=");
            String controlName = itemParts[0];
            String[] controlDefParts = itemParts[1].split(ARGUMENTSSDELIMITER);
            String controlType = controlDefParts[0];
            String[] itemList = new String[]{""};
            if (controlType.equalsIgnoreCase("X") && controlDefParts.length > 1) {
                itemList = controlDefParts[1].split(ITEMDELIMITER);
            }
            boolean isAdded = false;
            int ili = 0;
            while (ili < itemList.length) {
                String combControlName;
                String item = itemList[ili];
                if (!item.isEmpty()) {
                    item = "_" + item;
                }
                if (ht.containsKey(combControlName = String.valueOf(controlName) + item)) {
                    ht.remove(combControlName);
                    String values = "";
                    if (controlDefParts.length > 1) {
                        values = controlDefParts[1];
                    }
                    if (!isAdded) {
                        otherFieldsList_2 = String.valueOf(otherFieldsList_2) + delim + controlName + ARGUMENTSSDELIMITER + controlType + ARGUMENTSSDELIMITER + values;
                    }
                    delim = DEFINITIONSDELIMITER;
                    isAdded = true;
                }
                ++ili;
            }
            ++uhi;
        }
        if (otherFieldsList_2.length() > 0 && CoreHub.acl.request(AccessControlDefaults.CASE_MODIFY_SPECIALS)) {
            this.setExtendedFields(f, otherFieldsList_2, Messages.FallDetailBlatt2_unusedFieldsWithDefinition, true, true, false);
        }
        String otherFieldsList = otherFieldsList_2;
        otherFieldsList = "";
        Set keySet = ht.keySet();
        Object[] arr = keySet.toArray();
        int i = 0;
        while (i < arr.length) {
            String fld;
            String subkey = (String)arr[i];
            String abrSystem = this.getSelectedFall().getAbrechnungsSystem();
            String key = "billing/systems/" + abrSystem;
            String bed = ConfigServiceHolder.getGlobal((String)(String.valueOf(key) + "/bedingungen"), (String)"");
            boolean isAlreadyShown = false;
            if (subkey.equalsIgnoreCase("billing")) {
                isAlreadyShown = true;
            }
            String[] bedArr = bed.split(DEFINITIONSDELIMITER);
            if (!bed.isEmpty()) {
                int ii = 0;
                while (ii < bedArr.length) {
                    String fldParts = bedArr[ii];
                    String[] flds = fldParts.split(ARGUMENTSSDELIMITER);
                    fld = flds[0];
                    if (flds[1].equalsIgnoreCase("X") && flds.length > 2 && !flds[2].isEmpty()) {
                        String checkBoxes = flds[2];
                        String[] checkBoxArray = checkBoxes.split(ITEMDELIMITER);
                        int cb_i = 0;
                        while (cb_i < checkBoxArray.length) {
                            if ((String.valueOf(fld) + "_" + checkBoxArray[cb_i]).equalsIgnoreCase(subkey)) {
                                isAlreadyShown = true;
                                break;
                            }
                            ++cb_i;
                        }
                    } else if (fld.equalsIgnoreCase(subkey)) {
                        isAlreadyShown = true;
                        break;
                    }
                    ++ii;
                }
            }
            String opt = ConfigServiceHolder.getGlobal((String)(String.valueOf(key) + "/fakultativ"), (String)"");
            if (!isAlreadyShown) {
                String[] optArr = opt.split(DEFINITIONSDELIMITER);
                if (!opt.isEmpty()) {
                    int ii = 0;
                    while (ii < optArr.length) {
                        fld = optArr[ii].split(ARGUMENTSSDELIMITER)[0];
                        if (fld.equalsIgnoreCase(subkey)) {
                            isAlreadyShown = true;
                            break;
                        }
                        ++ii;
                    }
                }
            }
            if (!isAlreadyShown) {
                if (unusedHash.containsKey(subkey)) {
                    String theVal = (String)unusedHash.get(subkey);
                    String[] vals = theVal.split(ARGUMENTSSDELIMITER);
                    otherFieldsList = String.valueOf(otherFieldsList) + delim + subkey + ARGUMENTSSDELIMITER + vals[0];
                    if (vals.length > 1) {
                        otherFieldsList = String.valueOf(otherFieldsList) + ARGUMENTSSDELIMITER + vals[1];
                    }
                } else {
                    otherFieldsList = String.valueOf(otherFieldsList) + delim + subkey + ":T";
                }
                delim = DEFINITIONSDELIMITER;
            }
            ++i;
        }
        if (otherFieldsList.length() > 0) {
            String[] tmpArr = otherFieldsList.split(DEFINITIONSDELIMITER);
            Arrays.sort(tmpArr, String.CASE_INSENSITIVE_ORDER);
            otherFieldsList = "";
            String tmpDel = "";
            int i2 = 0;
            while (i2 < tmpArr.length) {
                otherFieldsList = String.valueOf(otherFieldsList) + tmpDel + tmpArr[i2];
                tmpDel = DEFINITIONSDELIMITER;
                ++i2;
            }
            if (CoreHub.acl.request(AccessControlDefaults.CASE_MODIFY_SPECIALS)) {
                this.setExtendedFields(f, otherFieldsList, Messages.FallDetailBlatt2_unusedFieldsWithoutDefinition, true, true, false);
            }
        }
        if (this.lockUpdate) {
            this.setUnlocked(LocalLockServiceHolder.get().isLockedLocal((Object)this.actFall));
        }
    }

    private void allowFieldUpdate(boolean lockEnabled) {
        boolean noExistingInvoicesForThisCoverage = true;
        boolean costBearerEnabled = true;
        if (this.actFall != null) {
            Query rQuery = new Query(Rechnung.class);
            rQuery.add("FallID", "=", this.actFall.getId());
            List billMatch = rQuery.execute();
            if (billMatch != null && !billMatch.isEmpty()) {
                noExistingInvoicesForThisCoverage = false;
            }
            costBearerEnabled = !BillingSystem.isCostBearerDisabled((String)this.actFall.getAbrechnungsSystem());
        }
        boolean enable = lockEnabled && (noExistingInvoicesForThisCoverage || this.invoiceCorrection);
        this.tBezeichnung.setEditable(lockEnabled);
        this.dpVon.setEnabled(enable);
        this.dpBis.setEnabled(lockEnabled);
        this.cAbrechnung.setEnabled(enable);
        this.cReason.getControl().setEnabled(enable);
        this.hlGarant.setEnabled(enable);
        this.tGarant.setForeground(enable ? UiDesk.getColor("schwarz") : UiDesk.getColor("grau60"));
        this.tGarant.setEditable(enable);
        this.tCostBearer.setForeground(enable && costBearerEnabled ? UiDesk.getColor("schwarz") : UiDesk.getColor("grau60"));
        this.tCostBearer.setEditable(enable && costBearerEnabled);
        if (!this.tCostBearer.getEditable()) {
            this.tCostBearer.setMessage("");
        }
        this.hlCostBearer.setEnabled(enable && costBearerEnabled);
        this.autoFill.setEnabled(enable);
        for (Control req : this.lReqs) {
            if (req instanceof Label) continue;
            if (this.keepEditable.contains(req)) {
                req.setEnabled(lockEnabled);
                continue;
            }
            if (req instanceof Text) {
                if (enable) {
                    req.setForeground(UiDesk.getColor("schwarz"));
                } else {
                    req.setForeground(UiDesk.getColor("grau60"));
                }
                ((Text)req).setEditable(enable);
                continue;
            }
            req.setEnabled(enable);
        }
    }

    public void save() {
        if (this.actFall != null) {
            String newValue = this.tBezeichnung.getText();
            if (newValue != null && !newValue.isEmpty() && !newValue.equals(Messages.FallDetailBlatt2_29)) {
                this.actFall.set("Bezeichnung", newValue);
            }
            for (Focusreact react : this.focusreacts) {
                react.save();
            }
        }
    }

    public void fireSelectedFallUpdateEvent() {
        IFall fall = this.getSelectedFall();
        if (fall instanceof PersistentObject) {
            ElexisEventDispatcher.update((PersistentObject)((PersistentObject)fall));
        }
    }

    private void setExtendedFields(final IFall f, String fieldList, String TitleBarText, boolean deletable, boolean dangerous, final boolean optional) {
        if (TitleBarText != null && !TitleBarText.isEmpty()) {
            Composite separatorBar = new Composite(this.form.getBody(), 0);
            separatorBar.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
            Color dangerousColor = new Color((Device)separatorBar.getDisplay(), 255, 150, 150);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginTop = -1;
            gridLayout.marginBottom = -1;
            if (dangerous) {
                separatorBar.setBackground(dangerousColor);
            }
            separatorBar.setLayout((Layout)gridLayout);
            this.lReqs.add((Control)separatorBar);
            Label lbReq = new Label(separatorBar, 0);
            lbReq.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
            lbReq.setText(TitleBarText);
            if (dangerous) {
                lbReq.setBackground(dangerousColor);
            }
            this.lReqs.add((Control)lbReq);
        }
        String[] stringArray = fieldList.split(DEFINITIONSDELIMITER);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String req = stringArray[n2];
            this.focusreacts.clear();
            final String[] r = req.split(ARGUMENTSSDELIMITER);
            if (r.length >= 2) {
                int rIx;
                Button[] radios;
                GridLayout radioLayout;
                Composite radioComposite;
                int lIx;
                String[] vals;
                org.eclipse.swt.widgets.List list;
                Combo combo;
                GridLayout radioLayout2;
                String val = f.getInfoString(r[0]);
                Hyperlink hl = null;
                if (r[1].equals("K")) {
                    hl = this.tk.createHyperlink(this.form.getBody(), r[0], 0);
                    this.addControl((Control)hl, optional, r[0]);
                    if (!val.startsWith("**ERROR")) {
                        Kontakt k = Kontakt.load((String)val);
                        val = k.getLabel();
                    }
                } else {
                    this.addControl((Control)this.tk.createLabel(this.form.getBody(), r[0]), optional, r[0]);
                }
                Composite subParent = this.createRightComposite(deletable);
                String[] items = this.itemsErrorMessage.split(DEFINITIONSDELIMITER);
                if (r[1].equals("CS") || r[1].equals("CN") || r[1].equals("LS") || r[1].equals("LN") || r[1].equals("RS") || r[1].equals("RN") || r[1].equals("X")) {
                    if (r.length >= 4) {
                        if (r[2].equalsIgnoreCase("SQL")) {
                            String itemsStr = TextContainer.replaceSQLClause("SQL:" + r[3]);
                            itemsStr = itemsStr.replaceAll("\r\n", ITEMDELIMITER);
                            itemsStr = itemsStr.replaceAll("\n", ITEMDELIMITER).replaceAll("\r", ITEMDELIMITER);
                            items = itemsStr.split(ITEMDELIMITER);
                        }
                    } else if (r.length >= 3 && r.length >= 3) {
                        items = r[2].split(ITEMDELIMITER);
                    }
                }
                Object dataField = null;
                Composite stretchComposite = null;
                if (r[1].equals("T")) {
                    dataField = this.tk.createText(subParent, val);
                    dataField.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
                    this.addFocusReact((Control)dataField, r[0]);
                } else if (r[1].equals("D")) {
                    final DatePickerCombo dp = new DatePickerCombo(subParent, 0);
                    TimeTool tt = new TimeTool();
                    if (tt.set(val)) {
                        dp.setDate(tt.getTime());
                    }
                    dp.setLayoutData(SWTHelper.getFillGridData(1, false, 1, false));
                    dp.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            TimeTool tt = new TimeTool(dp.getDate().getTime());
                            f.setInfoString(r[0], tt.toString(4));
                        }
                    });
                    dataField = dp;
                } else if (r[1].equals("K")) {
                    dataField = this.tk.createText(subParent, val);
                    if (hl == null) {
                        throw new IllegalStateException("hl is null");
                    }
                    hl.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            KontaktSelektor ksl = new KontaktSelektor(FallDetailBlatt2.this.getShell(), Kontakt.class, SELECT_CONTACT_CAPTION, MessageFormat.format(SELECT_CONTACT_BODY, r[0]), true, Kontakt.DEFAULT_SORT);
                            if (optional) {
                                ksl.enableEmptyFieldButton();
                            }
                            if (ksl.open() == 0) {
                                Kontakt sel = (Kontakt)ksl.getSelection();
                                IFall fall = FallDetailBlatt2.this.getSelectedFall();
                                if (fall != null) {
                                    if (sel != null) {
                                        fall.setInfoString(r[0], sel.getId());
                                    } else {
                                        fall.setInfoString(r[0], "");
                                    }
                                    FallDetailBlatt2.this.setFall(fall);
                                }
                            }
                        }
                    });
                    dataField.setEditable(false);
                    dataField.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
                } else if (r[1].equals("TM")) {
                    Text multiText = new Text(subParent, 2050);
                    multiText.setText(val);
                    multiText.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
                    this.addFocusReact((Control)multiText, r[0]);
                    multiText.addKeyListener(new KeyListener(){

                        public void keyPressed(KeyEvent e) {
                        }

                        public void keyReleased(KeyEvent e) {
                            Point sizePt = ((Text)e.widget).computeSize(-1, -1);
                            ((Text)e.widget).setSize(((Text)e.widget).getBounds().width, sizePt.y);
                            FallDetailBlatt2.this.form.getBody().layout(true);
                        }
                    });
                    dataField = multiText;
                } else if (r[1].equals("CS")) {
                    stretchComposite = new Composite(subParent, 0);
                    stretchComposite.setBackground(new Color((Device)stretchComposite.getDisplay(), 255, 255, 255));
                    stretchComposite.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
                    this.addControl((Control)stretchComposite, optional, r[0]);
                    radioLayout2 = new GridLayout(1, false);
                    radioLayout2.marginWidth = 0;
                    stretchComposite.setLayout((Layout)radioLayout2);
                    combo = new Combo(stretchComposite, 0);
                    combo.setItems(items);
                    combo.setText(val);
                    combo.setData("kind", (Object)"S");
                    combo.setLayoutData((Object)SWTHelper.getFillGridData(1, false, 1, false));
                    this.addFocusReact((Control)combo, r[0]);
                    dataField = combo;
                } else if (r[1].equals("CN")) {
                    stretchComposite = new Composite(subParent, 0);
                    stretchComposite.setBackground(new Color((Device)stretchComposite.getDisplay(), 255, 255, 255));
                    stretchComposite.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
                    radioLayout2 = new GridLayout(1, false);
                    radioLayout2.marginWidth = 0;
                    stretchComposite.setLayout((Layout)radioLayout2);
                    combo = new Combo(stretchComposite, 0);
                    combo.setItems(items);
                    if (!val.isEmpty()) {
                        try {
                            combo.setText(items[Integer.parseInt(val)]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    combo.setData("kind", (Object)"N");
                    combo.setLayoutData((Object)SWTHelper.getFillGridData(1, false, 1, false));
                    this.addFocusReact((Control)combo, r[0]);
                    dataField = combo;
                } else if (r[1].equals("LS")) {
                    stretchComposite = new Composite(subParent, 0);
                    stretchComposite.setBackground(new Color((Device)stretchComposite.getDisplay(), 255, 255, 255));
                    stretchComposite.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
                    radioLayout2 = new GridLayout(items.length, false);
                    radioLayout2.marginWidth = 0;
                    stretchComposite.setLayout((Layout)radioLayout2);
                    list = new org.eclipse.swt.widgets.List(stretchComposite, 2562);
                    vals = val.split(ITEMDELIMITER);
                    lIx = 0;
                    while (lIx < items.length) {
                        list.add(items[lIx]);
                        int ii = 0;
                        while (ii < vals.length) {
                            if (vals[ii].equalsIgnoreCase(items[lIx])) {
                                list.select(lIx);
                            }
                            ++ii;
                        }
                        ++lIx;
                    }
                    list.setData("kind", (Object)"S");
                    list.setLayoutData((Object)SWTHelper.getFillGridData(1, false, 1, false));
                    this.addFocusReact((Control)list, r[0]);
                    dataField = list;
                } else if (r[1].equals("LN")) {
                    stretchComposite = new Composite(subParent, 0);
                    stretchComposite.setBackground(new Color((Device)stretchComposite.getDisplay(), 255, 255, 255));
                    stretchComposite.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
                    radioLayout2 = new GridLayout(items.length, false);
                    radioLayout2.marginWidth = 0;
                    stretchComposite.setLayout((Layout)radioLayout2);
                    list = new org.eclipse.swt.widgets.List(stretchComposite, 2562);
                    vals = val.split(ITEMDELIMITER);
                    lIx = 0;
                    while (lIx < items.length) {
                        list.add(items[lIx]);
                        int ii = 0;
                        while (ii < vals.length) {
                            if (vals[ii].equalsIgnoreCase("" + lIx)) {
                                list.select(lIx);
                            }
                            ++ii;
                        }
                        ++lIx;
                    }
                    list.setData("kind", (Object)"N");
                    list.setLayoutData((Object)SWTHelper.getFillGridData(1, false, 1, false));
                    this.addFocusReact((Control)list, r[0]);
                    dataField = list;
                } else if (r[1].equals("RS")) {
                    radioComposite = new Composite(subParent, 0);
                    radioComposite.setBackground(new Color((Device)radioComposite.getDisplay(), 255, 255, 255));
                    radioComposite.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
                    radioLayout = new GridLayout(items.length, false);
                    radioLayout.marginWidth = 0;
                    radioComposite.setLayout((Layout)radioLayout);
                    radios = new Button[items.length];
                    rIx = 0;
                    while (rIx < items.length) {
                        radios[rIx] = new Button(radioComposite, 16);
                        radios[rIx].setBackground(new Color((Device)radios[rIx].getDisplay(), 255, 255, 255));
                        radios[rIx].setText(items[rIx]);
                        radios[rIx].setData("index", (Object)rIx);
                        radios[rIx].setData("kind", (Object)"S");
                        if (val.equalsIgnoreCase(items[rIx])) {
                            radios[rIx].setSelection(true);
                        } else {
                            radios[rIx].setSelection(false);
                        }
                        this.addFocusReact((Control)radios[rIx], r[0]);
                        ++rIx;
                    }
                    dataField = radioComposite;
                } else if (r[1].equals("RN")) {
                    radioComposite = new Composite(subParent, 0);
                    radioComposite.setBackground(new Color((Device)radioComposite.getDisplay(), 255, 255, 255));
                    radioComposite.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
                    radioLayout = new GridLayout(items.length, false);
                    radioLayout.marginWidth = 0;
                    radioComposite.setLayout((Layout)radioLayout);
                    radios = new Button[items.length];
                    rIx = 0;
                    while (rIx < items.length) {
                        radios[rIx] = new Button(radioComposite, 16);
                        radios[rIx].setBackground(new Color((Device)radios[rIx].getDisplay(), 255, 255, 255));
                        radios[rIx].setText(items[rIx]);
                        radios[rIx].setData("index", (Object)rIx);
                        radios[rIx].setData("kind", (Object)"N");
                        if (val.equalsIgnoreCase("" + rIx)) {
                            radios[rIx].setSelection(true);
                        } else {
                            radios[rIx].setSelection(false);
                        }
                        this.addFocusReact((Control)radios[rIx], r[0]);
                        ++rIx;
                    }
                    dataField = radioComposite;
                } else if (r[1].equals("X")) {
                    if (r.length < 3) {
                        items = "".split(ITEMDELIMITER);
                    }
                    if (items.length > 1) {
                        Composite checkBoxComposite = new Composite(subParent, 0);
                        checkBoxComposite.setBackground(new Color((Device)checkBoxComposite.getDisplay(), 255, 255, 255));
                        checkBoxComposite.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
                        GridLayout checkBoxLayout = new GridLayout(items.length, false);
                        checkBoxLayout.marginWidth = 0;
                        checkBoxComposite.setLayout((Layout)checkBoxLayout);
                        Button[] checks = new Button[items.length];
                        rIx = 0;
                        while (rIx < items.length) {
                            String val2 = f.getInfoString(String.valueOf(r[0]) + "_" + items[rIx]);
                            checks[rIx] = new Button(checkBoxComposite, 32);
                            checks[rIx].setBackground(new Color((Device)checks[rIx].getDisplay(), 255, 255, 255));
                            checks[rIx].setText(items[rIx]);
                            if (val2.isEmpty()) {
                                checks[rIx].setSelection(true);
                                checks[rIx].setGrayed(true);
                            } else if (val2.equalsIgnoreCase("0")) {
                                checks[rIx].setSelection(false);
                                checks[rIx].setGrayed(false);
                            } else {
                                checks[rIx].setSelection(true);
                                checks[rIx].setGrayed(false);
                            }
                            this.addFocusReact((Control)checks[rIx], String.valueOf(r[0]) + "_" + items[rIx]);
                            checks[rIx].addSelectionListener((SelectionListener)new TristateSelection());
                            this.addControl((Control)checks[rIx], optional, r[0]);
                            ++rIx;
                        }
                        dataField = checkBoxComposite;
                    } else {
                        Button check = new Button(subParent, 32);
                        if (val.isEmpty()) {
                            check.setSelection(true);
                            check.setGrayed(true);
                        } else if (val.equalsIgnoreCase("0")) {
                            check.setSelection(false);
                            check.setGrayed(false);
                        } else {
                            check.setSelection(true);
                            check.setGrayed(false);
                        }
                        this.addFocusReact((Control)check, r[0]);
                        check.addSelectionListener((SelectionListener)new TristateSelection());
                        check.setBackground(new Color((Device)check.getDisplay(), 255, 255, 255));
                        check.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
                        dataField = check;
                    }
                } else {
                    dataField = this.tk.createLabel(subParent, "FallDetailBlatt2().setExtendedFields(): field type not supported: " + r[1]);
                }
                this.addDeleteButton(deletable, subParent, r, f);
                if (stretchComposite != null) {
                    this.addControl((Control)stretchComposite, optional, r[0]);
                }
                this.addControl((Control)dataField, optional, r[0]);
            }
            ++n2;
        }
        TimeTool bt = f.getBillingDate();
        this.ddc.setDates(bt);
        this.form.reflow(true);
        this.form.redraw();
    }

    private void ignoreFocusReact(String field) {
        this.ignoreFocusreacts.add(field);
    }

    private void addFocusReact(Control dataField, String field) {
        Focusreact react = new Focusreact(dataField, field);
        dataField.addFocusListener((FocusListener)react);
        this.focusreacts.add(react);
    }

    protected Composite createRightComposite(boolean deletable) {
        if (deletable) {
            Composite tmpComp = new Composite(this.form.getBody(), 0);
            GridLayout tmpGridLayout = new GridLayout(2, false);
            tmpGridLayout.marginWidth = 0;
            tmpGridLayout.marginTop = -7;
            tmpGridLayout.marginBottom = -7;
            tmpGridLayout.marginTop = -5;
            tmpGridLayout.marginBottom = -5;
            tmpComp.setBackground(new Color((Device)tmpComp.getDisplay(), 255, 255, 255));
            tmpComp.setLayout((Layout)tmpGridLayout);
            tmpComp.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            return tmpComp;
        }
        return this.form.getBody();
    }

    protected void addDeleteButton(boolean deletable, Composite parent, String[] r, final IFall f) {
        if (deletable) {
            Button tmpButton = new Button(parent, 0);
            tmpButton.setText(Messages.FallDetailBlatt2_deleteData);
            tmpButton.setData("KeyForDataToBeDeleted_Marlovits", (Object)r[0]);
            tmpButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String key = (String)e.widget.getData("KeyForDataToBeDeleted_Marlovits");
                    PersistentObject.clearCache();
                    Map ht = f.getMap("extinfo");
                    if (SWTHelper.askYesNo("", String.valueOf(Messages.FallDetailBlatt2_DoYouWantToDeleteThisData) + key + "/" + ht.get(key) + Messages.FallDetailBlatt2_reallyFromTheCase)) {
                        ht.remove(key);
                        f.setMap("extinfo", ht);
                        FallDetailBlatt2.this.setFall(f);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.lReqs.add((Control)tmpButton);
            this.lReqs.add((Control)parent);
        }
    }

    private boolean addControl(Control control, boolean optional, String value) {
        String accidentNo = "Unfallnummer";
        String accidentDate = "Unfalldatum";
        if (optional || accidentNo.equalsIgnoreCase(value) || accidentDate.equalsIgnoreCase(value)) {
            this.keepEditable.add(control);
        }
        return this.lReqs.add(control);
    }

    private IFall getSelectedFall() {
        if (!this.invoiceCorrection && this.actFall == null) {
            this.actFall = (IFall)ElexisEventDispatcher.getSelected(Fall.class);
        }
        return this.actFall;
    }

    public Fall getFall() {
        this.actFall = this.getSelectedFall();
        if (this.actFall instanceof PersistentObject) {
            return (Fall)this.actFall;
        }
        return null;
    }

    private class Focusreact
    implements FocusListener {
        private final String field;
        private Control control;

        public Focusreact(Control control, String field) {
            this.field = field;
            this.control = control;
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            this.save();
        }

        public void save() {
            if (!this.control.isDisposed() && !this.ignore()) {
                String newValue = this.getValue(this.control);
                IFall fall = FallDetailBlatt2.this.getSelectedFall();
                if (fall != null && newValue != null) {
                    if (fall instanceof PersistentObject) {
                        PersistentObject.clearCache();
                        fall.setInfoString(this.field, newValue);
                        ElexisEventDispatcher.update((PersistentObject)((PersistentObject)fall));
                    } else if (fall instanceof FallDTO) {
                        fall.setInfoString(this.field, newValue);
                    }
                }
            }
        }

        private boolean ignore() {
            return FallDetailBlatt2.this.ignoreFocusreacts.contains(this.field);
        }

        public String getValue(Control control) {
            String newval = "";
            if (control instanceof Combo) {
                String kind = (String)((Combo)control).getData("kind");
                newval = kind.equalsIgnoreCase("S") ? ((Combo)control).getText() : "" + ((Combo)control).getSelectionIndex();
            } else if (control instanceof org.eclipse.swt.widgets.List) {
                int[] selection = ((org.eclipse.swt.widgets.List)control).getSelectionIndices();
                String delim = "";
                String kind = (String)((org.eclipse.swt.widgets.List)control).getData("kind");
                if (kind.equalsIgnoreCase("S")) {
                    int ii = 0;
                    while (ii < selection.length) {
                        newval = String.valueOf(newval) + delim + ((org.eclipse.swt.widgets.List)control).getItem(selection[ii]);
                        delim = FallDetailBlatt2.ITEMDELIMITER;
                        ++ii;
                    }
                } else {
                    int ii = 0;
                    while (ii < selection.length) {
                        newval = String.valueOf(newval) + delim + selection[ii];
                        delim = FallDetailBlatt2.ITEMDELIMITER;
                        ++ii;
                    }
                }
            } else if (control instanceof Button) {
                Button button = (Button)control;
                if ((button.getStyle() & 0x10) != 0) {
                    String kind = (String)button.getData("kind");
                    if (kind.equalsIgnoreCase("S")) {
                        if (button.getSelection()) {
                            newval = button.getText();
                        }
                    } else if (button.getSelection()) {
                        newval = button.getData("index").toString();
                    }
                }
                if ((button.getStyle() & 0x20) != 0) {
                    boolean grayed = button.getGrayed();
                    boolean selected = button.getSelection();
                    newval = selected ? (grayed ? "" : "1") : "0";
                }
            } else if (control instanceof Text) {
                newval = ((Text)control).getText();
            }
            return newval;
        }
    }

    public class SaveCallback
    implements ITextPlugin.ICallback {
        @Override
        public void save() {
        }

        @Override
        public boolean saveAs() {
            return true;
        }
    }

    class TristateSelection
    implements SelectionListener {
        TristateSelection() {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.getSource();
            boolean selection = !button.getSelection();
            boolean grayed = button.getGrayed();
            if (selection) {
                if (grayed) {
                    button.setSelection(true);
                    button.setGrayed(false);
                } else {
                    button.setSelection(false);
                    button.setGrayed(false);
                }
            } else {
                button.setSelection(true);
                button.setGrayed(true);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

