/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.OrderEntryState;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.OrderServiceHolder;
import ch.elexis.core.services.holder.StockServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.DailyOrderDialog;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.dialogs.NeueBestellungDialog;
import ch.elexis.core.ui.dialogs.OrderImportDialog;
import ch.elexis.core.ui.dialogs.SelectBestellungDialog;
import ch.elexis.core.ui.editors.ContactSelectionDialogCellEditor;
import ch.elexis.core.ui.editors.ReflectiveEditingSupport;
import ch.elexis.core.ui.exchange.IDataSender;
import ch.elexis.core.ui.exchange.XChangeException;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.CoreUiUtil;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.TableViewerSorter;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.BestellBlatt;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.Bestellung;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.ExHandler;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.LoggerFactory;

public class BestellView
extends ViewPart {
    public static final String ID = "ch.elexis.BestellenView";
    private Form form;
    private FormToolkit tk = UiDesk.getToolkit();
    private TableViewer tv;
    private IOrder actOrder;
    private ViewMenus viewmenus;
    private IAction removeAction;
    private IAction dailyWizardAction;
    private IAction wizardAction;
    private IAction loadAction;
    private IAction printAction;
    private IAction sendAction;
    private IAction newAction;
    private IAction exportClipboardAction;
    private IAction checkInAction;
    private BestellungLabelProvider blp;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.form = this.tk.createForm(parent);
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        Table table = new Table(body, 66050);
        table.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        this.tv = new TableViewer(table);
        TableViewerColumn tvcNumber = new TableViewerColumn(this.tv, 0x1000000);
        tvcNumber.getColumn().setText(Messages.BestellView_Number);
        tvcNumber.getColumn().setWidth(40);
        ReflectiveEditingSupport poes = new ReflectiveEditingSupport(this.tv, ModelPackage.Literals.IORDER_ENTRY__AMOUNT.getName());
        poes.setModelService(CoreModelServiceHolder.get());
        tvcNumber.setEditingSupport((EditingSupport)poes);
        TableViewerColumn tvcArticle = new TableViewerColumn(this.tv, 16384);
        tvcArticle.getColumn().setText(Messages.BestellView_Article);
        tvcArticle.getColumn().setWidth(280);
        TableViewerColumn tvcDealer = new TableViewerColumn(this.tv, 16384);
        tvcDealer.getColumn().setText(Messages.BestellView_Dealer);
        tvcDealer.getColumn().setWidth(250);
        tvcDealer.setEditingSupport(new EditingSupport((ColumnViewer)this.tv){

            protected void setValue(Object element, Object value) {
                IOrderEntry se = (IOrderEntry)element;
                if (se == null) {
                    return;
                }
                se.setProvider((IContact)value);
                CoreModelServiceHolder.get().save((Identifiable)se);
                this.getViewer().refresh(element, true);
            }

            protected Object getValue(Object element) {
                IOrderEntry se = (IOrderEntry)element;
                if (se == null) {
                    return null;
                }
                return se.getProvider();
            }

            protected CellEditor getCellEditor(Object element) {
                return new ContactSelectionDialogCellEditor((Composite)((TableViewer)this.getViewer()).getTable(), "Lieferant ausw\u00e4hlen", "Bitte selektieren Sie den Lieferant");
            }

            protected boolean canEdit(Object element) {
                IOrderEntry be = (IOrderEntry)element;
                return be != null;
            }
        });
        TableViewerColumn tvc3 = new TableViewerColumn(this.tv, 16384);
        tvc3.getColumn().setText("Lager");
        tvc3.getColumn().setWidth(50);
        this.tv.setContentProvider((IContentProvider)new BestellungContentProvider());
        this.blp = new BestellungLabelProvider();
        this.tv.setLabelProvider((IBaseLabelProvider)this.blp);
        new TableViewerSorter(this.tv);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        this.tv.addDropSupport(1, types, (DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
            }

            public void drop(DropTargetEvent event) {
                if (event.data instanceof String) {
                    String[] parts = ((String)event.data).split(",");
                    if (BestellView.this.actOrder == null) {
                        NeueBestellungDialog nbDlg = new NeueBestellungDialog(BestellView.this.getViewSite().getShell(), Messages.BestellView_CreateNewOrder, Messages.BestellView_EnterOrderTitle);
                        if (nbDlg.open() == 0) {
                            IOrder created = (IOrder)CoreModelServiceHolder.get().create(IOrder.class);
                            created.setTimestamp(LocalDateTime.now());
                            created.setName(nbDlg.getTitle());
                            CoreModelServiceHolder.get().save((Identifiable)created);
                            BestellView.this.setOrder(created);
                        } else {
                            return;
                        }
                    }
                    ArrayList<IStockEntry> stockEntriesToOrder = new ArrayList<IStockEntry>();
                    String[] stringArray = parts;
                    int n = parts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String storeToString = stringArray[n2];
                        java.util.Optional dropped = StoreToStringServiceHolder.get().loadFromString(storeToString);
                        if (dropped.isPresent()) {
                            if (dropped.get() instanceof IStockEntry) {
                                stockEntriesToOrder.add((IStockEntry)dropped.get());
                            } else if (dropped.get() instanceof IArticle) {
                                IArticle art = (IArticle)dropped.get();
                                if (art.isProduct()) {
                                    return;
                                }
                                IStockEntry stockEntry = StockServiceHolder.get().findPreferredStockEntryForArticle(StoreToStringServiceHolder.getStoreToString((Object)art), null);
                                if (stockEntry != null) {
                                    stockEntriesToOrder.add(stockEntry);
                                } else {
                                    IOrderEntry orderEntry = BestellView.this.actOrder.addEntry(art, null, null, 1);
                                    CoreModelServiceHolder.get().save((Identifiable)orderEntry);
                                }
                            }
                        }
                        ++n2;
                    }
                    if (!stockEntriesToOrder.isEmpty()) {
                        for (IStockEntry iStockEntry : stockEntriesToOrder) {
                            IOrderEntry orderEntry = BestellView.this.actOrder.addEntry(iStockEntry.getArticle(), iStockEntry.getStock(), iStockEntry.getProvider(), 1);
                            CoreModelServiceHolder.get().save((Identifiable)orderEntry);
                        }
                    }
                    BestellView.this.tv.refresh();
                }
            }
        });
        this.makeActions();
        this.viewmenus = new ViewMenus(this.getViewSite());
        this.viewmenus.createToolbar(this.newAction, this.dailyWizardAction, this.wizardAction, this.loadAction, this.printAction, this.sendAction);
        this.viewmenus.createMenu(this.exportClipboardAction);
        this.viewmenus.createViewerContextMenu((StructuredViewer)this.tv, this.removeAction);
        this.form.getToolBarManager().add(this.checkInAction);
        this.form.updateToolBar();
        this.setOrder(null);
        this.tv.setInput((Object)this.getViewSite());
    }

    private void setOrder(IOrder order) {
        this.actOrder = order;
        if (order != null && !this.form.isDisposed()) {
            this.form.setText(order.getName());
            this.tv.refresh();
            this.updateCheckIn();
        } else {
            this.checkInAction.setEnabled(false);
            this.checkInAction.setToolTipText(Messages.BestellView_NoOrder);
        }
    }

    private void updateCheckIn() {
        if (this.actOrder.isDone()) {
            this.checkInAction.setEnabled(false);
            this.checkInAction.setToolTipText(Messages.BestellView_OrderIsClosed);
        } else {
            this.checkInAction.setEnabled(true);
            this.checkInAction.setToolTipText(Messages.BestellView_CheckInCaption);
        }
    }

    public void setFocus() {
    }

    private Map<IContact, List<IOrderEntry>> prepareOrderMap() {
        HashMap<IContact, List<IOrderEntry>> ret = new HashMap<IContact, List<IOrderEntry>>();
        List<Object> list = this.actOrder.getEntries();
        for (IOrderEntry iOrderEntry : list) {
            list = (List)ret.get(iOrderEntry.getProvider());
            if (list == null) {
                list = new ArrayList<IOrderEntry>();
            }
            list.add(iOrderEntry);
            ret.put(iOrderEntry.getProvider(), list);
        }
        for (List best : ret.values()) {
            best.sort((left, right) -> {
                String s1 = left.getArticle().getName();
                String s2 = right.getArticle().getName();
                return s1.compareTo(s2);
            });
        }
        return ret;
    }

    private List<IOrderEntry> prepareOrderList(IContact receiver) {
        ArrayList<IOrderEntry> best = new ArrayList<IOrderEntry>();
        List list = this.actOrder.getEntries();
        for (IOrderEntry iOrderEntry : list) {
            if (receiver == null && (receiver = iOrderEntry.getProvider()) == null || iOrderEntry.getProvider() == null || !iOrderEntry.getProvider().getId().equals(receiver.getId())) continue;
            best.add(iOrderEntry);
        }
        best.sort((left, right) -> {
            String s1 = left.getArticle().getName();
            String s2 = right.getArticle().getName();
            return s1.compareTo(s2);
        });
        return best;
    }

    private IOrder createOrder(String name) {
        IOrder order = (IOrder)CoreModelServiceHolder.get().create(IOrder.class);
        order.setTimestamp(LocalDateTime.now());
        order.setName(name);
        CoreModelServiceHolder.get().save((Identifiable)order);
        return order;
    }

    private void makeActions() {
        this.removeAction = new Action(Messages.BestellView_RemoveArticle){

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)BestellView.this.tv.getSelection();
                if (sel != null && !sel.isEmpty() && BestellView.this.actOrder != null) {
                    List selections = sel.toList();
                    for (IOrderEntry entry : selections) {
                        CoreModelServiceHolder.get().remove((Identifiable)entry);
                        CoreModelServiceHolder.get().refresh((Identifiable)BestellView.this.actOrder, true);
                    }
                    BestellView.this.tv.refresh();
                }
            }
        };
        this.dailyWizardAction = new Action(Messages.BestellView_AutomaticDailyOrder){
            {
                this.setToolTipText(Messages.BestellView_CreateAutomaticDailyOrder);
                this.setImageDescriptor(Images.IMG_WIZ_DAY.getImageDescriptor());
            }

            public void run() {
                if (BestellView.this.actOrder == null) {
                    IOrder order = (IOrder)CoreModelServiceHolder.get().create(IOrder.class);
                    order.setTimestamp(LocalDateTime.now());
                    order.setName(Messages.BestellView_AutomaticDaily);
                    CoreModelServiceHolder.get().save((Identifiable)order);
                    BestellView.this.setOrder(order);
                } else if (!BestellView.this.actOrder.getTimestamp().toLocalDate().equals(LocalDate.now()) && MessageDialog.openQuestion((Shell)BestellView.this.getSite().getShell(), (String)Messages.BestellView_Title, (String)Messages.BestellView_WizardAskNewOrder)) {
                    BestellView.this.setOrder(BestellView.this.createOrder(Messages.BestellView_Automatic));
                }
                DailyOrderDialog doDlg = new DailyOrderDialog(UiDesk.getTopShell(), BestellView.this.actOrder);
                doDlg.open();
                BestellView.this.updateCheckIn();
                BestellView.this.tv.refresh(true);
            }
        };
        this.wizardAction = new Action(Messages.BestellView_AutomaticOrder){
            {
                this.setToolTipText(Messages.BestellView_CreateAutomaticOrder);
                this.setImageDescriptor(Images.IMG_WIZARD.getImageDescriptor());
            }

            public void run() {
                if (BestellView.this.actOrder == null) {
                    BestellView.this.setOrder(BestellView.this.createOrder(Messages.BestellView_Automatic));
                } else if (!BestellView.this.actOrder.getTimestamp().toLocalDate().equals(LocalDate.now()) && MessageDialog.openQuestion((Shell)BestellView.this.getSite().getShell(), (String)Messages.BestellView_Title, (String)Messages.BestellView_WizardAskNewOrder)) {
                    BestellView.this.setOrder(BestellView.this.createOrder(Messages.BestellView_Automatic));
                }
                int trigger = ConfigServiceHolder.get().get("inventory/order_trigger", 0);
                boolean isInventoryBelow = trigger == 0;
                boolean excludeAlreadyOrderedItems = ConfigServiceHolder.get().get("inventory/order_exclude_already_ordered_items", false);
                IQuery query = CoreModelServiceHolder.get().getQuery(IStockEntry.class);
                query.andFeatureCompare((EStructuralFeature)ModelPackage.Literals.ISTOCK_ENTRY__CURRENT_STOCK, isInventoryBelow ? IQuery.COMPARATOR.LESS : IQuery.COMPARATOR.LESS_OR_EQUAL, (EStructuralFeature)ModelPackage.Literals.ISTOCK_ENTRY__MINIMUM_STOCK);
                List stockEntries = query.execute();
                for (IStockEntry stockEntry : stockEntries) {
                    if (stockEntry.getArticle() != null) {
                        IOrderEntry open;
                        if (excludeAlreadyOrderedItems && (open = OrderServiceHolder.get().findOpenOrderEntryForStockEntry(stockEntry)) != null) continue;
                        OrderServiceHolder.get().addRefillForStockEntryToOrder(stockEntry, BestellView.this.actOrder);
                        continue;
                    }
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Could not resolve article " + stockEntry.getLabel() + " of stock entry " + stockEntry.getId());
                }
                BestellView.this.updateCheckIn();
                BestellView.this.tv.refresh(true);
            }
        };
        this.newAction = new Action(Messages.BestellView_CreateNewOrder){

            public void run() {
                NeueBestellungDialog nbDlg = new NeueBestellungDialog(BestellView.this.getViewSite().getShell(), Messages.BestellView_CreateNewOrder, Messages.BestellView_EnterOrderTitle);
                if (nbDlg.open() != 0) {
                    return;
                }
                BestellView.this.setOrder(BestellView.this.createOrder(nbDlg.getTitle()));
                BestellView.this.tv.refresh();
            }
        };
        this.printAction = new Action(Messages.BestellView_PrintOrder){

            public void run() {
                if (BestellView.this.actOrder != null) {
                    Map orderMap = BestellView.this.prepareOrderMap();
                    for (IContact receiver : orderMap.keySet()) {
                        KontaktSelektor ksel;
                        List entries = (List)orderMap.get(receiver);
                        if (receiver == null && (ksel = new KontaktSelektor(BestellView.this.getViewSite().getShell(), Kontakt.class, ch.elexis.core.ui.text.Messages.TextContainer_SelectDestinationHeader, "Addressat f\u00fcr Eintr\u00e4ge ohne Lieferanten", Kontakt.DEFAULT_SORT)).open() == 0) {
                            receiver = NoPoUtil.loadAsIdentifiable((PersistentObject)((Kontakt)ksel.getSelection()), IContact.class).orElse(null);
                        }
                        if (receiver == null) continue;
                        try {
                            BestellBlatt bb = (BestellBlatt)BestellView.this.getViewSite().getPage().showView("ch.elexis.BestellBlatt", receiver.getId(), 3);
                            bb.createOrder(receiver, entries);
                            entries.stream().forEach(oe -> oe.setState(OrderEntryState.ORDERED));
                            BestellView.this.tv.refresh();
                        }
                        catch (Exception e) {
                            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error printing order", (Throwable)e);
                            MessageDialog.openError((Shell)BestellView.this.getViewSite().getShell(), (String)"Fehler", (String)("Beim Druck der Bestellung an " + receiver.getLabel() + " ist ein Fehler aufgetren."));
                        }
                    }
                }
            }
        };
        this.sendAction = new Action(Messages.BestellView_SendOrder){

            public void run() {
                if (BestellView.this.actOrder == null) {
                    return;
                }
                ArrayList<IOrderEntry> orderableItems = new ArrayList<IOrderEntry>();
                ArrayList<IOrderEntry> noSupplierItems = new ArrayList<IOrderEntry>();
                for (IOrderEntry orderEntry : BestellView.this.actOrder.getEntries()) {
                    IContact supplier = orderEntry.getProvider();
                    if (supplier != null) {
                        orderableItems.add(orderEntry);
                        continue;
                    }
                    noSupplierItems.add(orderEntry);
                }
                boolean runOrder = true;
                if (!noSupplierItems.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (IOrderEntry noSupItem : noSupplierItems) {
                        sb.append(noSupItem.getArticle().getLabel());
                        sb.append("\n");
                    }
                    runOrder = SWTHelper.askYesNo(Messages.BestellView_NoSupplierArticle, MessageFormat.format(Messages.BestellView_NoSupplierArticleMsg, sb.toString()));
                }
                if (runOrder) {
                    List list = Extensions.getExtensions((String)"ch.elexis.core.ui.Transporter");
                    for (IConfigurationElement ic : list) {
                        String handler = ic.getAttribute("type");
                        if (handler == null || !handler.contains(Bestellung.class.getName())) continue;
                        try {
                            IDataSender sender = (IDataSender)ic.createExecutableExtension("ExporterClass");
                            sender.store(BestellView.this.actOrder);
                            sender.finalizeExport();
                            SWTHelper.showInfo(Messages.BestellView_OrderSentCaption, Messages.BestellView_OrderSentBody);
                            BestellView.this.tv.refresh();
                            orderableItems.stream().forEach(oe -> oe.setState(OrderEntryState.ORDERED));
                        }
                        catch (CoreException ex) {
                            ExHandler.handle((Throwable)ex);
                        }
                        catch (XChangeException xx) {
                            SWTHelper.showError(Messages.BestellView_OrderNotPossible, String.valueOf(Messages.BestellView_NoAutomaticOrderAvailable) + xx.getLocalizedMessage());
                        }
                    }
                }
            }
        };
        this.loadAction = new Action(Messages.BestellView_OpenOrder){

            public void run() {
                SelectBestellungDialog dlg = new SelectBestellungDialog(BestellView.this.getViewSite().getShell());
                dlg.setMessage(Messages.BestellView_SelectOrder);
                dlg.setTitle(Messages.BestellView_ReadOrder);
                if (dlg.open() == 0 && dlg.getResult().length > 0) {
                    BestellView.this.setOrder((IOrder)dlg.getResult()[0]);
                }
            }
        };
        this.printAction.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
        this.printAction.setToolTipText(Messages.BestellView_PrintOrder);
        this.newAction.setImageDescriptor(Images.IMG_ADDITEM.getImageDescriptor());
        this.newAction.setToolTipText(Messages.BestellView_CreateNewOrder);
        this.sendAction.setImageDescriptor(Images.IMG_NETWORK.getImageDescriptor());
        this.sendAction.setToolTipText(Messages.BestellView_transmitOrder);
        this.loadAction.setImageDescriptor(Images.IMG_IMPORT.getImageDescriptor());
        this.loadAction.setToolTipText(Messages.BestellView_loadEarlierOrder);
        this.exportClipboardAction = new Action(Messages.BestellView_copyToClipboard){
            {
                this.setToolTipText(Messages.BestellView_copyToClipBioardForGalexis);
            }

            public void run() {
                if (BestellView.this.actOrder != null) {
                    List toOrder = BestellView.this.prepareOrderList(null);
                    StringBuffer export = new StringBuffer();
                    for (IOrderEntry orderEntry : toOrder) {
                        String code = orderEntry.getArticle().getCode();
                        int num = orderEntry.getAmount();
                        String name = orderEntry.getArticle().getName();
                        String line = String.valueOf(code) + ", " + num + ", " + name;
                        export.append(line);
                        export.append(System.getProperty("line.separator"));
                    }
                    String clipboardText = export.toString();
                    Clipboard clipboard = new Clipboard(UiDesk.getDisplay());
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    Transfer[] transfers = new Transfer[]{textTransfer};
                    Object[] data = new Object[]{clipboardText};
                    clipboard.setContents(data, transfers);
                    clipboard.dispose();
                }
            }
        };
        this.checkInAction = new Action(Messages.BestellView_CheckInCaption){
            {
                this.setImageDescriptor(Images.IMG_TICK.getImageDescriptor());
                this.setToolTipText(Messages.BestellView_CheckInBody);
            }

            public void run() {
                if (BestellView.this.actOrder != null) {
                    OrderImportDialog dialog = new OrderImportDialog(BestellView.this.getSite().getShell(), BestellView.this.actOrder);
                    dialog.open();
                    BestellView.this.updateCheckIn();
                } else {
                    SWTHelper.alert(Messages.BestellView_NoOrder, Messages.BestellView_NoOrderLoaded);
                }
            }
        };
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout(part, currentState);
    }

    public void addItemsToOrder(List<IArticle> articlesToOrder) {
        if (this.actOrder == null) {
            NeueBestellungDialog nbDlg = new NeueBestellungDialog(this.getViewSite().getShell(), Messages.BestellView_CreateNewOrder, Messages.BestellView_EnterOrderTitle);
            if (nbDlg.open() == 0) {
                this.setOrder(this.createOrder(nbDlg.getTitle()));
            } else {
                return;
            }
        }
        for (IArticle article : articlesToOrder) {
            IOrderEntry orderEntry = this.actOrder.addEntry(article, null, null, 1);
            CoreModelServiceHolder.get().save((Identifiable)orderEntry);
        }
        if (this.tv != null && !this.tv.getControl().isDisposed()) {
            this.tv.refresh();
        }
    }

    public IOrder getOrder() {
        return this.actOrder;
    }

    public static IContact resolveDefaultSupplier(String cfgSupplier, String selDialogTitle) {
        IContact supplier = null;
        if (cfgSupplier != null && !cfgSupplier.isEmpty()) {
            supplier = CoreModelServiceHolder.get().load(cfgSupplier, IContact.class).orElse(null);
        }
        if (supplier == null) {
            MessageDialog.openWarning((Shell)UiDesk.getTopShell(), (String)selDialogTitle, (String)Messages.BestellView_CantOrderNoSupplier);
        }
        return supplier;
    }

    private class BestellungContentProvider
    implements IStructuredContentProvider,
    TableViewerSorter.IColumnContentProvider {
        private BestellungContentProvider() {
        }

        @Override
        public Comparable<?> getValue(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((IOrderEntry)element).getAmount();
            }
            return BestellView.this.blp.getColumnText(element, columnIndex);
        }

        public Object[] getElements(Object inputElement) {
            if (BestellView.this.actOrder != null) {
                return BestellView.this.actOrder.getEntries().toArray();
            }
            return new Object[0];
        }
    }

    private class BestellungLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private BestellungLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IOrderEntry entry = (IOrderEntry)element;
            switch (columnIndex) {
                case 0: {
                    return Integer.toString(entry.getAmount());
                }
                case 1: {
                    return entry.getArticle().getLabel();
                }
                case 2: {
                    IContact k = entry.getProvider();
                    return k != null ? k.getLabel() : Messages.BestellView_Unknown;
                }
                case 3: {
                    IStock s = entry.getStock();
                    return s != null ? s.getCode() : "";
                }
            }
            return "?";
        }
    }
}

