/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util.viewers;

import ch.elexis.core.services.IQuery;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class CommonViewerContentProvider
implements ViewerConfigurer.ICommonViewerContentProvider {
    protected CommonViewer commonViewer;
    protected Map<String, String> fieldFilterValues;
    protected String fieldOrderBy;
    protected IQuery.ORDER fieldOrder = IQuery.ORDER.DESC;
    protected String[] orderFields;
    protected List<QueryFilter> queryFilters = new ArrayList<QueryFilter>();
    protected boolean ignoreLimit;

    public CommonViewerContentProvider(CommonViewer commonViewer) {
        this.commonViewer = commonViewer;
    }

    @Override
    public void changed(HashMap<String, String> values) {
        if (this.commonViewer.getConfigurer().getControlFieldProvider().isEmpty()) {
            this.commonViewer.notify(CommonViewer.Message.empty);
        } else {
            this.commonViewer.notify(CommonViewer.Message.notempty);
        }
        this.fieldFilterValues = values;
        this.commonViewer.notify(CommonViewer.Message.update);
    }

    @Override
    public void reorder(String field) {
        this.fieldOrder = this.fieldOrderBy != null && this.fieldOrderBy.equals(field) ? (this.fieldOrder == IQuery.ORDER.DESC ? IQuery.ORDER.ASC : IQuery.ORDER.DESC) : IQuery.ORDER.DESC;
        this.fieldOrderBy = field;
        this.commonViewer.notify(CommonViewer.Message.update);
    }

    public void setOrderFields(String ... name) {
        this.orderFields = name;
    }

    @Override
    public void selected() {
    }

    @Override
    public void init() {
    }

    @Override
    public void startListening() {
        this.commonViewer.getConfigurer().controlFieldProvider.addChangeListener(this);
    }

    @Override
    public void stopListening() {
        this.commonViewer.getConfigurer().controlFieldProvider.removeChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueryFilter> getQueryFilters() {
        List<QueryFilter> list = this.queryFilters;
        synchronized (list) {
            return new ArrayList<QueryFilter>(this.queryFilters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueryFilter(QueryFilter queryFilter) {
        List<QueryFilter> list = this.queryFilters;
        synchronized (list) {
            if (!this.queryFilters.contains(queryFilter)) {
                this.queryFilters.add(queryFilter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueryFilter(QueryFilter queryFilter) {
        List<QueryFilter> list = this.queryFilters;
        synchronized (list) {
            if (this.queryFilters.contains(queryFilter)) {
                this.queryFilters.remove(queryFilter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllQueryFilterByType(Class<?> clazz) {
        List<QueryFilter> list = this.queryFilters;
        synchronized (list) {
            for (QueryFilter queryFilter : new ArrayList<QueryFilter>(this.queryFilters)) {
                if (!clazz.isInstance(queryFilter)) continue;
                this.queryFilters.remove(queryFilter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isQueryFilterByType(Class<?> clazz) {
        List<QueryFilter> list = this.queryFilters;
        synchronized (list) {
            QueryFilter queryFilter;
            Iterator<QueryFilter> iterator = new ArrayList<QueryFilter>(this.queryFilters).iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!clazz.isInstance(queryFilter = iterator.next()));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Optional<T> getQueryFilterByType(Class<T> clazz) {
        List<QueryFilter> list = this.queryFilters;
        synchronized (list) {
            for (QueryFilter queryFilter : new ArrayList<QueryFilter>(this.queryFilters)) {
                if (!clazz.isInstance(queryFilter)) continue;
                return Optional.of(queryFilter);
            }
        }
        return null;
    }

    protected abstract IQuery<?> getBaseQuery();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyQueryFilters(IQuery<?> query) {
        if (query != null) {
            List<QueryFilter> list = this.queryFilters;
            synchronized (list) {
                for (QueryFilter fp : this.queryFilters) {
                    fp.apply(query);
                }
            }
        }
    }

    protected void setIgnoreLimit(boolean value) {
        this.ignoreLimit = value;
    }

    public static interface QueryFilter {
        public void apply(IQuery<?> var1);
    }
}

