/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.model.IImage;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.views.codesystems.ContributionAction;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"event.topics=org/eclipse/e4/ui/LifeCycle/appStartupComplete"})
public class CoreUiUtil
implements EventHandler {
    private static Logger logger = LoggerFactory.getLogger(CoreUiUtil.class);
    private static Object lock = new Object();
    private static IEclipseContext applicationContext;
    private static IEclipseContext serviceContext;
    private static List<Object> delayedInjection;

    static {
        delayedInjection = new ArrayList<Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        logger.info("APPLICATION STARTUP COMPLETE");
        Object object = lock;
        synchronized (object) {
            Object property = event.getProperty("org.eclipse.e4.data");
            if (property instanceof MApplication) {
                MApplication application = (MApplication)property;
                applicationContext = application.getContext();
                if (!delayedInjection.isEmpty()) {
                    for (Object object2 : delayedInjection) {
                        Display.getDefault().asyncExec(() -> CoreUiUtil.injectServices(object2));
                    }
                    delayedInjection.clear();
                }
            }
        }
    }

    public static void injectServices(Object object) {
        if (serviceContext == null) {
            BundleContext bundleContext = FrameworkUtil.getBundle(CoreUiUtil.class).getBundleContext();
            serviceContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        }
        try {
            ContextInjectionFactory.inject((Object)object, (IEclipseContext)serviceContext);
        }
        catch (InjectionException e) {
            logger.warn("Service injection failure ", (Throwable)e);
        }
        if (applicationContext != null) {
            try {
                ContextInjectionFactory.inject((Object)object, (IEclipseContext)applicationContext);
            }
            catch (InjectionException e) {
                logger.warn("Application context injection failure ", (Throwable)e);
            }
        }
    }

    public static void injectServices(Object object, IEclipseContext context) {
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
    }

    public static boolean isActiveControl(Control control) {
        return control != null && !control.isDisposed() && control.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void injectServicesWithContext(Object object) {
        Object object2 = lock;
        synchronized (object2) {
            if (applicationContext != null) {
                CoreUiUtil.injectServices(object);
            } else {
                delayedInjection.add(object);
            }
        }
    }

    public static Color getColorForString(String colorString) {
        colorString = StringUtils.leftPad((String)colorString, (int)6, (char)'0');
        if (!UiDesk.getColorRegistry().hasValueFor(colorString)) {
            RGB rgb;
            try {
                rgb = new RGB(Integer.parseInt(colorString.substring(0, 2), 16), Integer.parseInt(colorString.substring(2, 4), 16), Integer.parseInt(colorString.substring(4, 6), 16));
            }
            catch (NumberFormatException nex) {
                logger.warn("Error parsing color string [" + colorString + "]", (Throwable)nex);
                rgb = new RGB(100, 100, 100);
            }
            UiDesk.getColorRegistry().put(colorString, rgb);
        }
        return UiDesk.getColorRegistry().get(colorString);
    }

    public static Image getImageAsIcon(IImage image) {
        Image origImage;
        Image ret = UiDesk.getImageRegistry().get(String.valueOf(image.getId()) + "_16x16");
        if (ret == null && (ret = CoreUiUtil.getImageScaledTo(origImage = CoreUiUtil.getImage(image), 16, 16, false)) != null) {
            UiDesk.getImageRegistry().put(String.valueOf(image.getId()) + "_16x16", ret);
        }
        return ret;
    }

    public static Image getImage(IImage image) {
        Image ret = UiDesk.getImageRegistry().get(image.getId());
        if (ret == null) {
            byte[] in = image.getImage();
            ByteArrayInputStream bais = new ByteArrayInputStream(in);
            try {
                ImageData idata = new ImageData((InputStream)bais);
                ret = new Image((Device)Display.getDefault(), idata);
                if (ret != null) {
                    UiDesk.getImageRegistry().put(image.getId(), ret);
                }
            }
            catch (Exception ex) {
                logger.error("Error loading image [" + image.getId() + "]", (Throwable)ex);
            }
        }
        return ret;
    }

    private static Image getImageScaledTo(Image orig, int width, int height, boolean bShrinkOnly) {
        ImageData idata = orig.getImageData();
        if (idata.width != width || idata.height != height) {
            idata = idata.scaledTo(width, height);
        }
        Image ret = new Image((Device)Display.getDefault(), idata);
        return ret;
    }

    public static Composite createForm(Composite parent, ISticker iSticker) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(2, false));
        Image img = null;
        if (iSticker.getImage() != null) {
            img = CoreUiUtil.getImageAsIcon(iSticker.getImage());
        }
        GridData gd1 = null;
        GridData gd2 = null;
        Composite cImg = new Composite(ret, 0);
        if (img != null) {
            cImg.setBackgroundImage(img);
            gd1 = new GridData(img.getBounds().width, img.getBounds().height);
            gd2 = new GridData(-1, img.getBounds().height);
        } else {
            gd1 = new GridData(10, 10);
            gd2 = new GridData(-1, -1);
        }
        cImg.setLayoutData((Object)gd1);
        Label lbl = new Label(ret, 0);
        lbl.setLayoutData((Object)gd2);
        lbl.setText(iSticker.getLabel());
        lbl.setForeground(CoreUiUtil.getColorForString(iSticker.getForeground()));
        lbl.setBackground(CoreUiUtil.getColorForString(iSticker.getBackground()));
        return ret;
    }

    public static void addCommandContributions(IMenuManager manager, Object[] selection, String location) {
        List contributions = Extensions.getExtensions((String)"org.eclipse.ui.menus");
        ArrayList contributionActions = new ArrayList();
        for (IConfigurationElement contributionElement : contributions) {
            IConfigurationElement[] commands;
            String locationUri = contributionElement.getAttribute("locationURI");
            if (!location.equals(locationUri) || (commands = contributionElement.getChildren("command")).length <= 0) continue;
            IConfigurationElement[] iConfigurationElementArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                CoreUiUtil.getMenuContribution(iConfigurationElement, selection).ifPresent(a -> {
                    boolean bl = contributionActions.add(a);
                });
                ++n2;
            }
        }
        if (!contributionActions.isEmpty()) {
            manager.add((IContributionItem)new Separator());
            contributionActions.forEach(a -> manager.add((IAction)a));
        }
    }

    private static Optional<ContributionAction> getMenuContribution(IConfigurationElement commandElement, Object[] selection) {
        ContributionAction action = new ContributionAction(commandElement);
        action.setSelection(selection);
        if (action.isValid() && action.isVisible()) {
            return Optional.of(action);
        }
        return Optional.empty();
    }

    public static StructuredSelection getCommandSelection(IEclipseContext iEclipseContext, String commandId) {
        return CoreUiUtil.getCommandSelection(iEclipseContext, commandId, true);
    }

    public static StructuredSelection getCommandSelection(IEclipseContext iEclipseContext, String commandId, boolean remove) {
        StructuredSelection selection = (StructuredSelection)iEclipseContext.get(commandId.concat(".selection"));
        if (remove) {
            iEclipseContext.remove(commandId.concat(".selection"));
        }
        return selection;
    }

    public static void setCommandSelection(String commandId, Object[] selection) {
        ((IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class)).set(commandId.concat(".selection"), (Object)new StructuredSelection(selection));
    }

    public static void setCommandSelection(String commandId, List<?> selection) {
        CoreUiUtil.setCommandSelection(commandId, selection.toArray());
    }

    public static void updateFixLayout(MPart part, boolean state) {
        part.setCloseable(state);
        part.setCloseable(!state);
        if (state) {
            if (!part.getTags().contains("NoMove")) {
                part.getTags().add("NoMove");
            }
        } else {
            part.getTags().remove("NoMove");
        }
    }
}

