/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.propertypage;

import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.Gender;
import ch.elexis.core.ui.locks.IUnlockable;
import ch.elexis.core.ui.util.SWTHelper;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class PatientPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage,
IUnlockable {
    public static final String ID = "at.medevit.elexis.properties.propertyPage.PatientPropertyPage";
    private IPatient pat;
    private Text textVorname;
    private Text textNachname;
    private Text textTelefon1;
    private Text textTelefon2;
    private Text textHandy;
    private Text textFax;
    private Text textEmail;
    private Text textBemerkungen;
    private CDateTime geburtsdatum;
    private ComboViewer comboGeschlecht;

    protected Control createContents(Composite parent) {
        this.init();
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label lblVorname = new Label(comp, 0);
        lblVorname.setLayoutData((Object)new GridData(131072, 1024, false, false, 1, 1));
        lblVorname.setText(Messages.KontaktBlatt_FirstName);
        this.textVorname = new Text(comp, 2048);
        this.textVorname.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblNachname = new Label(comp, 0);
        lblNachname.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNachname.setText(Messages.KontaktBlatt_LastName);
        this.textNachname = new Text(comp, 2048);
        this.textNachname.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblGeschlecht = new Label(comp, 0);
        lblGeschlecht.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblGeschlecht.setText(Messages.KontaktBlatt_Sex);
        String toolTip = String.format(Messages.Patient_male_female_tooltip, Messages.Patient_male_short, Messages.Patient_female_short, Messages.Patient_male_long, Messages.Patient_female_long);
        this.comboGeschlecht = new ComboViewer(comp, 0);
        this.comboGeschlecht.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboGeschlecht.setInput((Object)Gender.values());
        this.comboGeschlecht.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Gender)element).value();
            }
        });
        this.comboGeschlecht.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblGeburtsdatum = new Label(comp, 0);
        lblGeburtsdatum.setText(Messages.KontaktDetailDialog_labelBirthdate);
        this.geburtsdatum = new CDateTime(comp, 2098179);
        this.geburtsdatum.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        new Label(comp, 0);
        new Label(comp, 0);
        Label lblTelefon1 = new Label(comp, 0);
        lblTelefon1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTelefon1.setText(Messages.KontaktBlatt_Phone1);
        this.textTelefon1 = new Text(comp, 2048);
        this.textTelefon1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblTelefon2 = new Label(comp, 0);
        lblTelefon2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTelefon2.setText(Messages.KontaktBlatt_Phone2);
        this.textTelefon2 = new Text(comp, 2048);
        this.textTelefon2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblHandy = new Label(comp, 0);
        lblHandy.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblHandy.setText(Messages.KontaktBlatt_Mobile);
        this.textHandy = new Text(comp, 2048);
        this.textHandy.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblFax = new Label(comp, 0);
        lblFax.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFax.setText(Messages.KontaktBlatt_Fax);
        this.textFax = new Text(comp, 2048);
        this.textFax.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(comp, 0);
        new Label(comp, 0);
        Label lblEmail = new Label(comp, 0);
        lblEmail.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblEmail.setText(Messages.KontaktBlatt_Mail);
        this.textEmail = new Text(comp, 2048);
        this.textEmail.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(comp, 0);
        new Label(comp, 0);
        Label lblBemerkungen = new Label(comp, 0);
        lblBemerkungen.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        lblBemerkungen.setText(Messages.KontaktBlatt_remark);
        this.textBemerkungen = new Text(comp, 2050);
        this.textBemerkungen.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        super.setTitle(this.pat.getLabel());
        this.textVorname.setText(this.pat.getFirstName());
        this.textNachname.setText(this.pat.getLastName());
        this.geburtsdatum.setSelection(this.getGeburtsdatum());
        this.comboGeschlecht.setSelection((ISelection)new StructuredSelection((Object)this.pat.getGender()));
        this.textTelefon1.setText(this.pat.getPhone1());
        this.textTelefon2.setText(this.pat.getPhone2());
        this.textFax.setText(this.pat.getFax());
        this.textHandy.setText(this.pat.getMobile());
        this.textEmail.setText(this.pat.getEmail());
        this.textBemerkungen.setText(this.pat.getComment());
        this.setUnlocked(LocalLockServiceHolder.get().isLocked((Object)this.pat));
        return comp;
    }

    private void init() {
        IAdaptable adapt = this.getElement();
        this.pat = (IPatient)adapt.getAdapter(IPatient.class);
    }

    private Date getGeburtsdatum() {
        LocalDateTime dob = this.pat.getDateOfBirth();
        if (dob != null) {
            return Date.from(dob.atZone(ZoneId.systemDefault()).toInstant());
        }
        return null;
    }

    protected void performApply() {
        StructuredSelection genderSelection = (StructuredSelection)this.comboGeschlecht.getSelection();
        if (genderSelection == null || genderSelection.isEmpty()) {
            SWTHelper.showError(Messages.PatientErfassenDialog_Error_Sex, Messages.PatientErfassenDialog_Sex_must_be_specified);
            return;
        }
        this.pat.setGender((Gender)genderSelection.getFirstElement());
        Date bd = this.geburtsdatum.getSelection();
        if (bd != null) {
            this.pat.setDateOfBirth(LocalDateTime.ofInstant(bd.toInstant(), ZoneId.systemDefault()));
        }
        this.pat.setLastName(this.textNachname.getText());
        this.pat.setFirstName(this.textVorname.getText());
        this.pat.setEmail(this.textEmail.getText());
        this.pat.setPhone1(this.textTelefon1.getText());
        this.pat.setPhone2(this.textTelefon2.getText());
        this.pat.setMobile(this.textHandy.getText());
        this.pat.setComment(this.textBemerkungen.getText());
        this.pat.setFax(this.textFax.getText());
        CoreModelServiceHolder.get().save((Identifiable)this.pat);
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    @Override
    public void setUnlocked(boolean unlocked) {
        this.textVorname.setEditable(unlocked);
        this.textNachname.setEditable(unlocked);
        this.textTelefon1.setEditable(unlocked);
        this.textTelefon2.setEditable(unlocked);
        this.textHandy.setEditable(unlocked);
        this.textFax.setEditable(unlocked);
        this.textEmail.setEditable(unlocked);
        this.textBemerkungen.setEditable(unlocked);
        this.geburtsdatum.setEditable(unlocked);
        this.comboGeschlecht.getControl().setEnabled(unlocked);
    }
}

