/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.processor;

import java.util.List;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElexisProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ElexisProcessor.class);
    private MApplication mApplication;
    private EModelService eModelService;
    private static String[] removeModelElements = new String[]{"ch.elexis.SchwarzesBrett"};
    private String[] e4ViewIds = new String[]{"at.medevit.elexis.agenda.ui.view.agenda", "at.medevit.elexis.agenda.ui.view.parallel", "at.medevit.elexis.agenda.ui.view.week"};

    @Execute
    public void execute(MApplication mApplication, EModelService eModelService) {
        this.mApplication = mApplication;
        this.eModelService = eModelService;
        if (eModelService != null) {
            this.updateModelVersions(mApplication, eModelService);
        }
        this.updateToolbar();
        this.updateInjectViews();
        this.updateE4Views();
    }

    private void updateToolbar() {
        MTrimBar mTrimBar = (MTrimBar)this.eModelService.find("org.eclipse.ui.main.toolbar", (MUIElement)this.mApplication);
        if (mTrimBar != null && mTrimBar.getChildren() != null) {
            mTrimBar.getChildren().clear();
        }
    }

    private void updateInjectViews() {
        List foundParts = this.eModelService.findElements((MUIElement)this.mApplication, null, MPart.class, null);
        for (MPart mPart : foundParts) {
            List tags;
            if (!mPart.getContributionURI().endsWith("e4.compatibility.CompatibilityView") || (tags = mPart.getTags()).contains("inject")) continue;
            tags.add("inject");
        }
    }

    private void updateE4Views() {
        String[] stringArray = this.e4ViewIds;
        int n = this.e4ViewIds.length;
        int n2 = 0;
        while (n2 < n) {
            String viewId = stringArray[n2];
            List foundParts = this.eModelService.findElements((MUIElement)this.mApplication, viewId, MPart.class, null);
            for (MPart mPart : foundParts) {
                if (mPart.getContributionURI() != null && !mPart.getContributionURI().endsWith("CompatibilityView")) continue;
                EcoreUtil.delete((EObject)((EObject)mPart));
            }
            ++n2;
        }
    }

    private void updateModelVersions(MApplication mApplication, EModelService eModelService) {
        try {
            List windows = mApplication.getChildren();
            if (!windows.isEmpty() && windows.get(0) instanceof MTrimmedWindow) {
                MTrimmedWindow mWindow = (MTrimmedWindow)windows.get(0);
                String[] stringArray = removeModelElements;
                int n = removeModelElements.length;
                int n2 = 0;
                while (n2 < n) {
                    String modelElementId = stringArray[n2];
                    MUIElement element = eModelService.find(modelElementId, (MUIElement)mApplication);
                    if (element != null) {
                        if (element instanceof MPerspective) {
                            eModelService.removePerspectiveModel((MPerspective)element, (MWindow)mWindow);
                            logger.info("model element (perspective): " + modelElementId + " removed!");
                        } else {
                            MElementContainer parent = element.getParent();
                            parent.getChildren().remove(element);
                            element.setToBeRendered(false);
                            logger.info("model element: " + modelElementId + " removed!");
                        }
                    }
                    ++n2;
                }
            } else {
                logger.warn("cannot find active window");
            }
        }
        catch (Exception e) {
            logger.error("unexpected exception - cannot do updates on models", (Throwable)e);
        }
    }
}

