/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.core.data.util.SortedList;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.ui.dialogs.DiagnoseSelektor;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.preferences.Messages;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.BillingSystem;
import ch.elexis.data.Fall;
import ch.rgw.io.InMemorySettings;
import ch.rgw.io.Settings;
import ch.rgw.tools.StringTool;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class UserCasePreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "ch.elexis.preferences.UserCasePreferences";
    public static final String MENUSEPARATOR = "------------------------------------";
    private static final String PREFSDELIMITER = "`^";
    private static final String PREFSDELIMITER_REGEX = "\\`\\^";
    Text diagnoseTxt;
    List sorterList2;
    Button btnToManual;
    Button btnToNotPresorted;
    Button btnUp;
    Button btnDown;
    LinkedList<String> topItemsLinkedList = new LinkedList();

    public UserCasePreferences() {
        super(1);
        this.setPreferenceStore(new SettingsPreferenceStore((Settings)new InMemorySettings()));
        this.setDescription(Messages.UserCasePreferences_Cases);
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new StringFieldEditor("fall/std_label", Messages.UserCasePreferences_DefaultName, this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("fall/std_grund", Messages.UserCasePreferences_DefaultReason, this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("fall/std_gesetz", Messages.UserCasePreferences_DefaultBillingSystem, this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
        this.getPreferenceStore().setValue("fall/std_label", Fall.getDefaultCaseLabel());
        this.getPreferenceStore().setValue("fall/std_grund", Fall.getDefaultCaseReason());
        this.getPreferenceStore().setValue("fall/std_gesetz", Fall.getDefaultCaseLaw());
        String topItemsSortingStr = ConfigServiceHolder.getUser((String)"fall/topitemssorting", (String)"");
        String[] topItemsSorting = topItemsSortingStr.split(PREFSDELIMITER_REGEX);
        this.topItemsLinkedList = new LinkedList<String>(Arrays.asList(topItemsSorting));
    }

    public boolean performOk() {
        super.performOk();
        ConfigServiceHolder.setUser((String)"fall/std_label", (String)this.getPreferenceStore().getString("fall/std_label"));
        ConfigServiceHolder.setUser((String)"fall/std_grund", (String)this.getPreferenceStore().getString("fall/std_grund"));
        ConfigServiceHolder.setUser((String)"fall/std_gesetz", (String)this.getPreferenceStore().getString("fall/std_gesetz"));
        String[] topItemsSorting = new String[this.topItemsLinkedList.size()];
        this.topItemsLinkedList.toArray(topItemsSorting);
        String topItemsSortingStr = StringTool.join((String[])topItemsSorting, (String)PREFSDELIMITER);
        ConfigServiceHolder.setUser((String)"fall/topitemssorting", (String)topItemsSortingStr);
        return true;
    }

    protected Control createContents(Composite parent) {
        Identifiable diagnose;
        Control suParent = super.createContents(parent);
        Composite diagnoseParent = new Composite((Composite)suParent, 0);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        diagnoseParent.setLayoutData((Object)gd);
        diagnoseParent.setLayout((Layout)new FormLayout());
        Label diagnoseLbl = new Label(diagnoseParent, 0);
        diagnoseLbl.setText(Messages.UserCasePreferences_DefaultDiagnose);
        this.diagnoseTxt = new Text(diagnoseParent, 2048);
        this.diagnoseTxt.setEditable(false);
        String diagnoseId = ConfigServiceHolder.getUser((String)"fall/std_diagnose", (String)"");
        if (diagnoseId.length() > 1 && (diagnose = (Identifiable)StoreToStringServiceHolder.get().loadFromString(diagnoseId).orElse(null)) != null) {
            this.diagnoseTxt.setText(diagnose.getLabel());
        }
        Button diagnoseBtn = new Button(diagnoseParent, 8);
        diagnoseBtn.setText("Diagnose");
        diagnoseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiagnoseSelektor dsl = new DiagnoseSelektor(UserCasePreferences.this.getShell());
                if (dsl.open() == 0) {
                    Object[] sel = dsl.getResult();
                    if (sel != null && sel.length > 0) {
                        Identifiable diagnose = (Identifiable)sel[0];
                        String storeToString = StoreToStringServiceHolder.getStoreToString((Object)diagnose);
                        ConfigServiceHolder.setUser((String)"fall/std_diagnose", (String)storeToString);
                        UserCasePreferences.this.diagnoseTxt.setText(diagnose.getLabel());
                    } else {
                        ConfigServiceHolder.setUser((String)"fall/std_diagnose", (String)"");
                        UserCasePreferences.this.diagnoseTxt.setText("");
                    }
                }
            }
        });
        Button diagnoseDelBtn = new Button(diagnoseParent, 8);
        diagnoseDelBtn.setImage(Images.IMG_DELETE.getImage());
        diagnoseDelBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigServiceHolder.setUser((String)"fall/std_diagnose", (String)"");
                UserCasePreferences.this.diagnoseTxt.setText("");
            }
        });
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment(0, 0);
        diagnoseLbl.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)diagnoseLbl, 0, 0x1000000);
        fd.left = new FormAttachment((Control)diagnoseLbl, 5);
        fd.right = new FormAttachment((Control)diagnoseBtn, -5);
        this.diagnoseTxt.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)diagnoseLbl, 0, 0x1000000);
        fd.right = new FormAttachment((Control)diagnoseDelBtn, -5);
        diagnoseBtn.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)diagnoseLbl, 0, 0x1000000);
        fd.right = new FormAttachment(100, -5);
        diagnoseDelBtn.setLayoutData((Object)fd);
        Composite lastConsParent = new Composite((Composite)suParent, 0);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        lastConsParent.setLayoutData((Object)gd);
        lastConsParent.setLayout((Layout)new FormLayout());
        Label lastConsLbl = new Label(lastConsParent, 0);
        lastConsLbl.setText(Messages.UserCasePreferences_LoadConsultationAll);
        final Button lastConsBtn = new Button(lastConsParent, 32);
        lastConsBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (lastConsBtn.getSelection()) {
                    ConfigServiceHolder.setUser((String)"fall/load_consall", (boolean)true);
                } else {
                    ConfigServiceHolder.setUser((String)"fall/load_consall", (boolean)false);
                }
            }
        });
        lastConsBtn.setSelection(ConfigServiceHolder.getUser((String)"fall/load_consall", (boolean)false));
        fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment(0, 0);
        lastConsLbl.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        lastConsBtn.setLayoutData((Object)fd);
        new Label(this.getFieldEditorParent(), 258).setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
        Label infoTxt = new Label(this.getFieldEditorParent(), 0);
        infoTxt.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
        infoTxt.setText(Messages.UserCasePreferences_InfoLabelForSortingBillingSystems);
        Label lllabel2 = new Label(this.getFieldEditorParent(), 0);
        lllabel2.setText("");
        Composite sorterListComp = new Composite(this.getFieldEditorParent(), 0);
        GridLayout sorterListLayout = new GridLayout();
        sorterListLayout.marginWidth = 0;
        sorterListLayout.marginHeight = 0;
        sorterListLayout.numColumns = 2;
        sorterListComp.setLayout((Layout)sorterListLayout);
        this.sorterList2 = new List(sorterListComp, 2048);
        this.sorterList2.setItems(UserCasePreferences.sortBillingSystems(BillingSystem.getAbrechnungsSysteme(), this.topItemsLinkedList, true));
        this.sorterList2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UserCasePreferences.this.setButtonEnabling();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite sorterListCompButtons = new Composite(sorterListComp, 2048);
        GridLayout sorterListCompButtonsLayout = new GridLayout();
        sorterListLayout.marginWidth = 0;
        sorterListLayout.marginHeight = 0;
        sorterListLayout.horizontalSpacing = 0;
        sorterListLayout.verticalSpacing = 0;
        sorterListLayout.marginTop = 0;
        sorterListLayout.marginBottom = 0;
        sorterListLayout.marginLeft = 0;
        sorterListLayout.marginRight = 0;
        sorterListCompButtons.setLayout((Layout)sorterListCompButtonsLayout);
        GridData sorterGridData = new GridData();
        sorterGridData.verticalAlignment = 128;
        sorterGridData.horizontalSpan = 0;
        sorterGridData.grabExcessVerticalSpace = true;
        sorterListCompButtons.setLayoutData((Object)sorterGridData);
        this.btnUp = new Button(sorterListCompButtons, 0);
        this.btnUp.setToolTipText(Messages.UserCasePreferences_MoveItemUpInList);
        this.btnUp.setImage(Images.IMG_ARROWUP.getImage());
        this.btnUp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UserCasePreferences.this.moveItemUpInPresorted();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnDown = new Button(sorterListCompButtons, 0);
        this.btnDown.setToolTipText(Messages.UserCasePreferences_MoveItemDownInList);
        this.btnDown.setImage(Images.IMG_ARROWDOWN.getImage());
        this.btnDown.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UserCasePreferences.this.moveItemDownInPresorted();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnToManual = new Button(sorterListCompButtons, 0);
        this.btnToManual.setToolTipText(Messages.UserCasePreferences_MoveItemToManualSortedList);
        this.btnToManual.setImage(Images.IMG_MOVETOLOWERLIST.getImage());
        this.btnToManual.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UserCasePreferences.this.moveItemToPresorted();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnToNotPresorted = new Button(sorterListCompButtons, 0);
        this.btnToNotPresorted.setToolTipText(Messages.UserCasePreferences_MoveItemToAlphabeticallySortedList);
        this.btnToNotPresorted.setImage(Images.IMG_ARROWDOWNTORECT.getImage());
        this.btnToNotPresorted.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UserCasePreferences.this.moveItemToNotPresorted();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setButtonEnabling();
        return suParent;
    }

    void moveItemToPresorted() {
        String[] selStr = this.sorterList2.getSelection();
        this.topItemsLinkedList.add(selStr[0]);
        this.topItemsLinkedList.remove("");
        this.sorterList2.setItems(UserCasePreferences.sortBillingSystems(BillingSystem.getAbrechnungsSysteme(), this.topItemsLinkedList, true));
        this.sorterList2.select(this.topItemsLinkedList.size() - 1);
        this.setButtonEnabling();
    }

    void moveItemToNotPresorted() {
        String[] selStr = this.sorterList2.getSelection();
        this.topItemsLinkedList.remove(selStr[0]);
        this.topItemsLinkedList.remove("");
        this.sorterList2.setItems(UserCasePreferences.sortBillingSystems(BillingSystem.getAbrechnungsSysteme(), this.topItemsLinkedList, true));
        int newSel = this.sorterList2.indexOf(selStr[0]);
        this.sorterList2.select(newSel);
        this.setButtonEnabling();
    }

    void moveItemUpInPresorted() {
        this.moveItemInPresorted(-1);
    }

    void moveItemDownInPresorted() {
        this.moveItemInPresorted(1);
    }

    void moveItemInPresorted(int step) {
        int selIx = this.sorterList2.getSelectionIndex();
        if (selIx < 0) {
            return;
        }
        String[] selStr = this.sorterList2.getSelection();
        int newIx = selIx + step;
        this.topItemsLinkedList.remove(selIx);
        this.topItemsLinkedList.add(newIx, selStr[0]);
        this.topItemsLinkedList.remove("");
        this.sorterList2.setItems(UserCasePreferences.sortBillingSystems(BillingSystem.getAbrechnungsSysteme(), this.topItemsLinkedList, true));
        this.sorterList2.select(newIx);
        this.setButtonEnabling();
    }

    void setButtonEnabling() {
        int separatorPos = this.topItemsLinkedList.size() > 0 && !this.topItemsLinkedList.get(0).equalsIgnoreCase("") ? this.topItemsLinkedList.size() : -1;
        int selIx = this.sorterList2.getSelectionIndex();
        if (selIx < 0) {
            this.btnToManual.setEnabled(false);
            this.btnToNotPresorted.setEnabled(false);
        } else if (selIx < separatorPos) {
            this.btnToManual.setEnabled(false);
            this.btnToNotPresorted.setEnabled(true);
        } else if (selIx > separatorPos) {
            this.btnToManual.setEnabled(true);
            this.btnToNotPresorted.setEnabled(false);
        } else {
            this.btnToManual.setEnabled(false);
            this.btnToNotPresorted.setEnabled(false);
        }
        this.btnUp.setEnabled(selIx > 0 && selIx < this.topItemsLinkedList.size());
        this.btnDown.setEnabled(selIx >= this.topItemsLinkedList.size() - 1 ? false : selIx >= 0);
    }

    public static int getBillingSystemsMenuSeparatorPos(String[] input) {
        String topItemsSortingStr = ConfigServiceHolder.getUser((String)"fall/topitemssorting", (String)"");
        String[] topItemsSorting = topItemsSortingStr.split(PREFSDELIMITER_REGEX);
        LinkedList<String> lTopItemsLinkedList = new LinkedList<String>(Arrays.asList(topItemsSorting));
        if (lTopItemsLinkedList.size() > 0 && !lTopItemsLinkedList.get(0).equalsIgnoreCase("")) {
            return lTopItemsLinkedList.size();
        }
        return -1;
    }

    public static String[] sortBillingSystems(String[] input) {
        String topItemsSortingStr = ConfigServiceHolder.getUser((String)"fall/topitemssorting", (String)"");
        String[] topItemsSorting = topItemsSortingStr.split(PREFSDELIMITER_REGEX);
        LinkedList<String> lTopItemsLinkedList = new LinkedList<String>(Arrays.asList(topItemsSorting));
        return UserCasePreferences.sortBillingSystems(input, lTopItemsLinkedList);
    }

    public static String[] sortBillingSystems(String[] input, LinkedList<String> topItemsSorting) {
        return UserCasePreferences.sortBillingSystems(input, topItemsSorting, false);
    }

    public static String[] sortBillingSystems(String[] input, LinkedList<String> topItemsSorting, boolean alwaysShowSeparator) {
        LinkedList lTopItemsSorting = (LinkedList)topItemsSorting.clone();
        SortedList sortedList = new SortedList((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        int i = 0;
        while (i < input.length) {
            String item = input[i];
            if (!lTopItemsSorting.contains(item)) {
                sortedList.add((Object)item);
            }
            ++i;
        }
        if (alwaysShowSeparator || topItemsSorting.size() > 0 && !topItemsSorting.get(0).equalsIgnoreCase("")) {
            lTopItemsSorting.add(MENUSEPARATOR);
        }
        lTopItemsSorting.addAll(sortedList);
        lTopItemsSorting.remove("");
        String[] output = new String[lTopItemsSorting.size()];
        lTopItemsSorting.toArray(output);
        return output;
    }

    protected void performDefaults() {
        this.initialize();
    }
}

