/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.TextTemplateImportConflictDialog;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.MimeTypeUtil;
import ch.elexis.core.ui.views.textsystem.TextTemplateView;
import ch.elexis.core.ui.views.textsystem.model.TextTemplate;
import ch.elexis.data.Brief;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.rgw.tools.ExHandler;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportTemplatesCommand
extends AbstractHandler {
    private static Logger logger = LoggerFactory.getLogger(ImportTemplatesCommand.class);
    private String mandantId = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block16: {
            Mandant mandant = ElexisEventDispatcher.getSelectedMandator();
            if (mandant == null) {
                return null;
            }
            this.mandantId = mandant.getId();
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            TextTemplateView ttView = (TextTemplateView)activePage.findView("ch.elexis.views.textsystem.TextTemplateView");
            ITextPlugin plugin = ttView.getActiveTextPlugin();
            if (plugin == null) {
                logger.warn("No TextPlugin found - skipping text template import");
                return null;
            }
            try {
                String mimeType = plugin.getMimeType();
                FileDialog fdl = new FileDialog(UiDesk.getTopShell(), 2);
                fdl.setFilterExtensions(new String[]{MimeTypeUtil.getExtensions(mimeType)});
                fdl.setFilterNames(new String[]{MimeTypeUtil.getPrettyPrintName(mimeType)});
                fdl.open();
                String[] fileNames = fdl.getFileNames();
                String filterPath = String.valueOf(fdl.getFilterPath()) + File.separator;
                if (fileNames.length <= 0) break block16;
                String[] stringArray = fileNames;
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    block17: {
                        boolean replaceExisting;
                        List<Brief> equivalentTemplates;
                        TextTemplate sysTemplate;
                        String name;
                        File file;
                        block18: {
                            String filename = stringArray[n2];
                            file = new File(String.valueOf(filterPath) + filename);
                            if (!file.exists()) break block17;
                            name = filename.substring(0, filename.lastIndexOf(46));
                            sysTemplate = this.matchesRequiredSystemTemplate(ttView.getRequiredTextTemplates(), name, mimeType);
                            equivalentTemplates = TextTemplate.findExistingTemplates(sysTemplate != null, name, mimeType, this.mandantId);
                            replaceExisting = false;
                            if (equivalentTemplates == null || equivalentTemplates.isEmpty()) break block18;
                            TextTemplateImportConflictDialog ttiConflictDialog = new TextTemplateImportConflictDialog(UiDesk.getTopShell(), name);
                            ttiConflictDialog.open();
                            if (ttiConflictDialog.doSkipTemplate()) break block17;
                            if (ttiConflictDialog.doChangeTemplateName()) {
                                name = ttiConflictDialog.getNewName();
                            } else {
                                replaceExisting = true;
                            }
                        }
                        FileInputStream fis = new FileInputStream(file);
                        byte[] contentToStore = new byte[(int)file.length()];
                        fis.read(contentToStore);
                        fis.close();
                        if (replaceExisting) {
                            if (equivalentTemplates instanceof List) {
                                equivalentTemplates.get(0).save(contentToStore, mimeType);
                            } else {
                                logger.error("Invalid state: equivalentTemplates is " + equivalentTemplates);
                            }
                        } else {
                            Brief template = new Brief(name, null, (Kontakt)CoreHub.getLoggedInContact(), null, null, "Vorlagen");
                            template.save(contentToStore, mimeType);
                            if (sysTemplate == null) {
                                template.setAdressat(mandant.getId());
                                TextTemplate tt = new TextTemplate(name, "", mimeType);
                                tt.addFormTemplateReference(template);
                                ttView.update(tt);
                            } else {
                                sysTemplate.addSystemTemplateReference(template);
                                ttView.update(sysTemplate);
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (Throwable ex) {
                ExHandler.handle((Throwable)ex);
                logger.error("Error during import of text templates", ex);
            }
        }
        ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent(Brief.class, null, 8, 10000)});
        return null;
    }

    private TextTemplate matchesRequiredSystemTemplate(List<TextTemplate> reqTextTemplates, String name, String mimeType) {
        for (TextTemplate sysTemplate : reqTextTemplates) {
            if (!sysTemplate.getName().equals(name) || !sysTemplate.getMimeType().equals(mimeType)) continue;
            if (MessageDialog.openQuestion((Shell)UiDesk.getTopShell(), (String)"Systemvorlage", (String)("Soll " + name + " als Systemvorlage importiert werden?"))) {
                return sysTemplate;
            }
            return null;
        }
        return null;
    }
}

