/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.DocumentSelectDialog;
import ch.elexis.core.ui.dialogs.SelectFallDialog;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.views.BriefAuswahl;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.TextView;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.rgw.tools.ExHandler;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class BriefNewHandler
extends AbstractHandler
implements IHandler {
    public static final String CMD_ID = "ch.elexis.core.ui.commands.BriefNew";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Konsultation selectedKonsultation;
        Patient pat = ElexisEventDispatcher.getSelectedPatient();
        if (pat == null) {
            MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)Messages.BriefAuswahlNoPatientSelected, (String)Messages.BriefAuswahlNoPatientSelected);
            return null;
        }
        Fall selectedFall = (Fall)ElexisEventDispatcher.getSelected(Fall.class);
        if (selectedFall == null) {
            SelectFallDialog sfd = new SelectFallDialog(UiDesk.getTopShell());
            sfd.open();
            if (sfd.result != null) {
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)sfd.result);
            } else {
                MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)Messages.TextView_NoCaseSelected, (String)Messages.TextView_SaveNotPossibleNoCaseAndKonsSelected);
                return null;
            }
        }
        if ((selectedKonsultation = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class)) == null) {
            Konsultation k = pat.getLetzteKons(false);
            if (k == null) {
                k = ((Fall)ElexisEventDispatcher.getSelected(Fall.class)).neueKonsultation();
                k.setMandant(CoreHub.actMandant);
            }
            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)k);
        }
        TextView tv = null;
        try {
            DocumentSelectDialog bs = new DocumentSelectDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Person)CoreHub.actMandant, 1);
            if (bs.open() == 0) {
                tv = (TextView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.TextView");
                Kontakt address = null;
                if (DocumentSelectDialog.getDontAskForAddresseeForThisTemplate(bs.getSelectedDocument())) {
                    address = Kontakt.load((String)"-1");
                }
                tv.createDocument(bs.getSelectedDocument(), bs.getBetreff(), address);
                tv.setName();
                IViewPart viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("ch.elexis.BriefAuswahlView");
                if (viewPart instanceof BriefAuswahl) {
                    ((BriefAuswahl)viewPart).refreshCV(CommonViewer.Message.update_keeplabels);
                }
            }
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
        }
        return null;
    }
}

