/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.actions;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.Messages;
import ch.elexis.core.ui.actions.PersistentObjectLoader;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.LazyTree;
import ch.rgw.tools.Tree;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;

public class TreeDataLoader
extends PersistentObjectLoader
implements ILazyTreeContentProvider {
    protected String parentColumn;
    protected String orderBy;
    protected LazyTree<PersistentObject> root;

    public TreeDataLoader(CommonViewer cv, Query<? extends PersistentObject> query, String parentField, String orderBy) {
        super(cv, query);
        this.parentColumn = parentField;
        this.orderBy = orderBy;
        this.root = new LazyTree(null, null, new LazyTree.LazyTreeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean fetchChildren(LazyTree<?> l) {
                List children = null;
                Query query = TreeDataLoader.this.qbe;
                synchronized (query) {
                    PersistentObject p = (PersistentObject)l.contents;
                    if (l.getParent() == null) {
                        TreeDataLoader.this.setQuery("NIL");
                    } else {
                        if (p == null) {
                            return false;
                        }
                        TreeDataLoader.this.setQuery(p.getId());
                    }
                    children = TreeDataLoader.this.qbe.execute();
                    Iterator iterator = children.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return children.size() > 0;
                        }
                        PersistentObject po = (PersistentObject)iterator.next();
                        new LazyTree(l, (Object)po, (LazyTree.LazyTreeListener)this);
                    }
                }
            }

            public boolean hasChildren(LazyTree<?> l) {
                return this.fetchChildren(l);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStatus work(IProgressMonitor monitor, HashMap<String, Object> params) {
        monitor.beginTask(Messages.PersistentObjectLoader_LoadingData, -1);
        Query query = this.qbe;
        synchronized (query) {
            this.root.clear();
            this.setQuery("NIL");
            for (PersistentObject po : this.qbe.execute()) {
                new Tree(this.root, (Object)po);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(1);
            }
            monitor.done();
            UiDesk.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ((TreeViewer)TreeDataLoader.this.cv.getViewerWidget()).setChildCount(TreeDataLoader.this.cv.getViewerWidget().getInput(), TreeDataLoader.this.root.getChildren().size());
                }
            });
        }
        return Status.OK_STATUS;
    }

    public Object getParent(Object element) {
        if (element instanceof Tree) {
            return ((Tree)element).getParent();
        }
        return null;
    }

    public void updateChildCount(Object element, int currentChildCount) {
        int num = 0;
        if (element instanceof Tree) {
            Tree t = (Tree)element;
            if (!t.hasChildren()) {
                this.setQuery(((PersistentObject)t.contents).getId());
                for (PersistentObject po : this.qbe.execute()) {
                    new Tree(t, (Object)po);
                }
            }
            num = t.getChildren().size();
        } else {
            num = this.root.getChildren().size();
        }
        ((TreeViewer)this.cv.getViewerWidget()).setChildCount(element, num);
    }

    public void updateElement(Object parent, int index) {
        LazyTree<PersistentObject> t = parent instanceof Tree ? (LazyTree<PersistentObject>)parent : this.root;
        Tree elem = t.getChildren().toArray(new Tree[0])[index];
        ((TreeViewer)this.cv.getViewerWidget()).replace(parent, index, (Object)elem);
        this.updateChildCount(elem, 0);
    }

    protected void setQuery(String parent) {
        this.qbe.clear();
        ViewerConfigurer.ControlFieldProvider cfp = this.cv.getConfigurer().getControlFieldProvider();
        if (cfp != null) {
            if (cfp.isEmpty()) {
                this.qbe.add(this.parentColumn, "=", parent);
            } else {
                cfp.setQuery((Query<? extends PersistentObject>)this.qbe);
            }
        }
        this.applyQueryFilters();
        if (this.orderBy != null) {
            this.qbe.orderBy(true, new String[]{this.orderBy});
        }
    }
}

