/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui;

import ch.elexis.core.constants.Elexis;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.interfaces.ShutdownJob;
import ch.elexis.core.data.interfaces.scripting.Interpreter;
import ch.elexis.core.ui.ElexisConfigurationConstants;
import ch.elexis.core.ui.Messages;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.events.UiPatientEventListener;
import ch.elexis.core.ui.events.UiUserEventListener;
import ch.elexis.core.ui.preferences.PreferenceInitializer;
import ch.elexis.data.Anwender;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Reminder;
import ch.rgw.tools.TimeTool;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hub
extends AbstractUIPlugin {
    public static final String APPLICATION_NAME = "Elexis";
    public static final String PLUGIN_ID = "ch.elexis.core.ui";
    public static final String COMMAND_PREFIX = "ch.elexis.core.ui.commands.";
    public static final String SWTBOTTEST_KEY = "ch.elexis.swtbottest.key";
    static final String[] mine = new String[]{"ch.elexis", "ch.rgw"};
    private static Logger log = LoggerFactory.getLogger((String)Hub.class.getName());
    private static List<ShutdownJob> shutdownJobs = new LinkedList<ShutdownJob>();
    public static final PreferenceInitializer pin = new PreferenceInitializer();
    private final UiPatientEventListener eeli_pat = new UiPatientEventListener();
    private final UiUserEventListener eeli_user = new UiUserEventListener();
    public static boolean ecc = ElexisConfigurationConstants.init();
    public static Hub plugin;
    public static GlobalActions mainActions;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        log.debug("Starting " + ((Object)((Object)this)).getClass().getName());
        plugin = this;
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_user});
        Interpreter.classLoaders.add(Hub.class.getClassLoader());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        log.debug("Stopping " + ((Object)((Object)this)).getClass().getName());
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_user});
        super.stop(context);
    }

    public static void postShutdown() {
        if (shutdownJobs != null && shutdownJobs.size() > 0) {
            Shell shell = new Shell(Display.getDefault());
            MessageDialog dlg = new MessageDialog(shell, Messages.Hub_title_configuration, Dialog.getDefaultImage(), Messages.Hub_message_configuration, 2, new String[0], 0);
            dlg.setBlockOnOpen(false);
            dlg.open();
            for (ShutdownJob job : shutdownJobs) {
                try {
                    job.doit();
                }
                catch (Exception e) {
                    log.error("Error starting job: " + e.getMessage());
                }
            }
            dlg.close();
        }
    }

    public static void setMandant(Mandant m) {
        CoreHub.setMandant((Mandant)m);
        Hub.setWindowText(null);
    }

    public static void setWindowText(Patient pat) {
        Shell shell;
        StringBuilder sb = new StringBuilder();
        sb.append("Elexis ").append(Elexis.VERSION).append(" - ");
        if (CoreHub.getLoggedInContact() == null) {
            sb.append(Messages.Hub_nouserloggedin);
        } else {
            sb.append(" ").append(CoreHub.getLoggedInContact().getLabel());
        }
        if (CoreHub.actMandant == null) {
            sb.append(Messages.Hub_nomandantor);
        } else {
            sb.append(" / ").append(CoreHub.actMandant.getLabel());
        }
        if (pat == null) {
            pat = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
        }
        if (pat == null) {
            sb.append(Messages.Hub_nopatientselected);
        } else {
            String nr = pat.getPatCode();
            String alter = pat.getAlter();
            sb.append("  / ").append(pat.getLabel()).append(" (").append(alter).append(") - ").append("[").append(nr).append("]");
            if (Reminder.findForPatient((Patient)pat, (Kontakt)CoreHub.getLoggedInContact()).size() != 0) {
                sb.append(Messages.Hub_message_reminders);
            }
            String act = new TimeTool().toString(9);
            TimeTool ttPatg = new TimeTool();
            if (ttPatg.set(pat.getGeburtsdatum())) {
                String patg = ttPatg.toString(9);
                if (act.substring(4).equals(patg.substring(4))) {
                    sb.append(Messages.Hub_message_birthday);
                }
            }
        }
        if (Hub.mainActions.mainWindow != null && (shell = Hub.mainActions.mainWindow.getShell()) != null && !shell.isDisposed()) {
            Hub.mainActions.mainWindow.getShell().setText(sb.toString());
        }
    }

    public static Shell getActiveShell() {
        IWorkbenchWindow win;
        IWorkbench wb;
        if (plugin != null && (wb = plugin.getWorkbench()) != null && (win = wb.getActiveWorkbenchWindow()) != null) {
            return win.getShell();
        }
        Display dis = UiDesk.getDisplay();
        if (dis == null) {
            dis = PlatformUI.createDisplay();
        }
        return new Shell(dis);
    }

    public static List<Mandant> getMandantenList() {
        return CoreHub.getMandantenList();
    }

    public static List<Anwender> getUserList() {
        return CoreHub.getUserList();
    }

    public static void addShutdownJob(ShutdownJob job) {
        if (!shutdownJobs.contains(job)) {
            shutdownJobs.add(job);
        }
    }
}

