/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.compress;

import ch.rgw.compress.HuffmanTree;
import ch.rgw.tools.IntTool;
import java.io.ByteArrayOutputStream;

public class RLL {
    public static String Version() {
        return "0.2.1";
    }

    public static byte[] compress(byte rllchar, byte[] source) {
        if (rllchar == 0) {
            int[] freq = HuffmanTree.constructTable(source);
            int min = 100000;
            int i = 0;
            while (i < freq.length) {
                if (freq[i] == 0) {
                    rllchar = (byte)i;
                    break;
                }
                if (freq[i] < min) {
                    min = freq[i];
                    rllchar = (byte)i;
                }
                ++i;
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(source.length);
        baos.write(rllchar);
        int i = 0;
        while (i < source.length - 3) {
            if (source[i] == source[i + 1] && source[i + 1] == source[i + 2]) {
                int rep = 3;
                while (i + rep < source.length && source[i + rep] == source[i]) {
                    if (rep == 254) break;
                    ++rep;
                }
                baos.write(rllchar);
                baos.write(rep);
                baos.write(source[i]);
                i += rep - 1;
            } else if (source[i] == rllchar) {
                baos.write(rllchar);
                baos.write(1);
            } else {
                baos.write(source[i]);
            }
            ++i;
        }
        while (i < source.length) {
            baos.write(source[i++]);
        }
        return baos.toByteArray();
    }

    public static byte[] expand(byte[] source) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(source.length);
        byte rllchar = source[0];
        int i = 1;
        while (i < source.length - 2) {
            if (source[i] == rllchar) {
                if (source[i + 1] == 1) {
                    baos.write(rllchar);
                    ++i;
                } else {
                    int k = IntTool.ByteToInt(source[i + 1]);
                    while (k-- > 0) {
                        baos.write(source[i + 2]);
                    }
                    i += 2;
                }
            } else {
                baos.write(source[i]);
            }
            ++i;
        }
        while (i < source.length) {
            baos.write(source[i++]);
        }
        return baos.toByteArray();
    }
}

