/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.model;

import com.phloc.commons.log.InMemoryLogger;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.impl.MicroElement;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.pure.model.IPSElement;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSParam
implements IPSElement {
    private String m_sName;
    private String m_sValue;

    @Override
    public boolean isValid(@Nonnull InMemoryLogger inMemoryLogger) {
        if (StringHelper.hasNoText((String)this.m_sName)) {
            inMemoryLogger.error((Serializable)((Object)"<param> has no 'name'"));
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sValue)) {
            inMemoryLogger.error((Serializable)((Object)"<param> has no 'value'"));
            return false;
        }
        return true;
    }

    @Override
    public boolean isMinimal() {
        return false;
    }

    public void setName(@Nullable String string) {
        this.m_sName = string;
    }

    @Nullable
    public String getName() {
        return this.m_sName;
    }

    public void setValue(@Nullable String string) {
        if (string != null && string.length() == 0) {
            throw new IllegalArgumentException("value may not be empty!");
        }
        this.m_sValue = string;
    }

    @Nullable
    public String getValue() {
        return this.m_sValue;
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "param");
        microElement.setAttribute("name", this.m_sName);
        microElement.setAttribute("value", this.m_sValue);
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("name", (Object)this.m_sName).append("value", (Object)this.m_sValue).toString();
    }
}

