/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.model;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.log.InMemoryLogger;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.impl.MicroElement;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.pure.model.IPSClonableElement;
import com.phloc.schematron.pure.model.IPSHasForeignAttributes;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSName
implements IPSClonableElement<PSName>,
IPSHasForeignAttributes {
    private String m_sPath;
    private Map<String, String> m_aForeignAttrs;

    @Override
    public boolean isValid(@Nonnull InMemoryLogger inMemoryLogger) {
        return true;
    }

    @Override
    public boolean isMinimal() {
        return true;
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new LinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public void addForeignAttributes(@Nonnull Map<String, String> map) {
        ValueEnforcer.notNull(map, (String)"ForeignAttrs");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addForeignAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && !this.m_aForeignAttrs.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllForeignAttributes() {
        return ContainerHelper.newOrderedMap(this.m_aForeignAttrs);
    }

    public void setPath(@Nullable String string) {
        this.m_sPath = string;
    }

    public boolean hasPath() {
        return this.m_sPath != null;
    }

    @Nullable
    public String getPath() {
        return this.m_sPath;
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "name");
        microElement.setAttribute("path", this.m_sPath);
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry<String, String> entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return microElement;
    }

    @Nonnull
    public PSName getClone() {
        PSName pSName = new PSName();
        pSName.setPath(this.m_sPath);
        if (this.hasForeignAttributes()) {
            pSName.addForeignAttributes(this.m_aForeignAttrs);
        }
        return pSName;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("path", (Object)this.m_sPath).appendIfNotNull("foreignAttrs", this.m_aForeignAttrs).toString();
    }
}

