/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.model;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.log.InMemoryLogger;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.impl.MicroElement;
import com.phloc.commons.regex.RegExHelper;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.pure.model.IPSElement;
import com.phloc.schematron.pure.model.IPSHasFlag;
import com.phloc.schematron.pure.model.IPSHasForeignElements;
import com.phloc.schematron.pure.model.IPSHasID;
import com.phloc.schematron.pure.model.IPSHasLinkableGroup;
import com.phloc.schematron.pure.model.IPSHasMixedContent;
import com.phloc.schematron.pure.model.IPSHasRichGroup;
import com.phloc.schematron.pure.model.PSDir;
import com.phloc.schematron.pure.model.PSEmph;
import com.phloc.schematron.pure.model.PSLinkableGroup;
import com.phloc.schematron.pure.model.PSName;
import com.phloc.schematron.pure.model.PSRichGroup;
import com.phloc.schematron.pure.model.PSSpan;
import com.phloc.schematron.pure.model.PSValueOf;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSAssertReport
implements IPSElement,
IPSHasFlag,
IPSHasForeignElements,
IPSHasMixedContent,
IPSHasID,
IPSHasRichGroup,
IPSHasLinkableGroup {
    private final boolean m_bIsAssert;
    private String m_sTest;
    private String m_sFlag;
    private String m_sID;
    private List<String> m_aDiagnostics;
    private PSRichGroup m_aRich;
    private PSLinkableGroup m_aLinkable;
    private final List<Object> m_aContent = new ArrayList<Object>();
    private Map<String, String> m_aForeignAttrs;
    private List<IMicroElement> m_aForeignElements;

    public PSAssertReport(boolean bl) {
        this.m_bIsAssert = bl;
    }

    @Override
    public boolean isValid(@Nonnull InMemoryLogger inMemoryLogger) {
        for (Object object : this.m_aContent) {
            if (!(object instanceof IPSElement) || ((IPSElement)object).isValid(inMemoryLogger)) continue;
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sTest)) {
            inMemoryLogger.error((Serializable)((Object)((this.m_bIsAssert ? "<assert>" : "<report>") + " has no 'test'")));
            return false;
        }
        return true;
    }

    @Override
    public boolean isMinimal() {
        if (!this.m_bIsAssert) {
            return false;
        }
        for (Object object : this.m_aContent) {
            if (!(object instanceof IPSElement) || ((IPSElement)object).isMinimal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"ForeignElement");
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        if (this.m_aForeignElements == null) {
            this.m_aForeignElements = new ArrayList<IMicroElement>();
        }
        this.m_aForeignElements.add(iMicroElement);
    }

    @Override
    public void addForeignElements(@Nonnull List<IMicroElement> list) {
        ValueEnforcer.notNull(list, (String)"ForeignElements");
        for (IMicroElement iMicroElement : list) {
            this.addForeignElement(iMicroElement);
        }
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aForeignElements != null && !this.m_aForeignElements.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getAllForeignElements() {
        return ContainerHelper.newList(this.m_aForeignElements);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new LinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public void addForeignAttributes(@Nonnull Map<String, String> map) {
        ValueEnforcer.notNull(map, (String)"ForeignAttrs");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addForeignAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && !this.m_aForeignAttrs.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllForeignAttributes() {
        return ContainerHelper.newOrderedMap(this.m_aForeignAttrs);
    }

    public boolean isAssert() {
        return this.m_bIsAssert;
    }

    public boolean isReport() {
        return !this.m_bIsAssert;
    }

    public void setTest(@Nullable String string) {
        this.m_sTest = string;
    }

    @Nullable
    public String getTest() {
        return this.m_sTest;
    }

    public void setFlag(@Nullable String string) {
        this.m_sFlag = string;
    }

    @Override
    @Nullable
    public String getFlag() {
        return this.m_sFlag;
    }

    @Override
    public void setID(@Nullable String string) {
        this.m_sID = string;
    }

    @Override
    public boolean hasID() {
        return this.m_sID != null;
    }

    @Override
    @Nullable
    public String getID() {
        return this.m_sID;
    }

    public void setDiagnostics(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            this.setDiagnostics(RegExHelper.getSplitToList((CharSequence)string.trim(), (String)"\\s+"));
        } else {
            this.m_aDiagnostics = null;
        }
    }

    public void setDiagnostics(@Nullable List<String> list) {
        this.m_aDiagnostics = list;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<String> getAllDiagnostics() {
        return ContainerHelper.newList(this.m_aDiagnostics);
    }

    @Override
    public void setRich(@Nullable PSRichGroup pSRichGroup) {
        this.m_aRich = pSRichGroup;
    }

    @Override
    public boolean hasRich() {
        return this.m_aRich != null;
    }

    @Override
    @Nullable
    public PSRichGroup getRich() {
        return this.m_aRich;
    }

    @Override
    @Nullable
    public PSRichGroup getRichClone() {
        return this.m_aRich == null ? null : this.m_aRich.getClone();
    }

    @Override
    public void setLinkable(@Nullable PSLinkableGroup pSLinkableGroup) {
        this.m_aLinkable = pSLinkableGroup;
    }

    @Override
    public boolean hasLinkable() {
        return this.m_aLinkable != null;
    }

    @Override
    @Nullable
    public PSLinkableGroup getLinkable() {
        return this.m_aLinkable;
    }

    @Override
    @Nullable
    public PSLinkableGroup getLinkableClone() {
        return this.m_aLinkable == null ? null : this.m_aLinkable.getClone();
    }

    @Override
    public void addText(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Text");
        this.m_aContent.add(string);
    }

    @Override
    public boolean hasAnyText() {
        for (Object object : this.m_aContent) {
            if (!(object instanceof String)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<String> getAllTexts() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : this.m_aContent) {
            if (!(object instanceof String)) continue;
            arrayList.add((String)object);
        }
        return arrayList;
    }

    public void addName(@Nonnull PSName pSName) {
        ValueEnforcer.notNull((Object)pSName, (String)"Name");
        this.m_aContent.add(pSName);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSName> getAllNames() {
        ArrayList<PSName> arrayList = new ArrayList<PSName>();
        for (Object object : this.m_aContent) {
            if (!(object instanceof PSName)) continue;
            arrayList.add((PSName)object);
        }
        return arrayList;
    }

    public void addValueOf(@Nonnull PSValueOf pSValueOf) {
        ValueEnforcer.notNull((Object)pSValueOf, (String)"ValueOf");
        this.m_aContent.add(pSValueOf);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSValueOf> getAllValueOfs() {
        ArrayList<PSValueOf> arrayList = new ArrayList<PSValueOf>();
        for (Object object : this.m_aContent) {
            if (!(object instanceof PSValueOf)) continue;
            arrayList.add((PSValueOf)object);
        }
        return arrayList;
    }

    public void addEmph(@Nonnull PSEmph pSEmph) {
        ValueEnforcer.notNull((Object)pSEmph, (String)"Emph");
        this.m_aContent.add(pSEmph);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSEmph> getAllEmphs() {
        ArrayList<PSEmph> arrayList = new ArrayList<PSEmph>();
        for (Object object : this.m_aContent) {
            if (!(object instanceof PSEmph)) continue;
            arrayList.add((PSEmph)object);
        }
        return arrayList;
    }

    public void addDir(@Nonnull PSDir pSDir) {
        ValueEnforcer.notNull((Object)pSDir, (String)"Dir");
        this.m_aContent.add(pSDir);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSDir> getAllDirs() {
        ArrayList<PSDir> arrayList = new ArrayList<PSDir>();
        for (Object object : this.m_aContent) {
            if (!(object instanceof PSDir)) continue;
            arrayList.add((PSDir)object);
        }
        return arrayList;
    }

    public void addSpan(@Nonnull PSSpan pSSpan) {
        ValueEnforcer.notNull((Object)pSSpan, (String)"Span");
        this.m_aContent.add(pSSpan);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<PSSpan> getAllSpans() {
        ArrayList<PSSpan> arrayList = new ArrayList<PSSpan>();
        for (Object object : this.m_aContent) {
            if (!(object instanceof PSSpan)) continue;
            arrayList.add((PSSpan)object);
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<Object> getAllContentElements() {
        return ContainerHelper.newList(this.m_aContent);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", this.m_bIsAssert ? "assert" : "report");
        microElement.setAttribute("id", this.m_sID);
        microElement.setAttribute("flag", this.m_sFlag);
        microElement.setAttribute("test", this.m_sTest);
        if (ContainerHelper.isNotEmpty(this.m_aDiagnostics)) {
            microElement.setAttribute("diagnostics", StringHelper.getImploded((char)' ', this.m_aDiagnostics));
        }
        if (this.m_aRich != null) {
            this.m_aRich.fillMicroElement((IMicroElement)microElement);
        }
        if (this.m_aLinkable != null) {
            this.m_aLinkable.fillMicroElement((IMicroElement)microElement);
        }
        if (this.m_aForeignElements != null) {
            for (IMicroElement object : this.m_aForeignElements) {
                microElement.appendChild((IMicroNode)object.getClone());
            }
        }
        for (Object object : this.m_aContent) {
            if (object instanceof String) {
                microElement.appendText((CharSequence)((String)object));
                continue;
            }
            microElement.appendChild((IMicroNode)((IPSElement)object).getAsMicroElement());
        }
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return microElement;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("isAssert", this.m_bIsAssert).appendIfNotNull("test", (Object)this.m_sTest).appendIfNotNull("flag", (Object)this.m_sFlag).appendIfNotNull("id", (Object)this.m_sID).appendIfNotNull("diagnostics", this.m_aDiagnostics).appendIfNotNull("rich", (Object)this.m_aRich).appendIfNotNull("linkable", (Object)this.m_aLinkable).append("content", this.m_aContent).appendIfNotNull("foreignAttrs", this.m_aForeignAttrs).appendIfNotNull("foreignElements", this.m_aForeignElements).toString();
    }
}

