/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.exchange;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.microdom.IMicroDocument;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.IMicroText;
import com.phloc.commons.string.StringParser;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.SchematronHelper;
import com.phloc.schematron.pure.errorhandler.IPSErrorHandler;
import com.phloc.schematron.pure.errorhandler.LoggingPSErrorHandler;
import com.phloc.schematron.pure.exchange.SchematronReadException;
import com.phloc.schematron.pure.model.IPSElement;
import com.phloc.schematron.pure.model.PSActive;
import com.phloc.schematron.pure.model.PSAssertReport;
import com.phloc.schematron.pure.model.PSDiagnostic;
import com.phloc.schematron.pure.model.PSDiagnostics;
import com.phloc.schematron.pure.model.PSDir;
import com.phloc.schematron.pure.model.PSEmph;
import com.phloc.schematron.pure.model.PSExtends;
import com.phloc.schematron.pure.model.PSInclude;
import com.phloc.schematron.pure.model.PSLet;
import com.phloc.schematron.pure.model.PSLinkableGroup;
import com.phloc.schematron.pure.model.PSNS;
import com.phloc.schematron.pure.model.PSName;
import com.phloc.schematron.pure.model.PSP;
import com.phloc.schematron.pure.model.PSParam;
import com.phloc.schematron.pure.model.PSPattern;
import com.phloc.schematron.pure.model.PSPhase;
import com.phloc.schematron.pure.model.PSRichGroup;
import com.phloc.schematron.pure.model.PSRule;
import com.phloc.schematron.pure.model.PSSchema;
import com.phloc.schematron.pure.model.PSSpan;
import com.phloc.schematron.pure.model.PSTitle;
import com.phloc.schematron.pure.model.PSValueOf;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PSReader {
    private final IReadableResource m_aResource;
    private final IPSErrorHandler m_aErrorHandler;

    public PSReader(@Nonnull IReadableResource iReadableResource) {
        this(iReadableResource, null);
    }

    public PSReader(@Nonnull IReadableResource iReadableResource, @Nullable IPSErrorHandler iPSErrorHandler) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        this.m_aResource = iReadableResource;
        this.m_aErrorHandler = iPSErrorHandler != null ? iPSErrorHandler : new LoggingPSErrorHandler();
    }

    @Nonnull
    public IReadableResource getResource() {
        return this.m_aResource;
    }

    @Nonnull
    public IPSErrorHandler getErrorHandler() {
        return this.m_aErrorHandler;
    }

    @Nullable
    private static String _getAttributeValue(@Nullable String string) {
        return string == null ? null : string.trim();
    }

    private void _warn(@Nonnull IPSElement iPSElement, @Nonnull String string) {
        ValueEnforcer.notNull((Object)iPSElement, (String)"SourceElement");
        ValueEnforcer.notNull((Object)string, (String)"Message");
        this.m_aErrorHandler.warn(this.m_aResource, iPSElement, string);
    }

    @Nonnull
    public PSActive readActiveFromXML(@Nonnull IMicroElement iMicroElement) {
        String string;
        String string2;
        PSActive pSActive = new PSActive();
        Map map = iMicroElement.getAllAttributes();
        if (map != null) {
            for (Map.Entry iMicroNode : map.entrySet()) {
                string2 = (String)iMicroNode.getKey();
                string = PSReader._getAttributeValue((String)iMicroNode.getValue());
                if (string2.equals("pattern")) {
                    pSActive.setPattern(string);
                    continue;
                }
                pSActive.addForeignAttribute(string2, string);
            }
        }
        if (iMicroElement.hasChildren()) {
            for (IMicroNode iMicroNode : iMicroElement.getChildren()) {
                switch (iMicroNode.getType()) {
                    case TEXT: {
                        pSActive.addText(((IMicroText)iMicroNode).getNodeValue());
                        break;
                    }
                    case ELEMENT: {
                        string2 = (IMicroElement)iMicroNode;
                        if ("http://purl.oclc.org/dsdl/schematron".equals(string2.getNamespaceURI())) {
                            string = string2.getLocalName();
                            if (string.equals("dir")) {
                                pSActive.addDir(this.readDirFromXML((IMicroElement)string2));
                                break;
                            }
                            if (string.equals("emph")) {
                                pSActive.addEmph(this.readEmphFromXML((IMicroElement)string2));
                                break;
                            }
                            if (string.equals("span")) {
                                pSActive.addSpan(this.readSpanFromXML((IMicroElement)string2));
                                break;
                            }
                            this._warn(pSActive, "Unsupported Schematron element '" + string + "'");
                            break;
                        }
                        pSActive.addForeignElement(string2.getClone());
                        break;
                    }
                    case COMMENT: {
                        break;
                    }
                    default: {
                        this._warn(pSActive, "Unsupported child node: " + iMicroNode);
                    }
                }
            }
        }
        return pSActive;
    }

    @Nonnull
    public PSAssertReport readAssertReportFromXML(@Nonnull IMicroElement iMicroElement) {
        String string;
        String string2;
        PSAssertReport pSAssertReport = new PSAssertReport(iMicroElement.getLocalName().equals("assert"));
        Map map = iMicroElement.getAllAttributes();
        if (map != null) {
            for (Map.Entry iMicroNode : map.entrySet()) {
                string2 = (String)iMicroNode.getKey();
                string = PSReader._getAttributeValue((String)iMicroNode.getValue());
                if (string2.equals("test")) {
                    pSAssertReport.setTest(string);
                    continue;
                }
                if (string2.equals("flag")) {
                    pSAssertReport.setFlag(string);
                    continue;
                }
                if (string2.equals("id")) {
                    pSAssertReport.setID(string);
                    continue;
                }
                if (string2.equals("diagnostics")) {
                    pSAssertReport.setDiagnostics(string);
                    continue;
                }
                if (PSRichGroup.isRichAttribute(string2) || PSLinkableGroup.isLinkableAttribute(string2)) continue;
                pSAssertReport.addForeignAttribute(string2, string);
            }
            pSAssertReport.setRich(this.readRichGroupFromXML(map));
            pSAssertReport.setLinkable(this.readLinkableGroupFromXML(map));
        }
        if (iMicroElement.hasChildren()) {
            for (IMicroNode iMicroNode : iMicroElement.getChildren()) {
                switch (iMicroNode.getType()) {
                    case TEXT: {
                        pSAssertReport.addText(((IMicroText)iMicroNode).getNodeValue());
                        break;
                    }
                    case ELEMENT: {
                        string2 = (IMicroElement)iMicroNode;
                        if ("http://purl.oclc.org/dsdl/schematron".equals(string2.getNamespaceURI())) {
                            string = string2.getLocalName();
                            if (string.equals("name")) {
                                pSAssertReport.addName(this.readNameFromXML((IMicroElement)string2));
                                break;
                            }
                            if (string.equals("value-of")) {
                                pSAssertReport.addValueOf(this.readValueOfFromXML((IMicroElement)string2));
                                break;
                            }
                            if (string.equals("emph")) {
                                pSAssertReport.addEmph(this.readEmphFromXML((IMicroElement)string2));
                                break;
                            }
                            if (string.equals("dir")) {
                                pSAssertReport.addDir(this.readDirFromXML((IMicroElement)string2));
                                break;
                            }
                            if (string.equals("span")) {
                                pSAssertReport.addSpan(this.readSpanFromXML((IMicroElement)string2));
                                break;
                            }
                            this._warn(pSAssertReport, "Unsupported Schematron element '" + string + "'");
                            break;
                        }
                        pSAssertReport.addForeignElement(string2.getClone());
                        break;
                    }
                    case COMMENT: {
                        break;
                    }
                    default: {
                        this._warn(pSAssertReport, "Unsupported child node: " + iMicroNode);
                    }
                }
            }
        }
        return pSAssertReport;
    }

    @Nonnull
    public PSDiagnostic readDiagnosticFromXML(@Nonnull IMicroElement iMicroElement) {
        String string;
        String string2;
        PSDiagnostic pSDiagnostic = new PSDiagnostic();
        Map map = iMicroElement.getAllAttributes();
        if (map != null) {
            for (Map.Entry iMicroNode : map.entrySet()) {
                string2 = (String)iMicroNode.getKey();
                string = PSReader._getAttributeValue((String)iMicroNode.getValue());
                if (string2.equals("id")) {
                    pSDiagnostic.setID(string);
                    continue;
                }
                if (PSRichGroup.isRichAttribute(string2)) continue;
                pSDiagnostic.addForeignAttribute(string2, string);
            }
            pSDiagnostic.setRich(this.readRichGroupFromXML(map));
        }
        if (iMicroElement.hasChildren()) {
            for (IMicroNode iMicroNode : iMicroElement.getChildren()) {
                switch (iMicroNode.getType()) {
                    case TEXT: {
                        pSDiagnostic.addText(((IMicroText)iMicroNode).getNodeValue());
                        break;
                    }
                    case ELEMENT: {
                        string2 = (IMicroElement)iMicroNode;
                        if ("http://purl.oclc.org/dsdl/schematron".equals(string2.getNamespaceURI())) {
                            string = string2.getLocalName();
                            if (string.equals("value-of")) {
                                pSDiagnostic.addValueOf(this.readValueOfFromXML((IMicroElement)string2));
                                break;
                            }
                            if (string.equals("emph")) {
                                pSDiagnostic.addEmph(this.readEmphFromXML((IMicroElement)string2));
                                break;
                            }
                            if (string.equals("dir")) {
                                pSDiagnostic.addDir(this.readDirFromXML((IMicroElement)string2));
                                break;
                            }
                            if (string.equals("span")) {
                                pSDiagnostic.addSpan(this.readSpanFromXML((IMicroElement)string2));
                                break;
                            }
                            this._warn(pSDiagnostic, "Unsupported Schematron element '" + string + "'");
                            break;
                        }
                        pSDiagnostic.addForeignElement(string2.getClone());
                        break;
                    }
                    case COMMENT: {
                        break;
                    }
                    default: {
                        this._warn(pSDiagnostic, "Unsupported child node: " + iMicroNode);
                    }
                }
            }
        }
        return pSDiagnostic;
    }

    @Nonnull
    public PSDiagnostics readDiagnosticsFromXML(@Nonnull IMicroElement iMicroElement) {
        PSDiagnostics pSDiagnostics = new PSDiagnostics();
        Map map = iMicroElement.getAllAttributes();
        if (map != null) {
            for (Map.Entry iMicroElement2 : map.entrySet()) {
                String string = (String)iMicroElement2.getKey();
                String string2 = PSReader._getAttributeValue((String)iMicroElement2.getValue());
                pSDiagnostics.addForeignAttribute(string, string2);
            }
        }
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements()) {
            if ("http://purl.oclc.org/dsdl/schematron".equals(iMicroElement2.getNamespaceURI())) {
                if (iMicroElement2.getLocalName().equals("include")) {
                    pSDiagnostics.addInclude(this.readIncludeFromXML(iMicroElement2));
                    continue;
                }
                if (iMicroElement2.getLocalName().equals("diagnostic")) {
                    pSDiagnostics.addDiagnostic(this.readDiagnosticFromXML(iMicroElement2));
                    continue;
                }
                this._warn(pSDiagnostics, "Unsupported Schematron element '" + iMicroElement2.getLocalName() + "'");
                continue;
            }
            pSDiagnostics.addForeignElement(iMicroElement2.getClone());
        }
        return pSDiagnostics;
    }

    @Nonnull
    public PSDir readDirFromXML(@Nonnull IMicroElement iMicroElement) {
        String string;
        PSDir pSDir = new PSDir();
        Map map = iMicroElement.getAllAttributes();
        if (map != null) {
            for (Map.Entry iMicroNode : map.entrySet()) {
                string = (String)iMicroNode.getKey();
                String string2 = PSReader._getAttributeValue((String)iMicroNode.getValue());
                if (string.equals("value")) {
                    pSDir.setValue(PSDir.EDirValue.getFromIDOrNull(string2));
                    continue;
                }
                pSDir.addForeignAttribute(string, string2);
            }
        }
        if (iMicroElement.hasChildren()) {
            block6: for (IMicroNode iMicroNode : iMicroElement.getChildren()) {
                switch (iMicroNode.getType()) {
                    case TEXT: {
                        pSDir.addText(((IMicroText)iMicroNode).getNodeValue());
                        continue block6;
                    }
                    case ELEMENT: {
                        string = (IMicroElement)iMicroNode;
                        if ("http://purl.oclc.org/dsdl/schematron".equals(string.getNamespaceURI())) {
                            this._warn(pSDir, "Unsupported Schematron element '" + string.getLocalName() + "'");
                            continue block6;
                        }
                        pSDir.addForeignElement(string.getClone());
                        continue block6;
                    }
                    case COMMENT: {
                        continue block6;
                    }
                }
                this._warn(pSDir, "Unsupported child node: " + iMicroNode);
            }
        }
        return pSDir;
    }

    @Nonnull
    public PSEmph readEmphFromXML(@Nonnull IMicroElement iMicroElement) {
        String string;
        PSEmph pSEmph = new PSEmph();
        Map map = iMicroElement.getAllAttributes();
        if (map != null) {
            for (Map.Entry iMicroNode : map.entrySet()) {
                string = (String)iMicroNode.getKey();
                String string2 = PSReader._getAttributeValue((String)iMicroNode.getValue());
                this._warn(pSEmph, "Unsupported attribute '" + string + "'='" + string2 + "'");
            }
        }
        if (iMicroElement.hasChildren()) {
            block6: for (IMicroNode iMicroNode : iMicroElement.getChildren()) {
                switch (iMicroNode.getType()) {
                    case TEXT: {
                        pSEmph.addText(((IMicroText)iMicroNode).getNodeValue());
                        continue block6;
                    }
                    case ELEMENT: {
                        string = (IMicroElement)iMicroNode;
                        if ("http://purl.oclc.org/dsdl/schematron".equals(string.getNamespaceURI())) {
                            this._warn(pSEmph, "Unsupported Schematron element '" + string.getLocalName() + "'");
                            continue block6;
                        }
                        this._warn(pSEmph, "Unsupported namespace URI '" + string.getNamespaceURI() + "'");
                        continue block6;
                    }
                    case COMMENT: {
                        continue block6;
                    }
                }
                this._warn(pSEmph, "Unsupported child node: " + iMicroNode);
            }
        }
        return pSEmph;
    }

    @Nonnull
    public PSExtends readExtendsFromXML(@Nonnull IMicroElement iMicroElement) {
        PSExtends pSExtends = new PSExtends();
        Map map = iMicroElement.getAllAttributes();
        if (map != null) {
            for (Map.Entry iMicroElement2 : map.entrySet()) {
                String string = (String)iMicroElement2.getKey();
                String string2 = PSReader._getAttributeValue((String)iMicroElement2.getValue());
                if (string.equals("rule")) {
                    pSExtends.setRule(string2);
                    continue;
                }
                pSExtends.addForeignAttribute(string, string2);
            }
        }
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements()) {
            if ("http://purl.oclc.org/dsdl/schematron".equals(iMicroElement2.getNamespaceURI())) {
                this._warn(pSExtends, "Unsupported Schematron element '" + iMicroElement2.getLocalName() + "'");
                continue;
            }
            this._warn(pSExtends, "Unsupported namespace URI '" + iMicroElement2.getNamespaceURI() + "'");
        }
        return pSExtends;
    }

    @Nonnull
    public PSInclude readIncludeFromXML(@Nonnull IMicroElement iMicroElement) {
        PSInclude pSInclude = new PSInclude();
        Map map = iMicroElement.getAllAttributes();
        if (map != null) {
            for (Map.Entry iMicroElement2 : map.entrySet()) {
                String string = (String)iMicroElement2.getKey();
                String string2 = PSReader._getAttributeValue((String)iMicroElement2.getValue());
                if (string.equals("href")) {
                    pSInclude.setHref(string2);
                    continue;
                }
                this._warn(pSInclude, "Unsupported attribute '" + string + "'='" + string2 + "'");
            }
        }
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements()) {
            if ("http://purl.oclc.org/dsdl/schematron".equals(iMicroElement2.getNamespaceURI())) {
                this._warn(pSInclude, "Unsupported Schematron element '" + iMicroElement2.getLocalName() + "'");
                continue;
            }
            this._warn(pSInclude, "Unsupported namespace URI '" + iMicroElement2.getNamespaceURI() + "'");
        }
        return pSInclude;
    }

    @Nonnull
    public PSLet readLetFromXML(@Nonnull IMicroElement iMicroElement) {
        PSLet pSLet = new PSLet();
        Map map = iMicroElement.getAllAttributes();
        if (map != null) {
            for (Map.Entry iMicroElement2 : map.entrySet()) {
                String string = (String)iMicroElement2.getKey();
                String string2 = PSReader._getAttributeValue((String)iMicroElement2.getValue());
                if (string.equals("name")) {
                    pSLet.setName(string2);
                    continue;
                }
                if (string.equals("value")) {
                    pSLet.setValue(string2);
                    continue;
                }
                this._warn(pSLet, "Unsupported attribute '" + string + "'='" + string2 + "'");
            }
        }
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements()) {
            if ("http://purl.oclc.org/dsdl/schematron".equals(iMicroElement2.getNamespaceURI())) {
                this._warn(pSLet, "Unsupported Schematron element '" + iMicroElement2.getLocalName() + "'");
                continue;
            }
            this._warn(pSLet, "Unsupported namespace URI '" + iMicroElement2.getNamespaceURI() + "'");
        }
        return pSLet;
    }

    @Nonnull
    public PSLinkableGroup readLinkableGroupFromXML(@Nullable Map<String, String> map) {
        PSLinkableGroup pSLinkableGroup = new PSLinkableGroup();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string = entry.getKey();
                String string2 = PSReader._getAttributeValue(entry.getValue());
                if (string.equals("role")) {
                    pSLinkableGroup.setRole(string2);
                    continue;
                }
                if (!string.equals("subject")) continue;
                pSLinkableGroup.setSubject(string2);
            }
        }
        return pSLinkableGroup;
    }

    @Nonnull
    public PSName readNameFromXML(@Nonnull IMicroElement iMicroElement) {
        PSName pSName = new PSName();
        Map map = iMicroElement.getAllAttributes();
        if (map != null) {
            for (Map.Entry iMicroElement2 : map.entrySet()) {
                String string = (String)iMicroElement2.getKey();
                String string2 = PSReader._getAttributeValue((String)iMicroElement2.getValue());
                if (string.equals("path")) {
                    pSName.setPath(string2);
                    continue;
                }
                pSName.addForeignAttribute(string, string2);
            }
        }
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements()) {
            if ("http://purl.oclc.org/dsdl/schematron".equals(iMicroElement2.getNamespaceURI())) {
                this._warn(pSName, "Unsupported Schematron element '" + iMicroElement2.getLocalName() + "'");
                continue;
            }
            this._warn(pSName, "Unsupported namespace URI '" + iMicroElement2.getNamespaceURI() + "'");
        }
        return pSName;
    }

    @Nonnull
    public PSNS readNSFromXML(@Nonnull IMicroElement iMicroElement) {
        PSNS pSNS = new PSNS();
        Map map = iMicroElement.getAllAttributes();
        if (map != null) {
            for (Map.Entry iMicroElement2 : map.entrySet()) {
                String string = (String)iMicroElement2.getKey();
                String string2 = PSReader._getAttributeValue((String)iMicroElement2.getValue());
                if (string.equals("uri")) {
                    pSNS.setUri(string2);
                    continue;
                }
                if (string.equals("prefix")) {
                    pSNS.setPrefix(string2);
                    continue;
                }
                pSNS.addForeignAttribute(string, string2);
            }
        }
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements()) {
            if ("http://purl.oclc.org/dsdl/schematron".equals(iMicroElement2.getNamespaceURI())) {
                this._warn(pSNS, "Unsupported Schematron element '" + iMicroElement2.getLocalName() + "'");
                continue;
            }
            this._warn(pSNS, "Unsupported namespace URI '" + iMicroElement2.getNamespaceURI() + "'");
        }
        return pSNS;
    }

    @Nonnull
    public PSP readPFromXML(@Nonnull IMicroElement iMicroElement) {
        String string;
        String string2;
        PSP pSP = new PSP();
        Map map = iMicroElement.getAllAttributes();
        if (map != null) {
            for (Map.Entry iMicroNode : map.entrySet()) {
                string2 = (String)iMicroNode.getKey();
                string = PSReader._getAttributeValue((String)iMicroNode.getValue());
                if (string2.equals("id")) {
                    pSP.setID(string);
                    continue;
                }
                if (string2.equals("class")) {
                    pSP.setClazz(string);
                    continue;
                }
                if (string2.equals("icon")) {
                    pSP.setIcon(string);
                    continue;
                }
                pSP.addForeignAttribute(string2, string);
            }
        }
        if (iMicroElement.hasChildren()) {
            for (IMicroNode iMicroNode : iMicroElement.getChildren()) {
                switch (iMicroNode.getType()) {
                    case TEXT: {
                        pSP.addText(((IMicroText)iMicroNode).getNodeValue());
                        break;
                    }
                    case ELEMENT: {
                        string2 = (IMicroElement)iMicroNode;
                        if ("http://purl.oclc.org/dsdl/schematron".equals(string2.getNamespaceURI())) {
                            string = string2.getLocalName();
                            if (string.equals("dir")) {
                                pSP.addDir(this.readDirFromXML((IMicroElement)string2));
                                break;
                            }
                            if (string.equals("emph")) {
                                pSP.addEmph(this.readEmphFromXML((IMicroElement)string2));
                                break;
                            }
                            if (string.equals("span")) {
                                pSP.addSpan(this.readSpanFromXML((IMicroElement)string2));
                                break;
                            }
                            this._warn(pSP, "Unsupported Schematron element '" + string + "'");
                            break;
                        }
                        pSP.addForeignElement(string2.getClone());
                        break;
                    }
                    case COMMENT: {
                        break;
                    }
                    default: {
                        this._warn(pSP, "Unsupported child node: " + iMicroNode);
                    }
                }
            }
        }
        return pSP;
    }

    @Nonnull
    public PSParam readParamFromXML(@Nonnull IMicroElement iMicroElement) {
        PSParam pSParam = new PSParam();
        Map map = iMicroElement.getAllAttributes();
        if (map != null) {
            for (Map.Entry iMicroElement2 : map.entrySet()) {
                String string = (String)iMicroElement2.getKey();
                String string2 = PSReader._getAttributeValue((String)iMicroElement2.getValue());
                if (string.equals("name")) {
                    pSParam.setName(string2);
                    continue;
                }
                if (string.equals("value")) {
                    pSParam.setValue(string2);
                    continue;
                }
                this._warn(pSParam, "Unsupported attribute '" + string + "'='" + string2 + "'");
            }
        }
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements()) {
            if ("http://purl.oclc.org/dsdl/schematron".equals(iMicroElement2.getNamespaceURI())) {
                this._warn(pSParam, "Unsupported Schematron element '" + iMicroElement2.getLocalName() + "'");
                continue;
            }
            this._warn(pSParam, "Unsupported namespace URI '" + iMicroElement2.getNamespaceURI() + "'");
        }
        return pSParam;
    }

    @Nonnull
    public PSPattern readPatternFromXML(@Nonnull IMicroElement iMicroElement) {
        PSPattern pSPattern = new PSPattern();
        Map map = iMicroElement.getAllAttributes();
        if (map != null) {
            for (Map.Entry iMicroElement2 : map.entrySet()) {
                String string = (String)iMicroElement2.getKey();
                String string2 = PSReader._getAttributeValue((String)iMicroElement2.getValue());
                if (string.equals("abstract")) {
                    pSPattern.setAbstract(StringParser.parseBool((String)string2));
                    continue;
                }
                if (string.equals("id")) {
                    pSPattern.setID(string2);
                    continue;
                }
                if (string.equals("is-a")) {
                    pSPattern.setIsA(string2);
                    continue;
                }
                if (PSRichGroup.isRichAttribute(string)) continue;
                pSPattern.addForeignAttribute(string, string2);
            }
            pSPattern.setRich(this.readRichGroupFromXML(map));
        }
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements()) {
            if ("http://purl.oclc.org/dsdl/schematron".equals(iMicroElement2.getNamespaceURI())) {
                if (iMicroElement2.getLocalName().equals("include")) {
                    pSPattern.addInclude(this.readIncludeFromXML(iMicroElement2));
                    continue;
                }
                if (iMicroElement2.getLocalName().equals("title")) {
                    pSPattern.setTitle(this.readTitleFromXML(iMicroElement2));
                    continue;
                }
                if (iMicroElement2.getLocalName().equals("p")) {
                    pSPattern.addP(this.readPFromXML(iMicroElement2));
                    continue;
                }
                if (iMicroElement2.getLocalName().equals("let")) {
                    pSPattern.addLet(this.readLetFromXML(iMicroElement2));
                    continue;
                }
                if (iMicroElement2.getLocalName().equals("rule")) {
                    pSPattern.addRule(this.readRuleFromXML(iMicroElement2));
                    continue;
                }
                if (iMicroElement2.getLocalName().equals("param")) {
                    pSPattern.addParam(this.readParamFromXML(iMicroElement2));
                    continue;
                }
                this._warn(pSPattern, "Unsupported Schematron element '" + iMicroElement2.getLocalName() + "' in " + pSPattern.toString());
                continue;
            }
            pSPattern.addForeignElement(iMicroElement2.getClone());
        }
        return pSPattern;
    }

    @Nonnull
    public PSPhase readPhaseFromXML(@Nonnull IMicroElement iMicroElement) {
        PSPhase pSPhase = new PSPhase();
        Map map = iMicroElement.getAllAttributes();
        if (map != null) {
            for (Map.Entry iMicroElement2 : map.entrySet()) {
                String string = (String)iMicroElement2.getKey();
                String string2 = PSReader._getAttributeValue((String)iMicroElement2.getValue());
                if (string.equals("id")) {
                    pSPhase.setID(string2);
                    continue;
                }
                if (PSRichGroup.isRichAttribute(string)) continue;
                pSPhase.addForeignAttribute(string, string2);
            }
            pSPhase.setRich(this.readRichGroupFromXML(map));
        }
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements()) {
            if ("http://purl.oclc.org/dsdl/schematron".equals(iMicroElement2.getNamespaceURI())) {
                if (iMicroElement2.getLocalName().equals("include")) {
                    pSPhase.addInclude(this.readIncludeFromXML(iMicroElement2));
                    continue;
                }
                if (iMicroElement2.getLocalName().equals("p")) {
                    pSPhase.addP(this.readPFromXML(iMicroElement2));
                    continue;
                }
                if (iMicroElement2.getLocalName().equals("let")) {
                    pSPhase.addLet(this.readLetFromXML(iMicroElement2));
                    continue;
                }
                if (iMicroElement2.getLocalName().equals("active")) {
                    pSPhase.addActive(this.readActiveFromXML(iMicroElement2));
                    continue;
                }
                this._warn(pSPhase, "Unsupported Schematron element '" + iMicroElement2.getLocalName() + "'");
                continue;
            }
            pSPhase.addForeignElement(iMicroElement2.getClone());
        }
        return pSPhase;
    }

    @Nonnull
    public PSRichGroup readRichGroupFromXML(@Nullable Map<String, String> map) {
        PSRichGroup pSRichGroup = new PSRichGroup();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string = entry.getKey();
                String string2 = PSReader._getAttributeValue(entry.getValue());
                if (string.equals("icon")) {
                    pSRichGroup.setIcon(string2);
                    continue;
                }
                if (string.equals("see")) {
                    pSRichGroup.setSee(string2);
                    continue;
                }
                if (string.equals("fpi")) {
                    pSRichGroup.setFPI(string2);
                    continue;
                }
                if (string.equals("xml:lang")) {
                    pSRichGroup.setXmlLang(string2);
                    continue;
                }
                if (!string.equals("xml:space")) continue;
                pSRichGroup.setXmlSpace(PSRichGroup.ESpace.getFromIDOrNull(string2));
            }
        }
        return pSRichGroup;
    }

    @Nonnull
    public PSRule readRuleFromXML(@Nonnull IMicroElement iMicroElement) {
        PSRule pSRule = new PSRule();
        Map map = iMicroElement.getAllAttributes();
        if (map != null) {
            for (Map.Entry iMicroElement2 : map.entrySet()) {
                String string = (String)iMicroElement2.getKey();
                String string2 = PSReader._getAttributeValue((String)iMicroElement2.getValue());
                if (string.equals("flag")) {
                    pSRule.setFlag(string2);
                    continue;
                }
                if (string.equals("abstract")) {
                    pSRule.setAbstract(StringParser.parseBool((String)string2));
                    continue;
                }
                if (string.equals("context")) {
                    pSRule.setContext(string2);
                    continue;
                }
                if (string.equals("id")) {
                    pSRule.setID(string2);
                    continue;
                }
                if (PSRichGroup.isRichAttribute(string) || PSLinkableGroup.isLinkableAttribute(string)) continue;
                pSRule.addForeignAttribute(string, string2);
            }
            pSRule.setRich(this.readRichGroupFromXML(map));
            pSRule.setLinkable(this.readLinkableGroupFromXML(map));
        }
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements()) {
            if ("http://purl.oclc.org/dsdl/schematron".equals(iMicroElement2.getNamespaceURI())) {
                if (iMicroElement2.getLocalName().equals("include")) {
                    pSRule.addInclude(this.readIncludeFromXML(iMicroElement2));
                    continue;
                }
                if (iMicroElement2.getLocalName().equals("let")) {
                    pSRule.addLet(this.readLetFromXML(iMicroElement2));
                    continue;
                }
                if (iMicroElement2.getLocalName().equals("assert") || iMicroElement2.getLocalName().equals("report")) {
                    pSRule.addAssertReport(this.readAssertReportFromXML(iMicroElement2));
                    continue;
                }
                if (iMicroElement2.getLocalName().equals("extends")) {
                    pSRule.addExtends(this.readExtendsFromXML(iMicroElement2));
                    continue;
                }
                this._warn(pSRule, "Unsupported Schematron element '" + iMicroElement2.getLocalName() + "'");
                continue;
            }
            pSRule.addForeignElement(iMicroElement2.getClone());
        }
        return pSRule;
    }

    @Nonnull
    public PSSchema readSchemaFromXML(@Nonnull IMicroElement iMicroElement) throws SchematronReadException {
        Object object;
        ValueEnforcer.notNull((Object)iMicroElement, (String)"Schema");
        if (!"http://purl.oclc.org/dsdl/schematron".equals(iMicroElement.getNamespaceURI())) {
            throw new SchematronReadException(this.m_aResource, "The passed element is not an ISO Schematron element!");
        }
        PSSchema pSSchema = new PSSchema(this.m_aResource);
        Map map = iMicroElement.getAllAttributes();
        if (map != null) {
            for (Map.Entry iMicroElement2 : map.entrySet()) {
                object = (String)iMicroElement2.getKey();
                String string = PSReader._getAttributeValue((String)iMicroElement2.getValue());
                if (((String)object).equals("id")) {
                    pSSchema.setID(string);
                    continue;
                }
                if (((String)object).equals("schemaVersion")) {
                    pSSchema.setSchemaVersion(string);
                    continue;
                }
                if (((String)object).equals("defaultPhase")) {
                    pSSchema.setDefaultPhase(string);
                    continue;
                }
                if (((String)object).equals("queryBinding")) {
                    pSSchema.setQueryBinding(string);
                    continue;
                }
                if (PSRichGroup.isRichAttribute((String)object)) continue;
                pSSchema.addForeignAttribute((String)object, string);
            }
            pSSchema.setRich(this.readRichGroupFromXML(map));
        }
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements()) {
            if ("http://purl.oclc.org/dsdl/schematron".equals(iMicroElement2.getNamespaceURI())) {
                if (iMicroElement2.getLocalName().equals("include")) {
                    pSSchema.addInclude(this.readIncludeFromXML(iMicroElement2));
                    continue;
                }
                if (iMicroElement2.getLocalName().equals("title")) {
                    pSSchema.setTitle(this.readTitleFromXML(iMicroElement2));
                    continue;
                }
                if (iMicroElement2.getLocalName().equals("ns")) {
                    pSSchema.addNS(this.readNSFromXML(iMicroElement2));
                    continue;
                }
                if (iMicroElement2.getLocalName().equals("p")) {
                    object = this.readPFromXML(iMicroElement2);
                    if (pSSchema.hasNoPatterns()) {
                        pSSchema.addStartP((PSP)object);
                        continue;
                    }
                    pSSchema.addEndP((PSP)object);
                    continue;
                }
                if (iMicroElement2.getLocalName().equals("let")) {
                    pSSchema.addLet(this.readLetFromXML(iMicroElement2));
                    continue;
                }
                if (iMicroElement2.getLocalName().equals("phase")) {
                    pSSchema.addPhase(this.readPhaseFromXML(iMicroElement2));
                    continue;
                }
                if (iMicroElement2.getLocalName().equals("pattern")) {
                    pSSchema.addPattern(this.readPatternFromXML(iMicroElement2));
                    continue;
                }
                if (iMicroElement2.getLocalName().equals("diagnostics")) {
                    pSSchema.setDiagnostics(this.readDiagnosticsFromXML(iMicroElement2));
                    continue;
                }
                this._warn(pSSchema, "Unsupported Schematron element '" + iMicroElement2.getLocalName() + "'");
                continue;
            }
            pSSchema.addForeignElement(iMicroElement2.getClone());
        }
        return pSSchema;
    }

    @Nonnull
    public PSSpan readSpanFromXML(@Nonnull IMicroElement iMicroElement) {
        String string;
        PSSpan pSSpan = new PSSpan();
        Map map = iMicroElement.getAllAttributes();
        if (map != null) {
            for (Map.Entry iMicroNode : map.entrySet()) {
                string = (String)iMicroNode.getKey();
                String string2 = PSReader._getAttributeValue((String)iMicroNode.getValue());
                if (string.equals("class")) {
                    pSSpan.setClazz(string2);
                    continue;
                }
                pSSpan.addForeignAttribute(string, string2);
            }
        }
        if (iMicroElement.hasChildren()) {
            block6: for (IMicroNode iMicroNode : iMicroElement.getChildren()) {
                switch (iMicroNode.getType()) {
                    case TEXT: {
                        pSSpan.addText(((IMicroText)iMicroNode).getNodeValue());
                        continue block6;
                    }
                    case ELEMENT: {
                        string = (IMicroElement)iMicroNode;
                        if ("http://purl.oclc.org/dsdl/schematron".equals(string.getNamespaceURI())) {
                            this._warn(pSSpan, "Unsupported Schematron element '" + string.getLocalName() + "'");
                            continue block6;
                        }
                        pSSpan.addForeignElement(string.getClone());
                        continue block6;
                    }
                    case COMMENT: {
                        continue block6;
                    }
                }
                this._warn(pSSpan, "Unsupported child node: " + iMicroNode);
            }
        }
        return pSSpan;
    }

    @Nonnull
    public PSTitle readTitleFromXML(@Nonnull IMicroElement iMicroElement) {
        String string;
        String string2;
        PSTitle pSTitle = new PSTitle();
        Map map = iMicroElement.getAllAttributes();
        if (map != null) {
            for (Map.Entry iMicroNode : map.entrySet()) {
                string2 = (String)iMicroNode.getKey();
                string = PSReader._getAttributeValue((String)iMicroNode.getValue());
                this._warn(pSTitle, "Unsupported attribute '" + string2 + "'='" + string + "'");
            }
        }
        if (iMicroElement.hasChildren()) {
            for (IMicroNode iMicroNode : iMicroElement.getChildren()) {
                switch (iMicroNode.getType()) {
                    case TEXT: {
                        pSTitle.addText(((IMicroText)iMicroNode).getNodeValue());
                        break;
                    }
                    case ELEMENT: {
                        string2 = (IMicroElement)iMicroNode;
                        if ("http://purl.oclc.org/dsdl/schematron".equals(string2.getNamespaceURI())) {
                            string = string2.getLocalName();
                            if (string.equals("dir")) {
                                pSTitle.addDir(this.readDirFromXML((IMicroElement)string2));
                                break;
                            }
                            this._warn(pSTitle, "Unsupported Schematron element '" + string + "'");
                            break;
                        }
                        this._warn(pSTitle, "Unsupported namespace URI '" + string2.getNamespaceURI() + "'");
                        break;
                    }
                    case COMMENT: {
                        break;
                    }
                    default: {
                        this._warn(pSTitle, "Unsupported child node: " + iMicroNode);
                    }
                }
            }
        }
        return pSTitle;
    }

    @Nonnull
    public PSValueOf readValueOfFromXML(@Nonnull IMicroElement iMicroElement) {
        PSValueOf pSValueOf = new PSValueOf();
        Map map = iMicroElement.getAllAttributes();
        if (map != null) {
            for (Map.Entry iMicroElement2 : map.entrySet()) {
                String string = (String)iMicroElement2.getKey();
                String string2 = PSReader._getAttributeValue((String)iMicroElement2.getValue());
                if (string.equals("select")) {
                    pSValueOf.setSelect(string2);
                    continue;
                }
                pSValueOf.addForeignAttribute(string, string2);
            }
        }
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements()) {
            if ("http://purl.oclc.org/dsdl/schematron".equals(iMicroElement2.getNamespaceURI())) {
                this._warn(pSValueOf, "Unsupported Schematron element '" + iMicroElement2.getLocalName() + "'");
                continue;
            }
            this._warn(pSValueOf, "Unsupported namespace URI '" + iMicroElement2.getNamespaceURI() + "'");
        }
        return pSValueOf;
    }

    @Nonnull
    public PSSchema readSchema() throws SchematronReadException {
        IMicroDocument iMicroDocument = SchematronHelper.getWithResolvedSchematronIncludes(this.m_aResource);
        if (iMicroDocument == null || iMicroDocument.getDocumentElement() == null) {
            throw new SchematronReadException(this.m_aResource, "Failed to resolve includes in resource " + this.m_aResource);
        }
        return this.readSchemaFromXML(iMicroDocument.getDocumentElement());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("resource", (Object)this.m_aResource).append("errorHandler", (Object)this.m_aErrorHandler).toString();
    }
}

