/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.errorhandler;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.error.EErrorLevel;
import com.phloc.commons.error.IResourceError;
import com.phloc.commons.error.IResourceErrorGroup;
import com.phloc.commons.error.IResourceLocation;
import com.phloc.commons.error.ResourceError;
import com.phloc.commons.error.ResourceErrorGroup;
import com.phloc.commons.error.ResourceLocation;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.lang.CGStringHelper;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.pure.errorhandler.AbstractPSErrorHandler;
import com.phloc.schematron.pure.errorhandler.IPSErrorHandler;
import com.phloc.schematron.pure.model.IPSElement;
import com.phloc.schematron.pure.model.IPSHasID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CollectingPSErrorHandler
extends AbstractPSErrorHandler {
    private final ResourceErrorGroup m_aErrors = new ResourceErrorGroup();

    public CollectingPSErrorHandler() {
    }

    public CollectingPSErrorHandler(@Nullable IPSErrorHandler iPSErrorHandler) {
        super(iPSErrorHandler);
    }

    @Override
    protected void handle(@Nullable IReadableResource iReadableResource, @Nonnull EErrorLevel eErrorLevel, @Nonnull IPSElement iPSElement, @Nonnull String string, @Nullable Throwable throwable) {
        String string2 = CGStringHelper.getClassLocalName((Object)iPSElement);
        if (iPSElement instanceof IPSHasID && ((IPSHasID)((Object)iPSElement)).hasID()) {
            string2 = string2 + " [ID=" + ((IPSHasID)((Object)iPSElement)).getID() + "]";
        }
        this.m_aErrors.addResourceError((IResourceError)new ResourceError((IResourceLocation)new ResourceLocation(iReadableResource == null ? null : iReadableResource.getResourceID(), string2), eErrorLevel, string, throwable));
    }

    @Nonnull
    @ReturnsMutableCopy
    public IResourceErrorGroup getResourceErrors() {
        return this.m_aErrors.getClone();
    }

    @Nonnull
    public EChange clearResourceErrors() {
        return this.m_aErrors.clear();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("errors", (Object)this.m_aErrors).toString();
    }
}

