/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.bound.xpath;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.xpath.XPathHelper;
import com.phloc.schematron.pure.binding.IPSQueryBinding;
import com.phloc.schematron.pure.binding.SchematronBindException;
import com.phloc.schematron.pure.binding.xpath.PSXPathVariables;
import com.phloc.schematron.pure.bound.AbstractPSBoundSchema;
import com.phloc.schematron.pure.bound.xpath.PSXPathBoundAssertReport;
import com.phloc.schematron.pure.bound.xpath.PSXPathBoundDiagnostic;
import com.phloc.schematron.pure.bound.xpath.PSXPathBoundElement;
import com.phloc.schematron.pure.bound.xpath.PSXPathBoundPattern;
import com.phloc.schematron.pure.bound.xpath.PSXPathBoundRule;
import com.phloc.schematron.pure.errorhandler.IPSErrorHandler;
import com.phloc.schematron.pure.model.IPSElement;
import com.phloc.schematron.pure.model.IPSHasForeignAttributes;
import com.phloc.schematron.pure.model.IPSHasMixedContent;
import com.phloc.schematron.pure.model.PSAssertReport;
import com.phloc.schematron.pure.model.PSDiagnostic;
import com.phloc.schematron.pure.model.PSName;
import com.phloc.schematron.pure.model.PSPattern;
import com.phloc.schematron.pure.model.PSPhase;
import com.phloc.schematron.pure.model.PSRule;
import com.phloc.schematron.pure.model.PSSchema;
import com.phloc.schematron.pure.model.PSValueOf;
import com.phloc.schematron.pure.validation.IPSValidationHandler;
import com.phloc.schematron.pure.validation.SchematronValidationException;
import com.phloc.schematron.pure.validation.xpath.PSXPathValidationHandlerSVRL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.oclc.purl.dsdl.svrl.SchematronOutputType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public class PSXPathBoundSchema
extends AbstractPSBoundSchema {
    private final List<PSXPathBoundPattern> m_aBoundPatterns;

    @Nullable
    private List<PSXPathBoundElement> _createBoundElements(@Nonnull IPSHasMixedContent iPSHasMixedContent, @Nonnull XPath xPath, @Nonnull PSXPathVariables pSXPathVariables) {
        ArrayList<PSXPathBoundElement> arrayList = new ArrayList<PSXPathBoundElement>();
        for (Object object : iPSHasMixedContent.getAllContentElements()) {
            XPathExpression xPathExpression;
            String string;
            IPSHasForeignAttributes iPSHasForeignAttributes;
            if (object instanceof PSName) {
                iPSHasForeignAttributes = (PSName)object;
                if (((PSName)iPSHasForeignAttributes).hasPath()) {
                    string = pSXPathVariables.getAppliedReplacement(((PSName)iPSHasForeignAttributes).getPath());
                    try {
                        xPathExpression = xPath.compile(string);
                        arrayList.add(new PSXPathBoundElement(iPSHasForeignAttributes, string, xPathExpression));
                        continue;
                    }
                    catch (XPathExpressionException xPathExpressionException) {
                        this.error((IPSElement)((Object)iPSHasForeignAttributes), "Failed to compile XPath expression in <name>: '" + string + "'", xPathExpressionException);
                        return null;
                    }
                }
                arrayList.add(new PSXPathBoundElement(iPSHasForeignAttributes));
                continue;
            }
            if (object instanceof PSValueOf) {
                iPSHasForeignAttributes = (PSValueOf)object;
                string = pSXPathVariables.getAppliedReplacement(((PSValueOf)iPSHasForeignAttributes).getSelect());
                try {
                    xPathExpression = xPath.compile(string);
                    arrayList.add(new PSXPathBoundElement(iPSHasForeignAttributes, string, xPathExpression));
                    continue;
                }
                catch (XPathExpressionException xPathExpressionException) {
                    this.error((IPSElement)((Object)iPSHasForeignAttributes), "Failed to compile XPath expression in <value-of>: '" + string + "'", xPathExpressionException);
                    return null;
                }
            }
            arrayList.add(new PSXPathBoundElement(object));
        }
        return arrayList;
    }

    @Nullable
    private Map<String, PSXPathBoundDiagnostic> _createBoundDiagnostics(@Nonnull XPath xPath, @Nonnull PSXPathVariables pSXPathVariables) {
        HashMap<String, PSXPathBoundDiagnostic> hashMap = new HashMap<String, PSXPathBoundDiagnostic>();
        PSSchema pSSchema = this.getOriginalSchema();
        if (pSSchema.hasDiagnostics()) {
            for (PSDiagnostic pSDiagnostic : pSSchema.getDiagnostics().getAllDiagnostics()) {
                List<PSXPathBoundElement> list = this._createBoundElements(pSDiagnostic, xPath, pSXPathVariables);
                if (list == null) {
                    return null;
                }
                PSXPathBoundDiagnostic pSXPathBoundDiagnostic = new PSXPathBoundDiagnostic(pSDiagnostic, list);
                if (hashMap.put(pSDiagnostic.getID(), pSXPathBoundDiagnostic) == null) continue;
                this.error(pSDiagnostic, "A diagnostic element with ID '" + pSDiagnostic.getID() + "' was overwritten!");
                return null;
            }
        }
        return hashMap;
    }

    @Nullable
    private List<PSXPathBoundPattern> _createBoundPatterns(@Nonnull XPath xPath, @Nonnull Map<String, PSXPathBoundDiagnostic> map, @Nonnull PSXPathVariables pSXPathVariables) {
        ArrayList<PSXPathBoundPattern> arrayList = new ArrayList<PSXPathBoundPattern>();
        for (PSPattern pSPattern : this.getAllRelevantPatterns()) {
            ArrayList<String> arrayList2 = null;
            if (pSPattern.hasAnyLet()) {
                for (Map.Entry entry : pSPattern.getAllLetsAsMap().entrySet()) {
                    if (pSXPathVariables.add(entry).isUnchanged()) {
                        this.warn(pSPattern, "Duplicate let with name '" + (String)entry.getKey() + "' in <pattern> - second definition is ignored");
                        continue;
                    }
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<String>();
                    }
                    arrayList2.add((String)entry.getKey());
                }
            }
            ArrayList arrayList3 = new ArrayList();
            for (PSRule pSRule : pSPattern.getAllRules()) {
                Object object;
                ArrayList<String> arrayList4 = null;
                if (pSRule.hasAnyLet()) {
                    for (Map.Entry entry : pSRule.getAllLetsAsMap().entrySet()) {
                        if (pSXPathVariables.add(entry).isUnchanged()) {
                            this.warn(pSRule, "Duplicate let with name '" + (String)entry.getKey() + "' in <rule> - second definition is ignored");
                            continue;
                        }
                        if (arrayList4 == null) {
                            arrayList4 = new ArrayList<String>();
                        }
                        arrayList4.add((String)entry.getKey());
                    }
                }
                ArrayList arrayList5 = new ArrayList();
                for (PSAssertReport pSAssertReport : pSRule.getAllAssertReports()) {
                    object = pSXPathVariables.getAppliedReplacement(pSAssertReport.getTest());
                    try {
                        XPathExpression xPathExpression = xPath.compile((String)object);
                        List<PSXPathBoundElement> list = this._createBoundElements(pSAssertReport, xPath, pSXPathVariables);
                        if (list == null) {
                            return null;
                        }
                        PSXPathBoundAssertReport pSXPathBoundAssertReport = new PSXPathBoundAssertReport(pSAssertReport, (String)object, xPathExpression, list, map);
                        arrayList5.add(pSXPathBoundAssertReport);
                    }
                    catch (XPathExpressionException xPathExpressionException) {
                        this.error(pSAssertReport, "Failed to compile XPath expression in <" + (pSAssertReport.isAssert() ? "assert" : "report") + ">: '" + (String)object + "' " + pSXPathVariables, xPathExpressionException);
                        return null;
                    }
                }
                String string = pSXPathVariables.getAppliedReplacement(this.getValidationContext(pSRule.getContext()));
                Object var14_23 = null;
                try {
                    object = xPath.compile(string);
                    PSXPathBoundRule pSXPathBoundRule = new PSXPathBoundRule(pSRule, string, (XPathExpression)object, arrayList5);
                    arrayList3.add(pSXPathBoundRule);
                }
                catch (XPathExpressionException xPathExpressionException) {
                    this.error(pSRule, "Failed to compile XPath expression in <rule>: '" + string + "'", xPathExpressionException);
                    return null;
                }
                pSXPathVariables.removeAll(arrayList4);
            }
            PSXPathBoundPattern object2 = new PSXPathBoundPattern(pSPattern, arrayList3);
            arrayList.add(object2);
            pSXPathVariables.removeAll(arrayList2);
        }
        return arrayList;
    }

    public PSXPathBoundSchema(@Nonnull IPSQueryBinding iPSQueryBinding, @Nonnull PSSchema pSSchema, @Nullable String string, @Nullable IPSErrorHandler iPSErrorHandler) throws SchematronBindException {
        super(iPSQueryBinding, pSSchema, string, iPSErrorHandler);
        Iterator<Map.Entry<String, String>> iterator;
        Map.Entry<String, String> entry2;
        PSSchema pSSchema2 = this.getOriginalSchema();
        PSPhase pSPhase = this.getPhase();
        PSXPathVariables pSXPathVariables = new PSXPathVariables();
        if (pSSchema2.hasAnyLet()) {
            for (Map.Entry<String, String> entry2 : pSSchema2.getAllLetsAsMap().entrySet()) {
                pSXPathVariables.add(entry2);
            }
        }
        if (pSPhase != null) {
            for (Map.Entry<String, String> entry2 : pSPhase.getAllLetsAsMap().entrySet()) {
                if (!pSXPathVariables.add(entry2).isUnchanged()) continue;
                this.warn(pSSchema2, "Duplicate let with name '" + (String)entry2.getKey() + "' in <phase> with name '" + string + "' - second definition is ignored");
            }
        }
        try {
            iterator = XPathFactory.newInstance();
        }
        catch (Exception exception) {
            throw new SchematronBindException("Failed to create XPathFactory", exception);
        }
        entry2 = XPathHelper.createNewXPath(iterator, (XPathVariableResolver)null, (XPathFunctionResolver)null, (NamespaceContext)this.getNamespaceContext());
        Map<String, PSXPathBoundDiagnostic> map = this._createBoundDiagnostics((XPath)((Object)entry2), pSXPathVariables);
        if (map == null) {
            throw new SchematronBindException("Failed to precompile the diagnostics of the supplied schema. Check the log for XPath errors!");
        }
        this.m_aBoundPatterns = this._createBoundPatterns((XPath)((Object)entry2), map, pSXPathVariables);
        if (this.m_aBoundPatterns == null) {
            throw new SchematronBindException("Failed to precompile the supplied schema. Check the log for XPath errors!");
        }
    }

    @Override
    @Nonnull
    public String getValidationContext(@Nonnull String string) {
        if (string.startsWith("/")) {
            return string;
        }
        return "//" + string;
    }

    @Override
    public void validate(@Nonnull Node node, @Nonnull IPSValidationHandler iPSValidationHandler) throws SchematronValidationException {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        ValueEnforcer.notNull((Object)iPSValidationHandler, (String)"ValidationHandler");
        PSSchema pSSchema = this.getOriginalSchema();
        PSPhase pSPhase = this.getPhase();
        iPSValidationHandler.onStart(pSSchema, pSPhase);
        for (PSXPathBoundPattern pSXPathBoundPattern : this.m_aBoundPatterns) {
            PSPattern pSPattern = pSXPathBoundPattern.getPattern();
            iPSValidationHandler.onPattern(pSPattern);
            for (PSXPathBoundRule pSXPathBoundRule : pSXPathBoundPattern.getAllBoundRules()) {
                PSRule pSRule = pSXPathBoundRule.getRule();
                iPSValidationHandler.onRule(pSRule, pSXPathBoundRule.getRuleExpression());
                NodeList nodeList = null;
                try {
                    nodeList = (NodeList)pSXPathBoundRule.getBoundRuleExpression().evaluate(node, XPathConstants.NODESET);
                }
                catch (XPathExpressionException xPathExpressionException) {
                    this.error(pSRule, "Failed to evaluate XPath expression to a nodeset: '" + pSXPathBoundRule.getRuleExpression() + "'", xPathExpressionException);
                    continue;
                }
                int n = nodeList.getLength();
                if (n <= 0) continue;
                for (PSXPathBoundAssertReport pSXPathBoundAssertReport : pSXPathBoundRule.getAllBoundAssertReports()) {
                    PSAssertReport pSAssertReport = pSXPathBoundAssertReport.getAssertReport();
                    boolean bl = pSAssertReport.isAssert();
                    XPathExpression xPathExpression = pSXPathBoundAssertReport.getBoundTestExpression();
                    for (int i = 0; i < n; ++i) {
                        Node node2 = nodeList.item(i);
                        try {
                            boolean bl2 = (Boolean)xPathExpression.evaluate(node2, XPathConstants.BOOLEAN);
                            if (!(bl ? !bl2 && iPSValidationHandler.onFailedAssert(pSAssertReport, pSXPathBoundAssertReport.getTestExpression(), node2, i, pSXPathBoundAssertReport).isBreak() : bl2 && iPSValidationHandler.onSuccessfulReport(pSAssertReport, pSXPathBoundAssertReport.getTestExpression(), node2, i, pSXPathBoundAssertReport).isBreak())) continue;
                            return;
                        }
                        catch (XPathExpressionException xPathExpressionException) {
                            this.error(pSRule, "Failed to evaluate XPath expression to a boolean: '" + pSXPathBoundAssertReport.getTestExpression() + "'", xPathExpressionException);
                        }
                    }
                }
            }
        }
        iPSValidationHandler.onEnd(pSSchema, pSPhase);
    }

    @Override
    @Nonnull
    public SchematronOutputType validateComplete(@Nonnull Node node) throws SchematronValidationException {
        PSXPathValidationHandlerSVRL pSXPathValidationHandlerSVRL = new PSXPathValidationHandlerSVRL(this.getErrorHandler());
        this.validate(node, pSXPathValidationHandlerSVRL);
        return pSXPathValidationHandlerSVRL.getSVRL();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("boundPatterns", this.m_aBoundPatterns).toString();
    }
}

