/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.tasks.parts.controls;

import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.tasks.model.TaskTriggerType;
import ch.elexis.core.ui.tasks.parts.controls.AbstractTaskDescriptorConfigurationComposite;
import java.text.ParseException;
import net.redhogs.cronparser.CronExpressionDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.quartz.CronExpression;

public class TaskTriggerTypeConfigurationComposite
extends AbstractTaskDescriptorConfigurationComposite {
    private ComboViewer comboViewer;
    private Composite compositeParameters;

    public TaskTriggerTypeConfigurationComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        Label lblType = new Label((Composite)this, 0);
        lblType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblType.setText("type");
        this.comboViewer = new ComboViewer((Composite)this, 0);
        Combo combo = this.comboViewer.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewer.setInput((Object)TaskTriggerType.VALUES);
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                TaskTriggerType type = (TaskTriggerType)element;
                return type.getName();
            }
        });
        this.comboViewer.addSelectionChangedListener(sel -> {
            TaskTriggerType taskTriggerType = (TaskTriggerType)sel.getStructuredSelection().getFirstElement();
            if (this.taskDescriptor != null && this.taskDescriptor.getTriggerType() != taskTriggerType) {
                this.taskDescriptor.setTriggerType(taskTriggerType);
                this.saveTaskDescriptor();
            }
            this.refreshParameterComposite(taskTriggerType);
        });
        this.compositeParameters = new Composite((Composite)this, 0);
        GridLayout gl_compositeParameters = new GridLayout(2, false);
        gl_compositeParameters.marginHeight = 0;
        gl_compositeParameters.marginWidth = 0;
        this.compositeParameters.setLayout((Layout)gl_compositeParameters);
        this.compositeParameters.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.refreshParameterComposite(null);
    }

    private void refreshParameterComposite(TaskTriggerType taskTriggerType) {
        Control[] children;
        Control[] controlArray = children = this.compositeParameters.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        if (taskTriggerType != null) {
            switch (taskTriggerType) {
                case CRON: {
                    this.createCompositeParameters_CRON();
                    break;
                }
                default: {
                    this.createCompositeParameters_FALLBACK();
                    break;
                }
            }
        } else {
            this.createCompositeParameters_FALLBACK();
        }
        this.compositeParameters.layout(true);
    }

    private void createCompositeParameters_FALLBACK() {
        Label label = new Label(this.compositeParameters, 0);
        label.setText("Please select a trigger type");
        label.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
    }

    private void createCompositeParameters_CRON() {
        String cron = this.taskDescriptor != null ? (String)this.taskDescriptor.getTriggerParameters().get("cron") : "";
        Label label = new Label(this.compositeParameters, 0);
        label.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        label.setText("cron");
        final Text text = new Text(this.compositeParameters, 2048);
        text.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        text.setText(cron != null ? cron : "");
        Label valid = new Label(this.compositeParameters, 64);
        valid.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        text.addModifyListener(event -> {
            String value = ((Text)event.widget).getText();
            boolean isValidCron = this.validateAndupdateCronExpressionDescriptor(value, valid);
            if (isValidCron) {
                this.taskDescriptor.setTriggerParameter("cron", value);
                this.saveTaskDescriptor();
            }
        });
        Button btnEveryMinute = new Button(this.compositeParameters, this.getStyle());
        btnEveryMinute.setText("set every minute");
        btnEveryMinute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                text.setText("0 * * * * ?");
            }
        });
        this.validateAndupdateCronExpressionDescriptor(cron, valid);
    }

    private boolean validateAndupdateCronExpressionDescriptor(String cron, Label label) {
        boolean validExpression = CronExpression.isValidExpression((String)(cron = cron == null ? "" : cron));
        if (validExpression) {
            try {
                String description = CronExpressionDescriptor.getDescription((String)cron);
                label.setText(description);
            }
            catch (IllegalArgumentException | ParseException e) {
                label.setText(e.getMessage());
            }
        } else {
            label.setText("Invalid expression");
        }
        return validExpression;
    }

    @Override
    public void setSelection(ITaskDescriptor taskDescriptor) {
        this.taskDescriptor = taskDescriptor;
        if (taskDescriptor != null) {
            this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)taskDescriptor.getTriggerType()));
        } else {
            this.comboViewer.setSelection(null);
        }
    }
}

