/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.ui;

import ch.elexis.core.ui.dbcheck.RefIntegrityCheckExec;
import ch.elexis.core.ui.dbcheck.SemanticCheckExec;
import ch.elexis.core.ui.dbcheck.SyntacticCheckExec;
import ch.elexis.core.ui.dbcheck.external.ExecExternalContribution;
import ch.elexis.core.ui.dbcheck.external.ExtContributionsLabelProvider;
import ch.elexis.core.ui.dbcheck.external.ExternalContributions;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.core.ui.dbcheck.model.DBModel;
import ch.elexis.data.PersistentObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class DBTestDialog
extends TrayDialog {
    protected Object result;
    private StyledText checkStatus;
    private Button btnSyntax;
    private Button btnSemantic;
    private Button btnReferentialIntegrity;
    private Composite composite;
    private Composite container;
    private Text logFile;
    private FileDialog fileChooser;
    private ComboViewer extContributions;
    private Button exec;
    private Group grpAusgabeInDatei;
    private DBCheckJob dbCheckJob;

    public DBTestDialog(Shell parent) {
        super(parent);
        this.setShellStyle(48);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Datenbank Wartungs Tool");
    }

    protected Control createDialogArea(Composite parent) {
        this.setHelpAvailable(true);
        DBTestDialog.setDialogHelpAvailable((boolean)true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "ch.elexis.core.ui.dbcheck.DBCheckTrayDialog");
        this.container = (Composite)super.createDialogArea(parent);
        this.container.setLayout((Layout)new GridLayout(2, false));
        Button btnNewButton = new Button(this.container, 0);
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProgressMonitorDialog pmd = new ProgressMonitorDialog(null);
                IRunnableWithProgress dbcheck = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            boolean logOK = false;
                            OutputStreamWriter out = null;
                            FileOutputStream fos = null;
                            File log = new File(DBTestDialog.this.logFile.getText().trim());
                            if (DBTestDialog.this.logFile.getText().length() > 0) {
                                log.createNewFile();
                            }
                            if (log.exists() && log.canWrite()) {
                                logOK = true;
                            }
                            monitor.beginTask("Datenbank-Test l\u00e4uft...", 5);
                            StringBuilder sb = new StringBuilder();
                            SyntacticCheckExec.setJDBCLink(PersistentObject.getConnection());
                            sb.append(String.valueOf(SyntacticCheckExec.getDBInformation()) + "\n");
                            StyleRange styleDBInfo = new StyleRange();
                            styleDBInfo.start = 0;
                            styleDBInfo.length = sb.length();
                            styleDBInfo.fontStyle = 1;
                            sb.length();
                            String DBcontainedVersion = SyntacticCheckExec.getDBVersion();
                            String[] isValid = DBModel.getTableModel(DBcontainedVersion);
                            if (isValid.length <= 1) {
                                sb.append("Nicht unterst\u00fctzte DB Version: " + DBcontainedVersion);
                                DBTestDialog.this.checkStatus.setText(sb.toString());
                                monitor.done();
                                return;
                            }
                            sb.append("--- Database Version Consistence ---\n");
                            monitor.subTask("Pr\u00fcfe Datenbank Konsistenz");
                            sb.append(String.valueOf(SyntacticCheckExec.checkDBVersionConsistence()) + "\n");
                            monitor.worked(1);
                            monitor.subTask("Checking Syntax");
                            if (DBTestDialog.this.btnSyntax.getSelection()) {
                                sb.append("--- Syntactic Check---\n");
                                sb.append(SyntacticCheckExec.doSyntacticCheckOffCore(monitor));
                            }
                            monitor.worked(2);
                            monitor.subTask("Checking Semantics");
                            if (DBTestDialog.this.btnSemantic.getSelection()) {
                                sb.append("--- Semantic Check ---\n");
                                SemanticCheckExec.setJDBCLink(PersistentObject.getConnection());
                                sb.append(SemanticCheckExec.doSemanticCheckOffCore(monitor));
                            }
                            monitor.worked(3);
                            monitor.subTask("Checking referential integrity");
                            if (DBTestDialog.this.btnReferentialIntegrity.getSelection()) {
                                sb.append("--- Referential Integrity ---\n");
                                RefIntegrityCheckExec.setJDBCLink(PersistentObject.getConnection());
                                sb.append(RefIntegrityCheckExec.doReferentialIntegrityCheckOffCore(monitor));
                            }
                            sb.append("--- DONE ---\n");
                            monitor.worked(4);
                            DBTestDialog.this.checkStatus.setText(sb.toString());
                            DBTestDialog.this.checkStatus.setStyleRange(styleDBInfo);
                            monitor.done();
                            if (logOK) {
                                fos = new FileOutputStream(new File(DBTestDialog.this.logFile.getText().trim()));
                                out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                                Date date = new Date();
                                out.append("=== " + dateFormat.format(date) + " ===\n");
                                out.append(sb.toString());
                                out.append("--- OUTPUT LOG Syntactic Check ---\n");
                                out.append(String.valueOf(SyntacticCheckExec.getOutputLog()) + "\n");
                                out.append("--- OUTPUT LOG Semantic Check ---\n");
                                out.append(String.valueOf(SemanticCheckExec.getOutputLog()) + "\n");
                                out.append("--- OUTPUT LOG Referential Integrity Check ---\n");
                                out.append(String.valueOf(RefIntegrityCheckExec.getOutputLog()) + "\n");
                                out.close();
                                fos.close();
                            }
                        }
                        catch (FileNotFoundException e) {
                            Status status = new Status(4, "ch.elexis.core.ui.dbcheck", e.getLocalizedMessage(), (Throwable)e);
                            StatusManager.getManager().handle((IStatus)status, 2);
                        }
                        catch (UnsupportedEncodingException e) {
                            Status status = new Status(4, "ch.elexis.core.ui.dbcheck", e.getLocalizedMessage(), (Throwable)e);
                            StatusManager.getManager().handle((IStatus)status, 2);
                        }
                        catch (IOException e) {
                            Status status = new Status(4, "ch.elexis.core.ui.dbcheck", e.getLocalizedMessage(), (Throwable)e);
                            StatusManager.getManager().handle((IStatus)status, 2);
                        }
                    }
                };
                try {
                    pmd.run(false, false, dbcheck);
                }
                catch (InterruptedException | InvocationTargetException e1) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(e1.getMessage());
                    Throwable cause = e1.getCause();
                    if (cause != null) {
                        sb.append(": " + cause.getMessage());
                    }
                    Status status = new Status(4, "ch.elexis.core.ui.dbcheck", sb.toString(), (Throwable)e1);
                    e1.printStackTrace();
                    StatusManager.getManager().handle((IStatus)status, 2);
                }
            }
        });
        btnNewButton.setText("DB Pr\u00fcfen");
        Group grpPrfoptionen = new Group(this.container, 0);
        grpPrfoptionen.setLayout((Layout)new GridLayout(2, true));
        grpPrfoptionen.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpPrfoptionen.setText("Optionen");
        this.btnSyntax = new Button((Composite)grpPrfoptionen, 32);
        this.btnSyntax.setSelection(true);
        this.btnSyntax.setText("Syntaxtest");
        this.btnSemantic = new Button((Composite)grpPrfoptionen, 32);
        this.btnSemantic.setText("Semantictest");
        this.btnReferentialIntegrity = new Button((Composite)grpPrfoptionen, 32);
        this.btnReferentialIntegrity.setForeground(SWTResourceManager.getColor(3));
        this.btnReferentialIntegrity.setToolTipText("ACHTUNG: Kann sehr lange dauern!");
        this.btnReferentialIntegrity.setText("Referential Integrity Test");
        new Label((Composite)grpPrfoptionen, 0);
        this.checkStatus = new StyledText(this.container, 2890);
        this.checkStatus.setEditable(false);
        GridData gd_checkStatus = new GridData(4, 4, true, true, 2, 1);
        gd_checkStatus.minimumWidth = 400;
        gd_checkStatus.minimumHeight = 250;
        this.checkStatus.setLayoutData((Object)gd_checkStatus);
        this.grpAusgabeInDatei = new Group(this.container, 0);
        this.grpAusgabeInDatei.setText("Ausgabe in Datei speichern (optional)");
        this.grpAusgabeInDatei.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.grpAusgabeInDatei.setLayout((Layout)new GridLayout(2, false));
        this.composite = new Composite((Composite)this.grpAusgabeInDatei, 0);
        this.composite.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        this.composite.setLayout((Layout)new GridLayout(2, false));
        this.logFile = new Text(this.composite, 2048);
        this.logFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.logFile.setBounds(0, 0, 64, 19);
        Button btnNewButton_1 = new Button(this.composite, 0);
        btnNewButton_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBTestDialog.this.fileChooser = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 12288);
                DBTestDialog.this.fileChooser.setText("Ausgabedatei f\u00fcr Datenbank-Test w\u00e4hlen...");
                String file = DBTestDialog.this.fileChooser.open();
                if (file != null) {
                    DBTestDialog.this.logFile.setText(file);
                }
            }
        });
        btnNewButton_1.setBounds(0, 0, 94, 30);
        btnNewButton_1.setText("W\u00e4hlen...");
        Group external = new Group(this.container, 0);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        external.setLayoutData((Object)gridData);
        external.setLayout((Layout)new GridLayout(2, false));
        external.setText("External Maintenance Tools");
        this.extContributions = new ComboViewer((Composite)external, 0);
        this.extContributions.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.extContributions.setLabelProvider((IBaseLabelProvider)new ExtContributionsLabelProvider());
        this.extContributions.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.extContributions.setInput(ExternalContributions.getExt());
        this.extContributions.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.getFirstElement() instanceof ExternalMaintenance) {
                    DBTestDialog.this.exec.setEnabled(true);
                }
            }
        });
        this.exec = new Button((Composite)external, 8);
        this.exec.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.exec.setText("Execute");
        this.exec.setEnabled(false);
        this.exec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final ExternalMaintenance m = (ExternalMaintenance)((IStructuredSelection)DBTestDialog.this.extContributions.getSelection()).getFirstElement();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DBTestDialog.this.dbCheckJob = new DBCheckJob(m);
                        DBTestDialog.this.dbCheckJob.setUser(true);
                        DBTestDialog.this.dbCheckJob.schedule();
                    }
                });
            }
        });
        return this.container;
    }

    protected void setExecOutput(final String execOutput) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DBTestDialog.this.checkStatus.setText(execOutput);
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Beenden", true);
    }

    protected void okPressed() {
        if (this.dbCheckJob == null || this.dbCheckJob.getState() == 0) {
            super.okPressed();
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Laufende Datenbank Wartung", (String)"Zuletzt gestartete Datenbank\u00fcberpr\u00fcfung noch nicht abgeschlossen...\n(siehe rechts unten)");
        }
    }

    class DBCheckJob
    extends Job {
        private ExternalMaintenance extMaintenance;

        public DBCheckJob(ExternalMaintenance extMaintenance) {
            super("Datenbank Wartung");
            this.extMaintenance = extMaintenance;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ExecExternalContribution eec = new ExecExternalContribution(this.extMaintenance);
                eec.run(monitor);
                DBTestDialog.this.setExecOutput(eec.getOutput());
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
                Status status = new Status(4, "ch.elexis.core.ui.dbcheck", e1.getMessage());
                StatusManager.getManager().handle((IStatus)status, 2);
                return status;
            }
            catch (InterruptedException e1) {
                Status status = new Status(4, "ch.elexis.core.ui.dbcheck", e1.getLocalizedMessage());
                StatusManager.getManager().handle((IStatus)status, 2);
                return status;
            }
            return Status.OK_STATUS;
        }
    }
}

