/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class ReChargeTarmedOpenCons
extends ExternalMaintenance {
    private List<String> problems = new ArrayList<String>();
    protected ICodeElementService codeElementService;
    private ServiceReference<ICodeElementService> serviceRef;
    private boolean currentMandantOnly;

    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        Integer count = 0;
        if (this.initCodeElementService()) {
            this.getCurrentMandantOnly();
            boolean presetBillingStrict = ConfigServiceHolder.getUser((String)"billing/strict", (boolean)false);
            ConfigServiceHolder.setUser((String)"billing/strict", (boolean)false);
            List<Konsultation> consultations = this.getKonsultation(this.getBeginOfYear(), this.getEndOfYear());
            pm.beginTask("Bitte warten, Tarmed Leistungen werden neu verrechnet", consultations.size());
            for (Konsultation konsultation : consultations) {
                if (konsultation.getRechnung() != null) continue;
                IEncounter encounter = (IEncounter)NoPoUtil.loadAsIdentifiable((PersistentObject)konsultation, IEncounter.class).get();
                if (pm.isCanceled()) {
                    this.addProblem("Cancelled.", encounter);
                    return this.getProblemsString();
                }
                List<IBilled> tarmedVerrechnet = this.getTarmedOnly(encounter.getBilled());
                for (IBilled tarmedVerr : tarmedVerrechnet) {
                    IBillable verrechenbar = tarmedVerr.getBillable();
                    if (verrechenbar != null) {
                        Optional matchingVerrechenbar = this.codeElementService.loadFromString(verrechenbar.getCodeSystemName(), verrechenbar.getCode(), this.getContext(encounter));
                        if (matchingVerrechenbar.isPresent()) {
                            double amount = tarmedVerr.getAmount();
                            this.removeVerrechnet(encounter, tarmedVerr);
                            this.addVerrechnet(encounter, matchingVerrechenbar, amount);
                            continue;
                        }
                        this.addProblem("Could not find matching Verrechenbar for [" + verrechenbar.getCodeSystemName() + "->" + verrechenbar.getCode() + "]", encounter);
                        continue;
                    }
                    this.addProblem("Could not find Verrechenbar for [" + tarmedVerr.getLabel() + "]", encounter);
                }
                count = count + 1;
                pm.worked(1);
            }
            ConfigServiceHolder.setUser((String)"billing/strict", (boolean)presetBillingStrict);
            pm.done();
            this.deInitCodeElementService();
        }
        return "Tarmed Leistungen von [" + count + "] Konsultationen des Jahres [" + this.getBeginOfYear().get(1) + "] neu verrechnet" + this.getProblemsString();
    }

    private void getCurrentMandantOnly() {
        Display.getDefault().syncExec(() -> {
            this.currentMandantOnly = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Nur Mandant neu verrechnen", (String)"Sollen die offenen Konsultationen aller Mandanten (Nein), oder nur des aktiven (Ja) neu verrechnet werden?");
        });
    }

    protected TimeTool getBeginOfYear() {
        TimeTool beginOfYear = new TimeTool();
        beginOfYear.set(2, 0);
        beginOfYear.set(5, 1);
        return beginOfYear;
    }

    protected TimeTool getEndOfYear() {
        TimeTool endOfYear = this.getBeginOfYear();
        endOfYear.set(2, 11);
        endOfYear.set(5, 31);
        return endOfYear;
    }

    private void addVerrechnet(IEncounter encounter, Optional<ICodeElement> matchingVerrechenbar, double amount) {
        int i = 0;
        while ((double)i < amount) {
            Result addRes = BillingServiceHolder.get().bill((IBillable)matchingVerrechenbar.get(), encounter, amount);
            if (!addRes.isOK()) {
                this.addProblem("Could not add Verrechenbar [" + matchingVerrechenbar.get().getCode() + "]" + "[" + addRes.toString() + "]", encounter);
            }
            ++i;
        }
    }

    private void removeVerrechnet(IEncounter encounter, IBilled tarmedVerr) {
        LockResponse result = LocalLockServiceHolder.get().acquireLockBlocking((Object)tarmedVerr, 10, (IProgressMonitor)new NullProgressMonitor());
        if (result.isOk()) {
            LockResponse releaseLock;
            Result removeRes = BillingServiceHolder.get().removeBilled(tarmedVerr, encounter);
            if (!removeRes.isOK()) {
                this.addProblem("Could not remove Verrechnet [" + tarmedVerr.getLabel() + "]" + "[" + removeRes.toString() + "]", encounter);
            }
            if (!(releaseLock = LocalLockServiceHolder.get().releaseLock(result.getLockInfo())).isOk()) {
                this.addProblem("Could not release lock for Verrechnet [" + tarmedVerr.getLabel() + "]" + "[" + removeRes.toString() + "]", encounter);
            }
        } else {
            this.addProblem("Could not remove Verrechnet [" + tarmedVerr.getLabel() + "]" + "[ could not acquire lock ]", encounter);
        }
    }

    private HashMap<Object, Object> getContext(IEncounter encounter) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        if (encounter != null) {
            ret.put(ICodeElementService.ContextKeys.CONSULTATION, encounter);
            ICoverage coverage = encounter.getCoverage();
            if (coverage != null) {
                ret.put(ICodeElementService.ContextKeys.COVERAGE, coverage);
            }
        }
        return ret;
    }

    private void deInitCodeElementService() {
        BundleContext context = FrameworkUtil.getBundle(ReChargeTarmedOpenCons.class).getBundleContext();
        if (this.serviceRef != null) {
            context.ungetService(this.serviceRef);
            this.codeElementService = null;
        }
    }

    private boolean initCodeElementService() {
        BundleContext context = FrameworkUtil.getBundle(ReChargeTarmedOpenCons.class).getBundleContext();
        this.serviceRef = context.getServiceReference(ICodeElementService.class);
        if (this.serviceRef != null) {
            this.codeElementService = (ICodeElementService)context.getService(this.serviceRef);
            return true;
        }
        return false;
    }

    private List<IBilled> getTarmedOnly(List<IBilled> list) {
        ArrayList<IBilled> ret = new ArrayList<IBilled>();
        for (IBilled verrechnet : list) {
            IBillable billable = verrechnet.getBillable();
            if (!billable.getCodeSystemName().contains("Tarmed")) continue;
            ret.add(verrechnet);
        }
        return ret;
    }

    public List<Konsultation> getKonsultation(TimeTool from, TimeTool to) {
        Query qbe = new Query(Konsultation.class);
        qbe.add("Datum", ">=", from.toString(9));
        if (to != null) {
            qbe.add("Datum", "<=", to.toString(9));
        }
        if (this.currentMandantOnly) {
            qbe.add("MandantID", "=", CoreHub.actMandant.getId());
        }
        return qbe.execute();
    }

    private String getProblemsString() {
        if (this.problems != null && !this.problems.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\nProblems:\n");
            this.problems.stream().forEach(problem -> {
                StringBuilder stringBuilder2 = sb.append(String.valueOf(problem) + "\n");
            });
            return sb.toString();
        }
        return "";
    }

    private void addProblem(String prefix, IEncounter cons) {
        this.problems.add("[" + prefix + "]" + "[" + cons.getId() + "] - [" + cons.getLabel() + "] of [" + cons.getPatient().getLabel() + "]");
    }

    @Override
    public String getMaintenanceDescription() {
        return "Tarmed Leistungen aller offenen Konsultationen dieses Jahres neu verrechnen";
    }
}

