/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.util.DocumentLetterUtil;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IQueryCursor;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class MoveAllLettersToExternalStorage
extends ExternalMaintenance {
    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        StringBuilder result = new StringBuilder();
        int okCount = 0;
        int failCount = 0;
        IQuery query = CoreModelServiceHolder.get().getQuery(IDocumentLetter.class);
        Throwable throwable = null;
        Object var8_9 = null;
        try (IQueryCursor letters = query.executeAsCursor();){
            pm.beginTask(Messages.Texterstellung_save_all_letters_externally, letters.size());
            while (letters.hasNext()) {
                IDocumentLetter letter = (IDocumentLetter)letters.next();
                try {
                    boolean ok = this.exportToExtern(letter, result);
                    if (ok) {
                        ++okCount;
                    } else {
                        ++failCount;
                        result.append("[" + letter.getId() + "] could not export: see log\n");
                    }
                    pm.worked(1);
                }
                catch (IOException e) {
                    ++failCount;
                    result.append("[" + letter.getId() + "] could not export: " + e.getMessage() + "\n");
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        pm.done();
        return String.valueOf(okCount) + " OK / " + failCount + " FAIL\n" + result.toString();
    }

    @Override
    public String getMaintenanceDescription() {
        return "[EXPLETT] Export all letters from DB storage to external storage";
    }

    public boolean exportToExtern(IDocumentLetter letter, StringBuilder result) throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle externalHandle = DocumentLetterUtil.getExternalHandleIfApplicable((IDocument)letter);
        if (externalHandle != null && externalHandle.exists() && externalHandle.canRead()) {
            return true;
        }
        byte[] content = null;
        Throwable throwable = null;
        Object var6_8 = null;
        try (InputStream letterInputStream = letter.getContent();){
            if (letterInputStream != null) {
                content = IOUtils.toByteArray((InputStream)letterInputStream);
            } else {
                result.append("[" + letter.getId() + "] content is null\n");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (content != null) {
            throwable = null;
            var6_8 = null;
            try (ByteArrayInputStream is = new ByteArrayInputStream(content);){
                letter.setContent((InputStream)is);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        return true;
    }
}

