/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.IContext;
import java.util.Optional;

public interface IContextService {
    public IContext getRootContext();

    default public Optional<IUser> getActiveUser() {
        return this.getRootContext().getTyped(IUser.class);
    }

    default public void setActiveUser(IUser user) {
        if (user != null) {
            this.getRootContext().setTyped(user);
        } else {
            this.getRootContext().removeTyped(IUser.class);
        }
    }

    default public Optional<IContact> getActiveUserContact() {
        return this.getRootContext().getNamed("ch.elexis.core.services.icontext.active.usercontact");
    }

    default public Optional<IPatient> getActivePatient() {
        return this.getRootContext().getTyped(IPatient.class);
    }

    default public void setActivePatient(IPatient patient) {
        if (patient != null) {
            this.getRootContext().setTyped(patient);
        } else {
            this.getRootContext().removeTyped(IPatient.class);
        }
    }

    default public Optional<IMandator> getActiveMandator() {
        return this.getRootContext().getTyped(IMandator.class);
    }

    default public void setActiveMandator(IMandator mandator) {
        if (mandator != null) {
            this.getRootContext().setTyped(mandator);
        } else {
            this.getRootContext().removeTyped(IMandator.class);
        }
    }

    default public Optional<ICoverage> getActiveCoverage() {
        return this.getRootContext().getTyped(ICoverage.class);
    }

    default public void setActiveCoverage(ICoverage coverage) {
        if (coverage != null) {
            this.getRootContext().setTyped(coverage);
        } else {
            this.getRootContext().removeTyped(ICoverage.class);
        }
    }

    default public String getStationIdentifier() {
        return this.getRootContext().getStationIdentifier();
    }

    default public <T> Optional<T> getTyped(Class<T> clazz) {
        return this.getRootContext().getTyped(clazz);
    }

    default public Optional<?> getNamed(String name) {
        return this.getRootContext().getNamed(name);
    }

    public Optional<IContext> getNamedContext(String var1);

    public IContext createNamedContext(String var1);

    public void releaseContext(String var1);

    public void postEvent(String var1, Object var2);

    public void sendEvent(String var1, Object var2);
}

