/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser.dom;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.attoparser.dom.AbstractNestableNode;
import org.attoparser.dom.INestableNode;
import org.attoparser.dom.INode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
extends AbstractNestableNode
implements Serializable {
    private static final long serialVersionUID = -8980986739486971174L;
    private String elementName;
    private Map<String, String> attributes = null;
    private int attributesLen = 0;

    public Element(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Element name cannot be null");
        }
        this.elementName = name;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Element name cannot be null");
        }
        this.elementName = name;
    }

    public boolean elementNameMatches(String name) {
        return this.elementName.equals(name);
    }

    public int numAttributes() {
        return this.attributesLen;
    }

    public boolean hasAttributes() {
        return this.attributesLen != 0;
    }

    public boolean hasAttribute(String attributeName) {
        if (this.attributesLen > 0) {
            return this.attributes.containsKey(attributeName);
        }
        return false;
    }

    public String getAttributeValue(String attributeName) {
        if (this.attributesLen > 0) {
            return this.attributes.get(attributeName);
        }
        return null;
    }

    public Map<String, String> getAttributeMap() {
        if (this.attributesLen > 0) {
            return Collections.unmodifiableMap(this.attributes);
        }
        return Collections.emptyMap();
    }

    public void addAttribute(String attributeName, String attributeValue) {
        if (this.attributesLen == 0) {
            this.attributes = new LinkedHashMap<String, String>();
        }
        this.attributes.put(attributeName, attributeValue);
        ++this.attributesLen;
    }

    public void addAttributes(Map<String, String> newAttributes) {
        if (newAttributes != null) {
            if (this.attributesLen == 0) {
                this.attributes = new LinkedHashMap<String, String>();
            }
            this.attributes.putAll(newAttributes);
            this.attributesLen += newAttributes.size();
        }
    }

    public void removeAttribute(String attributeName) {
        if (this.attributesLen > 0 && this.attributes.containsKey(attributeName)) {
            this.attributes.remove(attributeName);
            --this.attributesLen;
            if (this.attributesLen == 0) {
                this.attributes = null;
            }
        }
    }

    public void clearAttributes() {
        this.attributes = null;
        this.attributesLen = 0;
    }

    @Override
    public Element cloneNode(INestableNode parent) {
        Element element = new Element(this.elementName);
        element.addAttributes(this.attributes);
        for (INode child : this.getChildren()) {
            INode clonedChild = child.cloneNode(element);
            element.addChild(clonedChild);
        }
        element.setLine(this.getLine());
        element.setCol(this.getCol());
        element.setParent(parent);
        return element;
    }
}

