/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.internal;

import ch.elexis.core.findings.util.internal.FindingsFormat;
import ch.elexis.core.findings.util.internal.JsonStructuralFeature;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class FindingsFormat24
extends FindingsFormat {
    public FindingsFormat24() {
        HashMap<String, JsonStructuralFeature> conditionFields = new HashMap<String, JsonStructuralFeature>();
        conditionFields.put("resourceType", new JsonStructuralFeature("resourceType", JsonStructuralFeature.Type.PRIMITIVE));
        conditionFields.put("id", new JsonStructuralFeature("id", JsonStructuralFeature.Type.PRIMITIVE));
        conditionFields.put("text", new JsonStructuralFeature("text", JsonStructuralFeature.Type.OBJECT));
        conditionFields.put("category", new JsonStructuralFeature("category", JsonStructuralFeature.Type.ARRAY));
        conditionFields.put("code", new JsonStructuralFeature("code", JsonStructuralFeature.Type.OBJECT));
        conditionFields.put("subject", new JsonStructuralFeature("subject", JsonStructuralFeature.Type.OBJECT));
        conditionFields.put("assertedDate", new JsonStructuralFeature("assertedDate", JsonStructuralFeature.Type.PRIMITIVE));
        this.resourceFieldsMap.put("Condition", conditionFields);
        HashMap<String, JsonStructuralFeature> encounterFields = new HashMap<String, JsonStructuralFeature>();
        encounterFields.put("resourceType", new JsonStructuralFeature("resourceType", JsonStructuralFeature.Type.PRIMITIVE));
        encounterFields.put("id", new JsonStructuralFeature("id", JsonStructuralFeature.Type.PRIMITIVE));
        encounterFields.put("text", new JsonStructuralFeature("text", JsonStructuralFeature.Type.OBJECT));
        encounterFields.put("diagnosis", new JsonStructuralFeature("diagnosis", JsonStructuralFeature.Type.ARRAY));
        encounterFields.put("subject", new JsonStructuralFeature("subject", JsonStructuralFeature.Type.OBJECT));
        this.resourceFieldsMap.put("Encounter", encounterFields);
        HashMap<String, JsonStructuralFeature> procedureRequestFields = new HashMap<String, JsonStructuralFeature>();
        procedureRequestFields.put("resourceType", new JsonStructuralFeature("resourceType", JsonStructuralFeature.Type.PRIMITIVE));
        procedureRequestFields.put("id", new JsonStructuralFeature("id", JsonStructuralFeature.Type.PRIMITIVE));
        procedureRequestFields.put("text", new JsonStructuralFeature("text", JsonStructuralFeature.Type.OBJECT));
        procedureRequestFields.put("context", new JsonStructuralFeature("context", JsonStructuralFeature.Type.OBJECT));
        this.resourceFieldsMap.put("ProcedureRequest", procedureRequestFields);
    }

    @Override
    public int isFindingsFormat(String rawContent) {
        JsonObject jsonObject = this.getJsonObject(rawContent);
        JsonElement resourceType = jsonObject.get("resourceType");
        return this.checkFindingsFormatProperties(resourceType, jsonObject);
    }

    private int checkFindingsFormatProperties(JsonElement resourceType, JsonObject jsonObject) {
        switch (resourceType.getAsString()) {
            case "Condition": {
                return this.checkFields((Map)this.resourceFieldsMap.get("Condition"), jsonObject);
            }
            case "Encounter": {
                return this.checkFields((Map)this.resourceFieldsMap.get("Encounter"), jsonObject);
            }
            case "ProcedureRequest": {
                return this.checkFields((Map)this.resourceFieldsMap.get("ProcedureRequest"), jsonObject);
            }
        }
        return 0;
    }

    @Override
    public Optional<String> convertToCurrentFormat(String rawContent) {
        return Optional.empty();
    }
}

