/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.LoggingUtils;
import org.thymeleaf.util.Validate;

public final class TemplateSpec
implements Serializable {
    private static final long serialVersionUID = 81254123L;
    private final String template;
    private final Set<String> templateSelectors;
    private final TemplateMode templateMode;
    private final Map<String, Object> templateResolutionAttributes;

    public TemplateSpec(String template, TemplateMode templateMode) {
        this(template, null, templateMode, null);
    }

    public TemplateSpec(String template, Map<String, Object> templateResolutionAttributes) {
        this(template, null, null, templateResolutionAttributes);
    }

    public TemplateSpec(String template, Set<String> templateSelectors, TemplateMode templateMode, Map<String, Object> templateResolutionAttributes) {
        Validate.notNull(template, "Template cannot be null");
        this.template = template;
        if (templateSelectors != null && !templateSelectors.isEmpty()) {
            Validate.containsNoEmpties(templateSelectors, "If specified, the Template Selector set cannot contain any nulls or empties");
            this.templateSelectors = templateSelectors.size() == 1 ? Collections.singleton(templateSelectors.iterator().next()) : Collections.unmodifiableSet(new TreeSet<String>(templateSelectors));
        } else {
            this.templateSelectors = null;
        }
        this.templateMode = templateMode;
        this.templateResolutionAttributes = templateResolutionAttributes != null && !templateResolutionAttributes.isEmpty() ? Collections.unmodifiableMap(new HashMap<String, Object>(templateResolutionAttributes)) : null;
    }

    public String getTemplate() {
        return this.template;
    }

    public boolean hasTemplateSelectors() {
        return this.templateSelectors != null;
    }

    public Set<String> getTemplateSelectors() {
        return this.templateSelectors;
    }

    public boolean hasTemplateMode() {
        return this.templateMode != null;
    }

    public TemplateMode getTemplateMode() {
        return this.templateMode;
    }

    public boolean hasTemplateResolutionAttributes() {
        return this.templateResolutionAttributes != null;
    }

    public Map<String, Object> getTemplateResolutionAttributes() {
        return this.templateResolutionAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TemplateSpec)) {
            return false;
        }
        TemplateSpec that = (TemplateSpec)o;
        if (!this.template.equals(that.template)) {
            return false;
        }
        if (this.templateSelectors != null ? !this.templateSelectors.equals(that.templateSelectors) : that.templateSelectors != null) {
            return false;
        }
        if (this.templateMode != that.templateMode) {
            return false;
        }
        return !(this.templateResolutionAttributes == null ? that.templateResolutionAttributes != null : !this.templateResolutionAttributes.equals(that.templateResolutionAttributes));
    }

    public int hashCode() {
        int result = this.template.hashCode();
        result = 31 * result + (this.templateSelectors != null ? this.templateSelectors.hashCode() : 0);
        result = 31 * result + (this.templateMode != null ? this.templateMode.hashCode() : 0);
        result = 31 * result + (this.templateResolutionAttributes != null ? this.templateResolutionAttributes.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(LoggingUtils.loggifyTemplateName(this.template));
        if (this.templateSelectors != null) {
            strBuilder.append("::");
            strBuilder.append(this.templateSelectors);
        }
        if (this.templateMode != null) {
            strBuilder.append(" @");
            strBuilder.append((Object)this.templateMode);
        }
        if (this.templateResolutionAttributes != null) {
            strBuilder.append(" (");
            strBuilder.append(this.templateResolutionAttributes);
            strBuilder.append(")");
        }
        return strBuilder.toString();
    }
}

