/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.model.adapter.mixin;

import ch.elexis.core.jpa.entities.EntityWithExtInfo;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.jpa.model.util.JpaModelUtil;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class ExtInfoHandler {
    private AbstractIdModelAdapter<? extends EntityWithExtInfo> withExtInfo;
    private Map<Object, Object> extInfo;

    public ExtInfoHandler(AbstractIdModelAdapter<? extends EntityWithExtInfo> withExtInfo) {
        this.withExtInfo = withExtInfo;
    }

    private void doLoadExtInfo() {
        if (this.extInfo == null) {
            byte[] bytes = this.withExtInfo.getEntity().getExtInfo();
            this.extInfo = bytes != null ? JpaModelUtil.extInfoFromBytes(bytes) : new Hashtable<Object, Object>();
        }
    }

    public Object getExtInfo(Object key) {
        this.doLoadExtInfo();
        return this.extInfo.get(key);
    }

    public void setExtInfo(Object key, Object value) {
        this.doLoadExtInfo();
        if (value == null) {
            this.extInfo.remove(key);
        } else {
            this.extInfo.put(key, value);
        }
        this.withExtInfo.getEntityMarkDirty().setExtInfo(JpaModelUtil.extInfoToBytes(this.extInfo));
    }

    public void resetExtInfo() {
        this.extInfo = null;
    }

    public Map<Object, Object> getMap() {
        this.doLoadExtInfo();
        return new HashMap<Object, Object>(this.extInfo);
    }
}

