/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.handlers;

import ch.elexis.core.ac.AccessControlDefaults;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.locks.AcquireLockUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.medication.views.MedicationTableViewerItem;
import ch.elexis.core.ui.medication.views.MedicationView;
import ch.elexis.core.ui.medication.views.Messages;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage activePage = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage();
        ISelection selection = activePage.getSelection();
        IWorkbenchPart activePart = activePage.getActivePart();
        if (activePart != null && activePart instanceof MedicationView) {
            MedicationView mediView = (MedicationView)activePart;
            mediView.resetSelection();
        }
        if (selection != null && !selection.isEmpty() && MessageDialog.openQuestion((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.FixMediDisplay_DeleteUnrecoverable, (String)Messages.FixMediDisplay_DeleteUnrecoverable)) {
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            Iterator selectionList = strucSelection.iterator();
            while (selectionList.hasNext()) {
                boolean hasRight = AccessControlServiceHolder.get().request(AccessControlDefaults.DELETE_MEDICATION);
                if (!hasRight) continue;
                MedicationTableViewerItem item = (MedicationTableViewerItem)selectionList.next();
                final IPrescription prescription = item.getPrescription();
                AcquireLockUi.aquireAndRun((Identifiable)prescription, (ILockHandler)new ILockHandler(){

                    public void lockFailed() {
                    }

                    public void lockAcquired() {
                        CoreModelServiceHolder.get().delete((Deleteable)prescription);
                        ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)prescription);
                    }
                });
            }
        }
        return null;
    }
}

