/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.Validate;
import org.unbescape.css.CssEscape;
import org.unbescape.html.HtmlEscape;
import org.unbescape.javascript.JavaScriptEscape;
import org.unbescape.xml.XmlEscape;

public final class EscapedAttributeUtils {
    public static String unescapeAttribute(TemplateMode templateMode, String input) {
        Validate.notNull((Object)templateMode, "Template mode cannot be null");
        switch (templateMode) {
            case TEXT: 
            case HTML: {
                return HtmlEscape.unescapeHtml((String)input);
            }
            case XML: {
                return XmlEscape.unescapeXml((String)input);
            }
            case JAVASCRIPT: {
                return JavaScriptEscape.unescapeJavaScript((String)input);
            }
            case CSS: {
                return CssEscape.unescapeCss((String)input);
            }
            case RAW: {
                return input;
            }
        }
        throw new TemplateProcessingException("Unrecognized template mode " + (Object)((Object)templateMode) + ". Cannot unescape attribute value for this template mode.");
    }

    private EscapedAttributeUtils() {
    }
}

