/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.util.CoreUiUtil;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.FallDetailBlatt2;
import ch.elexis.data.Anwender;
import ch.elexis.data.Fall;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;

public class FallDetailView
extends ViewPart {
    public static final String ID = "ch.elexis.FallDetailView";
    FallDetailBlatt2 fdb;
    private final ElexisEventListener eeli_user = new ElexisUiEventListenerImpl(Anwender.class, 64){

        @Override
        public void runInUi(ElexisEvent ev) {
            FallDetailView.this.fdb.reloadBillingSystemsMenu();
        }
    };
    private final ElexisEventListener eeli_fall = new ElexisUiEventListenerImpl(Fall.class){

        @Override
        public void runInUi(ElexisEvent ev) {
            Fall fall = (Fall)ev.getObject();
            Fall deselectedFall = null;
            switch (ev.getType()) {
                case 16: {
                    deselectedFall = FallDetailView.this.fdb.getFall();
                    FallDetailView.this.fdb.setFall((IFall)fall);
                    if (deselectedFall == null) break;
                    FallDetailView.this.releaseAndRefreshLock((IPersistentObject)deselectedFall, "ch.elexis.core.ui.command.ToggleCurrentCaseLockCommand");
                    break;
                }
                case 32: {
                    deselectedFall = FallDetailView.this.fdb.getFall();
                    FallDetailView.this.fdb.setFall(null);
                    if (deselectedFall == null) break;
                    FallDetailView.this.releaseAndRefreshLock((IPersistentObject)deselectedFall, "ch.elexis.core.ui.command.ToggleCurrentCaseLockCommand");
                    break;
                }
                case 4096: 
                case 16384: {
                    if (!fall.equals((Object)FallDetailView.this.fdb.getFall())) break;
                    FallDetailView.this.fdb.setUnlocked(ev.getType() == 4096);
                    break;
                }
            }
        }
    };

    private void releaseAndRefreshLock(IPersistentObject object, String commandId) {
        if (object != null && LocalLockServiceHolder.get().isLockedLocal((Object)object)) {
            LocalLockServiceHolder.get().releaseLock((Object)object);
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        commandService.refreshElements(commandId, null);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.fdb = new FallDetailBlatt2(parent);
        this.fdb.setLayoutData(SWTHelper.getFillGridData(1, true, 1, true));
        this.fdb.setUnlocked(false);
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_fall, this.eeli_user});
    }

    public void setFocus() {
        Fall f = (Fall)ElexisEventDispatcher.getSelected(Fall.class);
        this.fdb.setFall((IFall)f);
    }

    public void dispose() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_fall, this.eeli_user});
        super.dispose();
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout(part, currentState);
    }

    public Fall getActiveFall() {
        return this.fdb.getFall();
    }
}

