/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.text;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.text.IRichTextDisplay;
import ch.elexis.core.ui.util.IKonsExtension;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.TextView;
import ch.elexis.data.Brief;
import ch.rgw.tools.ExHandler;
import java.util.Collections;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class XrefExtension
implements IKonsExtension {
    IRichTextDisplay tx;

    @Override
    public String connect(IRichTextDisplay tf) {
        this.tx = tf;
        return "ch.elexis.text.DocXRef";
    }

    @Override
    public boolean doLayout(StyleRange n, String provider, String id) {
        n.background = UiDesk.getColor("hellblau");
        n.foreground = UiDesk.getColor("grau20");
        return true;
    }

    @Override
    public boolean doXRef(String refProvider, String refID) {
        try {
            if (CoreHub.localCfg.get("briefe/Textmodul_Edit_Local", false)) {
                this.startLocalEdit(Brief.load((String)refID));
            } else {
                TextView tv = (TextView)Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.TextView");
                tv.openDocument(Brief.load((String)refID));
            }
            return true;
        }
        catch (PartInitException e) {
            ExHandler.handle((Throwable)e);
            return false;
        }
    }

    private void startLocalEdit(Brief brief) {
        if (brief != null) {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command command = commandService.getCommand("ch.elexis.core.ui.command.startEditLocalDocument");
            ((IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class)).set(command.getId().concat(".selection"), (Object)new StructuredSelection((Object)brief));
            try {
                command.executeWithChecks(new ExecutionEvent(command, Collections.EMPTY_MAP, (Object)this, null));
            }
            catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.BriefAuswahl_errorttile, (String)Messages.BriefAuswahl_erroreditmessage);
            }
        }
    }

    @Override
    public IAction[] getActions() {
        return null;
    }

    @Override
    public void removeXRef(String refProvider, String refID) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    @Override
    public void insert(Object o, int pos) {
    }
}

