/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.services.internal;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IContext;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.dialogs.SelectFallNoObligationDialog;
import ch.elexis.core.ui.services.internal.Context;
import ch.elexis.core.ui.util.CoreUiUtil;
import ch.elexis.data.Anwender;
import ch.elexis.data.Brief;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.elexis.data.User;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"event.topics=org/eclipse/e4/ui/LifeCycle/appStartupComplete"})
public class ContextService
implements IContextService,
EventHandler {
    private static Logger logger = LoggerFactory.getLogger(ContextService.class);
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    private Context root;
    private ConcurrentHashMap<String, Context> contexts;
    private SelectionEventDispatcherListener eventDispatcherListener;
    private ReloadEventDispatcherListener reloadEventDispatcherListener;
    private LockingEventDispatcherListener lockingEventDispatcherListener;
    private UserChangedEventDispatcherListener userChangedEventDispatcherListener;
    private MandatorChangedEventDispatcherListener mandatorChangedEventDispatcherListener;
    private CompatibilityEventDispatcherListener compatibilityEventDispatcherListener;
    private IEclipseContext applicationContext;
    @Reference
    private EventAdmin eventAdmin;

    @Activate
    public void activate() {
        logger.info("ACTIVATE");
        this.root = new Context();
        this.contexts = new ConcurrentHashMap();
        this.eventDispatcherListener = new SelectionEventDispatcherListener();
        this.reloadEventDispatcherListener = new ReloadEventDispatcherListener();
        this.lockingEventDispatcherListener = new LockingEventDispatcherListener();
        this.userChangedEventDispatcherListener = new UserChangedEventDispatcherListener();
        this.mandatorChangedEventDispatcherListener = new MandatorChangedEventDispatcherListener();
        this.compatibilityEventDispatcherListener = new CompatibilityEventDispatcherListener();
        ElexisEventDispatcher elexisEventDispatcher = ElexisEventDispatcher.getInstance();
        LoggerFactory.getLogger(this.getClass()).info("Attaching to " + elexisEventDispatcher);
        elexisEventDispatcher.addListeners(new ElexisEventListener[]{this.eventDispatcherListener, this.reloadEventDispatcherListener, this.lockingEventDispatcherListener, this.userChangedEventDispatcherListener, this.mandatorChangedEventDispatcherListener, this.compatibilityEventDispatcherListener});
        this.getRootContext().setNamed("ch.elexis.core.services.icontext.stationidentifier", CoreHub.getStationIdentifier());
        this.registerCoreUiSuppliers();
    }

    private void registerCoreUiSuppliers() {
        this.getRootContext().setNamed("SelectFallNoObligationDialog", (Object)new Supplier<ICoverage>(){
            private ICoverage ret;

            @Override
            public synchronized ICoverage get() {
                this.ret = null;
                Optional coverage = ContextServiceHolder.get().getNamed("SelectFallNoObligationDialog.coverage");
                Optional billable = ContextServiceHolder.get().getNamed("SelectFallNoObligationDialog.billable");
                if (coverage.isPresent() && billable.isPresent()) {
                    Display.getDefault().syncExec(() -> {
                        SelectFallNoObligationDialog dlg = new SelectFallNoObligationDialog((ICoverage)coverage.get(), (IBillable)billable.get());
                        if (dlg.open() == 0) {
                            this.ret = dlg.getCoverage();
                        }
                    });
                } else {
                    logger.warn("SelectFallNoObligationDialog missing context parameter [" + coverage + "] [" + billable + "]");
                }
                return this.ret;
            }
        });
    }

    @Deactivate
    public void deactivate() {
        logger.info("DEACTIVATE");
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eventDispatcherListener, this.reloadEventDispatcherListener, this.lockingEventDispatcherListener, this.userChangedEventDispatcherListener, this.mandatorChangedEventDispatcherListener, this.compatibilityEventDispatcherListener});
    }

    public void handleEvent(Event event) {
        Object property = event.getProperty("org.eclipse.e4.data");
        if (property instanceof MApplication) {
            logger.info("APPLICATION STARTUP COMPLETE " + property);
            MApplication application = (MApplication)property;
            this.applicationContext = application.getContext();
            if (this.getRootContext() != null) {
                logger.info("SET APPLICATION CONTEXT " + this.applicationContext);
                ((Context)this.getRootContext()).setEclipseContext(this.applicationContext);
            }
            CoreUiUtil.injectServices(ElexisEventDispatcher.getInstance(), this.applicationContext);
        }
        this.applicationContext.set(IUser.class, (Object)this.getRootContext().getTyped(IUser.class).orElse(null));
    }

    public IContext getRootContext() {
        return this.root;
    }

    public Optional<IContext> getNamedContext(String name) {
        return Optional.ofNullable((IContext)this.contexts.get(name));
    }

    public IContext createNamedContext(String name) {
        Context context = new Context(this.root, name);
        this.contexts.put(name, context);
        return context;
    }

    public void releaseContext(String name) {
        Context context = this.contexts.get(name);
        if (context != null) {
            context.setParent(null);
            this.contexts.remove(name);
        }
    }

    private void postEvent(String topic, Object object, boolean synchronous) {
        if (this.eventAdmin != null) {
            HashMap<String, Object> properites = new HashMap<String, Object>();
            properites.put("org.eclipse.e4.data", object);
            Event event = new Event(topic, properites);
            if (synchronous) {
                this.eventAdmin.sendEvent(event);
            } else {
                this.eventAdmin.postEvent(event);
            }
        } else {
            throw new IllegalStateException("No EventAdmin available");
        }
    }

    public void postEvent(String topic, Object object) {
        this.postEvent(topic, object, false);
    }

    public void sendEvent(String topic, Object object) {
        this.postEvent(topic, object, true);
    }

    private Object getModelObjectForPersistentObject(Object object) {
        if (object instanceof PersistentObject) {
            String storeToString = ((PersistentObject)object).storeToString();
            Optional loaded = StoreToStringServiceHolder.get().loadFromString(storeToString);
            if (loaded.isPresent()) {
                return loaded.get();
            }
        }
        return object;
    }

    private Optional<Class<?>> getCoreModelInterfaceForElexisClass(Class<?> elexisClazz) {
        if (elexisClazz == User.class) {
            return Optional.of(IUser.class);
        }
        if (elexisClazz == Anwender.class) {
            return Optional.of(IContact.class);
        }
        if (elexisClazz == Mandant.class) {
            return Optional.of(IMandator.class);
        }
        if (elexisClazz == Patient.class) {
            return Optional.of(IPatient.class);
        }
        if (elexisClazz == Konsultation.class) {
            return Optional.of(IEncounter.class);
        }
        if (elexisClazz == Fall.class) {
            return Optional.of(ICoverage.class);
        }
        if (elexisClazz == Prescription.class) {
            return Optional.of(IPrescription.class);
        }
        if (elexisClazz == Brief.class) {
            return Optional.of(IDocumentLetter.class);
        }
        return Optional.empty();
    }

    private class CompatibilityEventDispatcherListener
    extends ElexisEventListenerImpl {
        public CompatibilityEventDispatcherListener() {
            super(null, null, 11, 0);
        }

        public void catchElexisEvent(ElexisEvent ev) {
            Object object = ev.getGenericObject();
            if (object == null && (object = ev.getObject()) == null) {
                object = ev.getObjectClass();
            }
            if (ev.getType() == 1) {
                ContextService.this.postEvent("info/elexis/po/compatibility/create", ContextService.this.getModelObjectForPersistentObject(object));
            } else if (ev.getType() == 2) {
                ContextService.this.postEvent("info/elexis/po/compatibility/delete", ContextService.this.getModelObjectForPersistentObject(object));
            } else if (ev.getType() == 8) {
                if (object instanceof Class) {
                    ContextService.this.postEvent("info/elexis/po/compatibility/reload", ContextService.this.getCoreModelInterfaceForElexisClass((Class)object).orElse(null));
                } else {
                    ContextService.this.postEvent("info/elexis/po/compatibility/reload", ContextService.this.getModelObjectForPersistentObject(object));
                }
            }
        }
    }

    private class LockingEventDispatcherListener
    extends ElexisEventListenerImpl {
        public LockingEventDispatcherListener() {
            super(null, null, 28672, 0);
        }

        public void catchElexisEvent(ElexisEvent ev) {
            Object object = ev.getGenericObject();
            if (object == null && (object = ev.getObject()) == null) {
                object = ev.getObjectClass();
            }
            if (ev.getType() == 4096) {
                ContextService.this.postEvent("info/elexis/locking/aquired", ContextService.this.getModelObjectForPersistentObject(object));
            } else if (ev.getType() == 16384) {
                ContextService.this.postEvent("info/elexis/locking/released", ContextService.this.getModelObjectForPersistentObject(object));
            } else if (ev.getType() == 8192) {
                ContextService.this.postEvent("info/elexis/locking/prerelease", ContextService.this.getModelObjectForPersistentObject(object), true);
            }
        }
    }

    private class MandatorChangedEventDispatcherListener
    extends ElexisEventListenerImpl {
        public MandatorChangedEventDispatcherListener() {
            super(null, null, 128, 0);
        }

        public void catchElexisEvent(ElexisEvent ev) {
            Object object = ev.getGenericObject();
            if (object == null && (object = ev.getObject()) == null) {
                object = ev.getObjectClass();
            }
            if (object instanceof Mandant) {
                Optional iMandator = ContextService.this.coreModelService.load(((Mandant)object).getId(), IMandator.class);
                iMandator.ifPresent(m -> ContextService.this.root.setTyped(m));
            }
        }
    }

    private class ReloadEventDispatcherListener
    extends ElexisEventListenerImpl {
        public ReloadEventDispatcherListener() {
            super(null, null, 12, 0);
        }

        public void catchElexisEvent(ElexisEvent ev) {
            Object object = ev.getGenericObject();
            if (object == null && (object = ev.getObject()) == null) {
                object = ev.getObjectClass();
            }
            if (ev.getType() == 8) {
                if (object instanceof Class) {
                    Optional modelClass = ContextService.this.getCoreModelInterfaceForElexisClass((Class)object);
                    if (modelClass.isPresent()) {
                        ContextService.this.postEvent("info/elexis/model/reload", modelClass.get());
                    } else {
                        logger.debug("Could not get model class for [" + object + "] ignored reload event");
                    }
                } else {
                    ContextService.this.postEvent("info/elexis/model/reload", ContextService.this.getModelObjectForPersistentObject(object));
                }
            } else if (ev.getType() == 4) {
                Object modelObject = ContextService.this.getModelObjectForPersistentObject(object);
                if (modelObject instanceof Identifiable) {
                    CoreModelServiceHolder.get().refresh((Identifiable)modelObject, true);
                }
                ContextService.this.postEvent("info/elexis/model/update", modelObject);
            }
        }
    }

    private class SelectionEventDispatcherListener
    extends ElexisEventListenerImpl {
        public SelectionEventDispatcherListener() {
            super(null, null, 48, 0);
        }

        public void catchElexisEvent(ElexisEvent ev) {
            if (ev.getType() == 16) {
                this.addObjectToRoot(this.getElexisEventObject(ev));
            } else if (ev.getType() == 32) {
                this.removeObjectFromRoot(this.getElexisEventObject(ev));
            }
        }

        private Object getElexisEventObject(ElexisEvent ev) {
            Object obj = ev.getObject();
            if (obj == null && (obj = ev.getGenericObject()) == null) {
                obj = ev.getObjectClass();
            }
            return obj;
        }

        private void removeObjectFromRoot(Object object) {
            if (object instanceof Class) {
                ContextService.this.root.removeTyped((Class)object);
                ContextService.this.getCoreModelInterfaceForElexisClass((Class)object).ifPresent(c -> ContextService.this.root.removeTyped((Class<?>)c));
            } else if (object != null) {
                ContextService.this.root.removeTyped(object.getClass());
            }
        }

        private void addObjectToRoot(Object object) {
            ContextService.this.root.setTyped(ContextService.this.getModelObjectForPersistentObject(object));
        }
    }

    private class UserChangedEventDispatcherListener
    extends ElexisEventListenerImpl {
        public UserChangedEventDispatcherListener() {
            super(null, null, 64, 0);
        }

        public void catchElexisEvent(ElexisEvent ev) {
            Object object = ev.getGenericObject();
            if (object == null && (object = ev.getObject()) == null) {
                object = ev.getObjectClass();
            }
            if (object instanceof User) {
                Optional iUser = ContextService.this.coreModelService.load(((User)object).getId(), IUser.class);
                iUser.ifPresent(u -> ContextService.this.root.setTyped(u));
            }
            IUser user = ContextService.this.root.getTyped(IUser.class).orElse(null);
            ContextService.this.postEvent("info/elexis/user/changed", user);
        }
    }
}

