/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Fall;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class SetFallCopyForPatientWithTel
extends ExternalMaintenance {
    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        StringBuilder sb = new StringBuilder();
        Query query = new Query(Fall.class);
        List allFaelle = query.execute();
        sb.append(String.valueOf(allFaelle.size()) + " F\u00e4lle insgesamt.\n");
        pm.beginTask("Set copy to patient...", allFaelle.size());
        boolean setValue = true;
        int changedFaelle = 0;
        for (Fall fall : allFaelle) {
            Patient patient = fall.getPatient();
            if (patient != null && StringUtils.isNotBlank((String)patient.getMailAddress()) && StringUtils.isNotBlank((String)patient.getNatel()) && fall.isOpen() && fall.getTiersType() == Fall.Tiers.PAYANT) {
                if (setValue != fall.getCopyForPatient()) {
                    ++changedFaelle;
                }
                fall.setCopyForPatient(setValue);
            }
            pm.worked(1);
        }
        sb.append("Kopie an Patienten (E-Mail & Mobil vorhanden), in " + changedFaelle + " TP F\u00e4llen angepasst.");
        return sb.toString();
    }

    @Override
    public String getMaintenanceDescription() {
        return "Kopie an Patienten f\u00fcr TP F\u00e4lle (E-Mail & Mobil vorhanden)";
    }
}

