/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.jpa.entities.Brief;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.entities.Rezept;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.jpa.model.adapter.AbstractIdModelAdapter;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.IRecipe;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.IdentifiableWithXid;
import ch.elexis.core.model.service.holder.CoreModelServiceHolder;
import ch.elexis.core.model.util.internal.ModelUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;

public class Recipe
extends AbstractIdDeleteModelAdapter<Rezept>
implements IdentifiableWithXid,
IRecipe {
    public Recipe(Rezept entity) {
        super((EntityWithId)entity);
    }

    public IPatient getPatient() {
        return ModelUtil.getAdapter((EntityWithId)((Rezept)this.getEntity()).getPatient(), IPatient.class);
    }

    public void setPatient(IPatient value) {
        if (value != null) {
            ((Rezept)this.getEntityMarkDirty()).setPatient((Kontakt)((AbstractIdModelAdapter)value).getEntity());
        } else {
            ((Rezept)this.getEntityMarkDirty()).setPatient(null);
        }
    }

    public IMandator getMandator() {
        return ModelUtil.getAdapter((EntityWithId)((Rezept)this.getEntity()).getMandant(), IMandator.class);
    }

    public void setMandator(IMandator value) {
        if (value != null) {
            ((Rezept)this.getEntityMarkDirty()).setMandant((Kontakt)((AbstractIdModelAdapter)value).getEntity());
        } else {
            ((Rezept)this.getEntityMarkDirty()).setMandant(null);
        }
    }

    public LocalDateTime getDate() {
        return ((Rezept)this.getEntity()).getDatum().atStartOfDay();
    }

    public void setDate(LocalDateTime value) {
        ((Rezept)this.getEntityMarkDirty()).setDatum(value.toLocalDate());
    }

    public List<IPrescription> getPrescriptions() {
        CoreModelServiceHolder.get().refresh((Identifiable)this);
        return ((Rezept)this.getEntity()).getPrescriptions().parallelStream().filter(p -> !p.isDeleted()).map(b -> ModelUtil.getAdapter((EntityWithId)b, IPrescription.class, true)).collect(Collectors.toList());
    }

    public void removePrescription(IPrescription prescription) {
        CoreModelServiceHolder.get().delete((Deleteable)prescription);
    }

    public IDocumentLetter getDocument() {
        return ModelUtil.getAdapter((EntityWithId)((Rezept)this.getEntity()).getBrief(), IDocumentLetter.class);
    }

    public void setDocument(IDocumentLetter value) {
        if (value != null) {
            ((Rezept)this.getEntityMarkDirty()).setBrief((Brief)((AbstractIdModelAdapter)value).getEntity());
        } else {
            ((Rezept)this.getEntityMarkDirty()).setBrief(null);
        }
    }

    public String getLabel() {
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        IMandator m = this.getMandator();
        if (m == null) {
            return String.valueOf(dateFormat.format(this.getDate())) + " (unbekannt)";
        }
        return String.valueOf(dateFormat.format(this.getDate())) + " " + m.getLabel();
    }
}

