/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.chromium;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Library;

public class ResourceExpander {
    public static final String USER_HOME;
    public static final String SEPARATOR;
    static final String JAVA_LIB_PATH = "java.library.path";
    static final String SWT_LIB_PATH = "swt.library.path";
    public static final String SWT_LIB_DIR;

    static {
        SEPARATOR = File.separator;
        USER_HOME = System.getProperty("swt.chromium.path", System.getProperty("user.home"));
        SWT_LIB_DIR = ".swt" + SEPARATOR + "lib" + SEPARATOR + ResourceExpander.os() + SEPARATOR + ResourceExpander.arch();
    }

    static String arch() {
        String osArch = System.getProperty("os.arch");
        if (osArch.equals("i386") || osArch.equals("i686")) {
            return "x86";
        }
        if (osArch.equals("amd64")) {
            return "x86_64";
        }
        return osArch;
    }

    static String os() {
        String osName = System.getProperty("os.name");
        if (osName.equals("Linux")) {
            return "linux";
        }
        if (osName.equals("AIX")) {
            return "aix";
        }
        if (osName.equals("Mac OS X")) {
            return "macosx";
        }
        if (osName.startsWith("Win")) {
            return "win32";
        }
        return osName;
    }

    public static File findResource(String subDir, String resourceName, boolean mapResourceName) {
        String maybeSubDirPath = subDir != null ? String.valueOf(subDir) + SEPARATOR : "";
        String maybeSubDirPathWithPrefix = subDir != null ? String.valueOf(SEPARATOR) + maybeSubDirPath : "";
        String finalResourceName = mapResourceName ? System.mapLibraryName(String.valueOf(resourceName) + "-" + SWT.getPlatform()) : resourceName;
        Function<String, File> lookForFileInPath = searchPath -> {
            String classpath = System.getProperty(searchPath);
            if (classpath != null) {
                String[] paths;
                String[] stringArray = paths = classpath.split(File.pathSeparator);
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    File file = new File(String.valueOf(path) + SEPARATOR + maybeSubDirPath + finalResourceName);
                    if (file.exists()) {
                        return file;
                    }
                    ++n2;
                }
            }
            return null;
        };
        File result = null;
        String[] stringArray = new String[]{JAVA_LIB_PATH, SWT_LIB_PATH};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            result = lookForFileInPath.apply(path);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        File file = new File(String.valueOf(USER_HOME) + SEPARATOR + SWT_LIB_DIR + maybeSubDirPathWithPrefix, finalResourceName);
        if (file.exists()) {
            return file;
        }
        File tempDir = new File(USER_HOME, String.valueOf(SWT_LIB_DIR) + maybeSubDirPathWithPrefix);
        if (!tempDir.exists() || tempDir.isDirectory()) {
            tempDir.mkdirs();
        }
        StringBuilder message = new StringBuilder("");
        if (ResourceExpander.extract(file.getPath(), String.valueOf(maybeSubDirPath) + finalResourceName, message) && file.exists()) {
            return file;
        }
        throw new UnsatisfiedLinkError("Could not find resource " + finalResourceName + (subDir != null ? " (in subdirectory: " + subDir + " )" : ""));
    }

    static boolean extract(String extractToFilePath, String mappedName, StringBuilder message) {
        block10: {
            FileOutputStream os = null;
            InputStream is = null;
            File file = new File(extractToFilePath);
            boolean extracted = false;
            try {
                if (!file.exists() && (is = Library.class.getResourceAsStream("/" + mappedName.replace('\\', '/'))) != null) {
                    int read;
                    extracted = true;
                    byte[] buffer = new byte[4096];
                    os = new FileOutputStream(extractToFilePath);
                    while ((read = is.read(buffer)) != -1) {
                        os.write(buffer, 0, read);
                    }
                    os.close();
                    is.close();
                    ResourceExpander.chmod("755", extractToFilePath);
                    return true;
                }
            }
            catch (Throwable e) {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!extracted || !file.exists()) break block10;
                file.delete();
            }
        }
        return false;
    }

    static void chmod(String permision, String path) {
        if (ResourceExpander.os().equals("win32")) {
            return;
        }
        try {
            new File(path).setExecutable(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

