/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.xslt;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.state.EValidity;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.XMLFactory;
import com.phloc.commons.xml.transform.TransformSourceFactory;
import com.phloc.schematron.AbstractSchematronResource;
import com.phloc.schematron.svrl.SVRLReader;
import com.phloc.schematron.xslt.ISchematronXSLTProvider;
import com.phloc.schematron.xslt.ISchematronXSLTValidator;
import com.phloc.schematron.xslt.SchematronXSLTValidatorDefault;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import org.oclc.purl.dsdl.svrl.SchematronOutputType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@NotThreadSafe
public abstract class AbstractSchematronXSLTResource
extends AbstractSchematronResource {
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractSchematronXSLTResource.class);
    private final ErrorListener m_aCustomErrorListener;
    private final URIResolver m_aCustomURIResolver;
    private final ISchematronXSLTProvider m_aXSLTProvider;
    private final ISchematronXSLTValidator m_aValidator;

    public AbstractSchematronXSLTResource(@Nonnull IReadableResource iReadableResource, @Nullable ErrorListener errorListener, @Nullable URIResolver uRIResolver, @Nullable ISchematronXSLTProvider iSchematronXSLTProvider) {
        this(iReadableResource, errorListener, uRIResolver, iSchematronXSLTProvider, new SchematronXSLTValidatorDefault());
    }

    public AbstractSchematronXSLTResource(@Nonnull IReadableResource iReadableResource, @Nullable ErrorListener errorListener, @Nullable URIResolver uRIResolver, @Nullable ISchematronXSLTProvider iSchematronXSLTProvider, @Nonnull ISchematronXSLTValidator iSchematronXSLTValidator) {
        super(iReadableResource);
        ValueEnforcer.notNull((Object)iSchematronXSLTValidator, (String)"Validator");
        this.m_aCustomErrorListener = errorListener;
        this.m_aCustomURIResolver = uRIResolver;
        this.m_aXSLTProvider = iSchematronXSLTProvider;
        this.m_aValidator = iSchematronXSLTValidator;
    }

    @Override
    public final boolean isValidSchematron() {
        return this.m_aXSLTProvider != null && this.m_aXSLTProvider.isValidSchematron();
    }

    @Override
    @Nonnull
    public EValidity getSchematronValidity(@Nonnull IReadableResource iReadableResource) throws Exception {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"XMLResource");
        if (!iReadableResource.exists()) {
            s_aLogger.warn("XML resource " + iReadableResource + " does not exist!");
            return EValidity.INVALID;
        }
        return this.getSchematronValidity((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Override
    @Nonnull
    public EValidity getSchematronValidity(@Nonnull Source source) throws Exception {
        SchematronOutputType schematronOutputType = this.applySchematronValidationToSVRL(source);
        if (schematronOutputType == null) {
            return EValidity.INVALID;
        }
        return this.m_aValidator.getSchematronValidity(schematronOutputType);
    }

    @Override
    @Nullable
    public Document applySchematronValidation(@Nonnull IReadableResource iReadableResource) throws Exception {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"XMLResource");
        if (!iReadableResource.exists()) {
            s_aLogger.warn("XML resource " + iReadableResource + " does not exist!");
            return null;
        }
        return this.applySchematronValidation((Source)TransformSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Override
    @Nullable
    public final Document applySchematronValidation(@Nonnull Source source) throws Exception {
        ValueEnforcer.notNull((Object)source, (String)"XMLSource");
        if (!this.isValidSchematron()) {
            return null;
        }
        Document document = XMLFactory.newDocument();
        Transformer transformer = this.m_aXSLTProvider.getXSLTTemplates().newTransformer();
        if (this.m_aCustomErrorListener != null) {
            transformer.setErrorListener(this.m_aCustomErrorListener);
        }
        if (this.m_aCustomURIResolver != null) {
            transformer.setURIResolver(this.m_aCustomURIResolver);
        }
        transformer.transform(source, new DOMResult(document));
        return document;
    }

    @Override
    @Nullable
    public SchematronOutputType applySchematronValidationToSVRL(@Nonnull IReadableResource iReadableResource) throws Exception {
        Document document = this.applySchematronValidation(iReadableResource);
        return document == null ? null : SVRLReader.readXML(document);
    }

    @Override
    @Nullable
    public SchematronOutputType applySchematronValidationToSVRL(@Nonnull Source source) throws Exception {
        Document document = this.applySchematronValidation(source);
        return document == null ? null : SVRLReader.readXML(document);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("customErrListener", (Object)this.m_aCustomErrorListener).appendIfNotNull("customURIResolver", (Object)this.m_aCustomURIResolver).append("XSLTProvider", (Object)this.m_aXSLTProvider).toString();
    }
}

