/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.bound.xpath;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.pure.bound.xpath.PSXPathBoundElement;
import com.phloc.schematron.pure.model.PSDiagnostic;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PSXPathBoundDiagnostic {
    private final PSDiagnostic m_aDiagnostic;
    private final List<PSXPathBoundElement> m_aBoundContent;

    public PSXPathBoundDiagnostic(@Nonnull PSDiagnostic pSDiagnostic, @Nonnull List<PSXPathBoundElement> list) {
        ValueEnforcer.notNull((Object)pSDiagnostic, (String)"Diagnostic");
        ValueEnforcer.notNull(list, (String)"BoundContent");
        this.m_aDiagnostic = pSDiagnostic;
        this.m_aBoundContent = list;
    }

    @Nonnull
    public PSDiagnostic getDiagnostic() {
        return this.m_aDiagnostic;
    }

    @Nonnull
    public List<PSXPathBoundElement> getAllBoundContentElements() {
        return ContainerHelper.newList(this.m_aBoundContent);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("diagnostic", (Object)this.m_aDiagnostic).append("boundContent", this.m_aBoundContent).toString();
    }
}

