/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.bound.xpath;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.pure.bound.xpath.PSXPathBoundDiagnostic;
import com.phloc.schematron.pure.bound.xpath.PSXPathBoundElement;
import com.phloc.schematron.pure.model.PSAssertReport;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.xpath.XPathExpression;

@Immutable
public class PSXPathBoundAssertReport {
    private final PSAssertReport m_aAssertReport;
    private final String m_sTestExpression;
    private final XPathExpression m_aBoundTestExpression;
    private final List<PSXPathBoundElement> m_aBoundContent;
    private final Map<String, PSXPathBoundDiagnostic> m_aBoundDiagnostics;

    public PSXPathBoundAssertReport(@Nonnull PSAssertReport pSAssertReport, @Nonnull String string, @Nonnull XPathExpression xPathExpression, @Nonnull List<PSXPathBoundElement> list, @Nonnull Map<String, PSXPathBoundDiagnostic> map) {
        ValueEnforcer.notNull((Object)pSAssertReport, (String)"AssertReport");
        ValueEnforcer.notNull((Object)string, (String)"TestExpression");
        ValueEnforcer.notNull((Object)xPathExpression, (String)"BoundTestExpression");
        ValueEnforcer.notNull(list, (String)"BoundContent");
        ValueEnforcer.notNull(map, (String)"BoundDiagnostics");
        this.m_aAssertReport = pSAssertReport;
        this.m_sTestExpression = string;
        this.m_aBoundTestExpression = xPathExpression;
        this.m_aBoundContent = list;
        this.m_aBoundDiagnostics = map;
    }

    @Nonnull
    public PSAssertReport getAssertReport() {
        return this.m_aAssertReport;
    }

    @Nonnull
    public String getTestExpression() {
        return this.m_sTestExpression;
    }

    @Nonnull
    public XPathExpression getBoundTestExpression() {
        return this.m_aBoundTestExpression;
    }

    @Nonnull
    public List<PSXPathBoundElement> getAllBoundContentElements() {
        return ContainerHelper.newList(this.m_aBoundContent);
    }

    @Nullable
    public PSXPathBoundDiagnostic getBoundDiagnosticOfID(@Nullable String string) {
        return this.m_aBoundDiagnostics.get(string);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("assertReport", (Object)this.m_aAssertReport).append("testExpression", (Object)this.m_sTestExpression).append("boundTestExpression", (Object)this.m_aBoundTestExpression).append("boundContent", this.m_aBoundContent).append("boundDiagnostics", this.m_aBoundDiagnostics).toString();
    }
}

