/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.billing;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.builder.IPrescriptionBuilder;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.IBilledAdjuster;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Component;

@Component
public class PrescriptionBilledAdjuster
implements IBilledAdjuster {
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public void adjust(final IBilled billed) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                IBillable billable = billed.getBillable();
                if (billable instanceof IArticle) {
                    IArticle article = (IArticle)billable;
                    Optional patientOpt = PrescriptionBilledAdjuster.this.getPatient(billed);
                    Optional articleStoreToString = StoreToStringServiceHolder.get().storeToString((Identifiable)article);
                    if (patientOpt.isPresent() && articleStoreToString.isPresent()) {
                        IQuery query = CoreModelServiceHolder.get().getQuery(IPrescription.class);
                        query.and((EStructuralFeature)ModelPackage.Literals.IPRESCRIPTION__PATIENT, IQuery.COMPARATOR.EQUALS, patientOpt.get());
                        query.and("artikel", IQuery.COMPARATOR.EQUALS, articleStoreToString.get());
                        query.orderBy((EStructuralFeature)ModelPackage.Literals.IPRESCRIPTION__DATE_FROM, IQuery.ORDER.DESC);
                        List existingPrescriptions = query.execute();
                        boolean dispensationExists = false;
                        if (!existingPrescriptions.isEmpty()) {
                            for (IPrescription prescription : existingPrescriptions) {
                                if (prescription.getEntryType() != EntryType.SELF_DISPENSED) continue;
                                LocalDateTime prescriptionDate = prescription.getDateFrom();
                                LocalDateTime billedDate = PrescriptionBilledAdjuster.this.getBilledDateTime(billed);
                                if (!prescriptionDate.toLocalDate().equals(billedDate.toLocalDate())) continue;
                                dispensationExists = true;
                                break;
                            }
                        }
                        if (!dispensationExists) {
                            PrescriptionBilledAdjuster.this.createDispensationPrescription(article, (IPatient)patientOpt.get(), billed);
                            ContextServiceHolder.get().postEvent("info/elexis/model/reload", IPrescription.class);
                        }
                    }
                }
            }
        });
    }

    private Optional<IPatient> getPatient(IBilled billed) {
        ICoverage coverage;
        IEncounter encounter = billed.getEncounter();
        if (encounter != null && (coverage = encounter.getCoverage()) != null) {
            return Optional.of(coverage.getPatient());
        }
        return Optional.empty();
    }

    private LocalDateTime getBilledDateTime(IBilled billed) {
        IEncounter encounter = billed.getEncounter();
        return encounter.getTimeStamp();
    }

    private IPrescription createDispensationPrescription(IArticle article, IPatient patient, IBilled billed) {
        IPrescription prescription = (IPrescription)new IPrescriptionBuilder(CoreModelServiceHolder.get(), ContextServiceHolder.get(), article, patient, "").build();
        prescription.setExtInfo((Object)"verrechnetId", (Object)billed.getId());
        billed.setExtInfo((Object)"prescriptionId", (Object)prescription.getId());
        prescription.setEntryType(EntryType.SELF_DISPENSED);
        prescription.setDateTo(LocalDateTime.now());
        CoreModelServiceHolder.get().save((Identifiable)prescription);
        return prescription;
    }
}

