/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.internal;

import ch.elexis.core.model.IMessage;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.message.TransientMessage;
import ch.elexis.core.services.IMessageTransporter;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.status.ObjectStatus;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.osgi.service.component.annotations.Component;

@Component
public class InternalDatabaseMessageTransporter
implements IMessageTransporter {
    public IStatus send(TransientMessage message) {
        IMessage idbMessage = (IMessage)CoreModelServiceHolder.get().create(IMessage.class);
        String sender = StringUtils.truncate((String)message.getSender(), (int)25);
        idbMessage.setSender(sender);
        idbMessage.setMessageText(message.getMessageText());
        idbMessage.setMessageCodes(message.getMessageCodes());
        idbMessage.setMessagePriority(message.getMessagePriority());
        idbMessage.setCreateDateTime(message.getCreateDateTime());
        idbMessage.setSenderAcceptsAnswer(message.isSenderAcceptsAnswer());
        boolean save = CoreModelServiceHolder.get().save((Identifiable)idbMessage);
        if (save) {
            return ObjectStatus.OK_STATUS((String)idbMessage.getId(), null);
        }
        return ObjectStatus.ERROR_STATUS((Object)"Could not save message", null);
    }

    public String getUriScheme() {
        return "internaldb";
    }

    public boolean isExternal() {
        return false;
    }
}

