/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IAppointmentSeries;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.Messages;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.agenda.Area;
import ch.elexis.core.model.agenda.AreaType;
import ch.elexis.core.model.agenda.EndingType;
import ch.elexis.core.model.agenda.SeriesType;
import ch.elexis.core.model.builder.IAppointmentBuilder;
import ch.elexis.core.services.IAppointmentService;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.internal.model.AppointmentSeries;
import ch.elexis.core.types.AppointmentState;
import ch.elexis.core.types.AppointmentType;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class AppointmentService
implements IAppointmentService {
    public static final String AG_TERMINTYPEN = "agenda/TerminTypen";
    public static final String AG_TERMINSTATUS = "agenda/TerminStatus";
    public static final String AG_BEREICHE = "agenda/bereiche";
    public static final String AG_BEREICH_PREFIX = "agenda/bereich/";
    public static final String AG_BEREICH_TYPE_POSTFIX = "/type";
    public static final String AG_TIMEPREFERENCES = "agenda/zeitvorgaben";
    private static final int TYPE_FREE = 0;
    private static final int TYPE_RESERVED = 1;
    private static final int TYPE_DEFAULT = 2;
    private static final int STATE_EMPTY = 0;
    private static final int STATE_DEFAULT = 1;
    private List<String> states = null;
    @Reference
    private IConfigService iConfigService;
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService iModelService;

    public IAppointment clone(IAppointment appointment) {
        return (IAppointment)new IAppointmentBuilder(this.iModelService, appointment.getSchedule(), appointment.getStartTime(), appointment.getEndTime(), appointment.getType(), appointment.getState(), appointment.getPriority(), appointment.getSubjectOrPatient()).buildAndSave();
    }

    @Activate
    public void activate() {
        this.states = this.getStates();
    }

    private List<IAppointment> getLinkedAppoinments(IAppointment orig) {
        if (StringTool.isNothing((Object)orig.getLinkgroup())) {
            return Collections.singletonList(orig);
        }
        IQuery query = this.iModelService.getQuery(IAppointment.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IAPPOINTMENT__LINKGROUP, IQuery.COMPARATOR.EQUALS, (Object)orig.getLinkgroup());
        return query.execute();
    }

    public boolean delete(IAppointment appointment, boolean whole) {
        if (!StringTool.isNothing((Object)appointment.getLinkgroup())) {
            List<IAppointment> linked = this.getLinkedAppoinments(appointment);
            if (whole) {
                this.iModelService.delete(linked);
            } else {
                if (appointment.getId().equals(appointment.getLinkgroup()) && linked.size() > 1) {
                    int index = 0;
                    IAppointment moveto = linked.get(index);
                    while (moveto.getId().equals(appointment.getLinkgroup())) {
                        moveto = linked.get(++index);
                    }
                    moveto.setSubjectOrPatient(appointment.getSubjectOrPatient());
                    moveto.setReason(appointment.getReason());
                    moveto.setCreatedBy(appointment.getCreatedBy());
                    moveto.setExtension(appointment.getExtension());
                    this.iModelService.save((Identifiable)moveto);
                    for (IAppointment termin : linked) {
                        termin.setLinkgroup(moveto.getId());
                    }
                    this.iModelService.save(linked);
                }
                this.iModelService.delete((Deleteable)appointment);
            }
        } else {
            this.iModelService.delete((Deleteable)appointment);
        }
        return true;
    }

    public void updateBoundaries(String schedule, LocalDate date) {
        String[] flds;
        int d;
        String ds;
        IQuery query = CoreModelServiceHolder.get().getQuery(IAppointment.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IAPPOINTMENT__SCHEDULE, IQuery.COMPARATOR.EQUALS, (Object)schedule);
        query.and("tag", IQuery.COMPARATOR.EQUALS, (Object)date);
        List resList = query.execute();
        String typReserved = this.getType(AppointmentType.BOOKED);
        String stateEmpty = this.getState(AppointmentState.EMPTY);
        String stateDefault = this.getState(AppointmentState.DEFAULT);
        for (IAppointment termin : resList) {
            if (!termin.getType().equals(typReserved)) continue;
            return;
        }
        Hashtable map = StringTool.foldStrings((String)ConfigServiceHolder.get().get("agenda/tagesvorgaben/" + schedule, null));
        if (map == null) {
            map = new Hashtable();
        }
        if (StringTool.isNothing((Object)(ds = (String)map.get(TimeTool.wdays[(d = new TimeTool(date).get(7)) - 1])))) {
            ds = "0000-0800\n1800-2359";
        }
        String[] stringArray = flds = ds.split("\r*\n\r*");
        int n = flds.length;
        int n2 = 0;
        while (n2 < n) {
            String fld = stringArray[n2];
            String from = fld.substring(0, 4);
            String until = fld.replaceAll("-", "").substring(4);
            IAppointment iAppointment = (IAppointment)CoreModelServiceHolder.get().create(IAppointment.class);
            LocalDateTime startTime = date.atStartOfDay().plusMinutes(TimeTool.getMinutesFromTimeString((String)from));
            LocalDateTime endTime = date.atStartOfDay().plusMinutes(TimeTool.getMinutesFromTimeString((String)until));
            iAppointment.setSchedule(schedule);
            iAppointment.setStartTime(startTime);
            iAppointment.setType(typReserved);
            iAppointment.setState(stateEmpty);
            iAppointment.setEndTime(endTime);
            String ts = Integer.toString(TimeTool.getTimeInSeconds() / 60);
            iAppointment.setCreated(ts);
            iAppointment.setLastEdit(ts);
            iAppointment.setStateHistory(stateDefault);
            CoreModelServiceHolder.get().save((Identifiable)iAppointment);
            ++n2;
        }
    }

    public String getType(AppointmentType type) {
        List<String> types = this.getTypes();
        if (type != null) {
            switch (type) {
                case BOOKED: {
                    return types.get(1);
                }
                case DEFAULT: {
                    return types.get(2);
                }
                case FREE: {
                    return types.get(0);
                }
            }
        }
        return null;
    }

    public String getState(AppointmentState state) {
        if (state != null) {
            switch (state) {
                case DEFAULT: {
                    return this.states.get(1);
                }
                case EMPTY: {
                    return this.states.get(0);
                }
            }
        }
        return null;
    }

    public void addType(String type) {
        String tt = String.valueOf(StringTool.join(this.getTypes(), (String)",")) + "," + type;
        this.iConfigService.set(AG_TERMINTYPEN, tt);
    }

    public void addState(String state) {
        String tt = String.valueOf(StringTool.join(this.states, (String)",")) + "," + state;
        this.iConfigService.set(AG_TERMINSTATUS, tt);
        this.states = this.iConfigService.getAsList(AG_TERMINSTATUS, null);
    }

    public List<Area> getAreas() {
        ArrayList<Area> ret = new ArrayList<Area>();
        List areas = this.iConfigService.getAsList(AG_BEREICHE);
        areas.forEach(entry -> {
            String typeString = this.iConfigService.get(AG_BEREICH_PREFIX + entry + AG_BEREICH_TYPE_POSTFIX, null);
            AreaType type = AreaType.GENERIC;
            String contactId = null;
            if (typeString != null) {
                type = AreaType.CONTACT;
                contactId = typeString.substring(AreaType.CONTACT.name().length() + 1);
            }
            ret.add(new Area(entry, type, contactId));
        });
        return ret;
    }

    public List<String> getTypes() {
        List<String> ret = new ArrayList<String>(this.iConfigService.getAsList(AG_TERMINTYPEN, Collections.emptyList()));
        if (ret.isEmpty() || ret.size() < 3) {
            ret = Arrays.asList(Messages.Appointment_Range_Free, Messages.Appointment_Range_Locked, Messages.Appointment_Normal_Appointment);
            this.iConfigService.setFromList(AG_TERMINTYPEN, ret);
        }
        return ret;
    }

    public List<String> getStates() {
        List<String> ret = this.iConfigService.getAsList(AG_TERMINSTATUS, null);
        if (ret == null || ret.size() < 2) {
            ret = Arrays.asList("-", Messages.Appointment_Planned_Appointment);
        }
        return ret;
    }

    public Optional<IAppointmentSeries> getAppointmentSeries(IAppointment appointment) {
        if (appointment != null && appointment.isRecurring()) {
            return Optional.of(new AppointmentSeries(appointment));
        }
        return Optional.empty();
    }

    public IAppointmentSeries createAppointmentSeries() {
        IAppointment appointment = (IAppointment)CoreModelServiceHolder.get().create(IAppointment.class);
        appointment.setSchedule(this.getAreas().get(0).getName());
        ContextServiceHolder.get().getActiveUser().ifPresent(au -> appointment.setCreatedBy(au.getLabel()));
        LocalDate monday = LocalDate.now().with(DayOfWeek.MONDAY);
        appointment.setStartTime(LocalDateTime.of(monday, LocalTime.of(8, 0, 0)));
        appointment.setEndTime(LocalDateTime.of(monday, LocalTime.of(8, 30, 0)));
        appointment.setLinkgroup(appointment.getId());
        AppointmentSeries ret = new AppointmentSeries(appointment);
        ret.setSeriesStartDate(appointment.getStartTime().toLocalDate());
        ret.setSeriesStartTime(appointment.getStartTime().toLocalTime());
        ret.setSeriesType(SeriesType.WEEKLY);
        ret.setSeriesPatternString("1,2");
        ret.setEndingType(EndingType.ON_SPECIFIC_DATE);
        ret.setSeriesEndDate(appointment.getStartTime().plusDays(7L).toLocalDate());
        ret.setSeriesEndTime(appointment.getEndTime().toLocalTime());
        Optional patient = ContextServiceHolder.get().getActivePatient();
        appointment.setSubjectOrPatient(patient.isPresent() ? ((IPatient)patient.get()).getId() : "");
        return ret;
    }

    public List<IAppointment> saveAppointmentSeries(IAppointmentSeries appointmentSeries) {
        ArrayList<IAppointment> series = new ArrayList<IAppointment>();
        IAppointment root = appointmentSeries.getRootAppointment();
        root.setType("series");
        LocalDate rootStartDate = this.getRootTerminStartTime(appointmentSeries).toLocalDate();
        appointmentSeries.setSeriesStartDate(rootStartDate);
        root.setStartTime(LocalDateTime.of(appointmentSeries.getSeriesStartDate(), appointmentSeries.getSeriesStartTime()));
        root.setEndTime(LocalDateTime.of(appointmentSeries.getSeriesStartDate(), appointmentSeries.getSeriesEndTime()));
        root.setExtension(appointmentSeries.getAsSeriesExtension());
        series.add(root);
        series.addAll(this.createSubSequentDates(appointmentSeries));
        CoreModelServiceHolder.get().save(series);
        return series;
    }

    private TimeTool getRootTerminStartTime(IAppointmentSeries appointmentSeries) {
        LocalDateTime startdatetime = LocalDateTime.of(appointmentSeries.getSeriesStartDate(), appointmentSeries.getSeriesStartTime());
        GregorianCalendar cal = GregorianCalendar.from(startdatetime.atZone(ZoneId.systemDefault()));
        TimeTool tt = new TimeTool(cal.getTime());
        switch (appointmentSeries.getSeriesType()) {
            case DAILY: {
                return tt;
            }
            case WEEKLY: {
                Calendar cal2 = Calendar.getInstance();
                cal2.setTime(cal.getTime());
                int firstDay = Integer.parseInt(String.valueOf(appointmentSeries.getSeriesPatternString().split(",")[1].charAt(0)));
                cal2.set(7, firstDay);
                TimeTool ret = new TimeTool(cal2.getTime());
                return ret;
            }
            case MONTHLY: {
                int monthDay = Integer.parseInt(appointmentSeries.getSeriesPatternString());
                Calendar calendarMonth = Calendar.getInstance();
                calendarMonth.clear();
                calendarMonth.set(1, tt.get(1));
                if (tt.get(5) <= monthDay) {
                    calendarMonth.set(2, tt.get(2));
                } else {
                    calendarMonth.set(2, tt.get(2));
                    calendarMonth.add(2, 1);
                }
                calendarMonth.set(5, monthDay);
                return new TimeTool(calendarMonth.getTime());
            }
            case YEARLY: {
                Calendar targetCal = Calendar.getInstance();
                targetCal.clear();
                targetCal.set(1, tt.get(1));
                int day = Integer.parseInt(appointmentSeries.getSeriesPatternString().substring(0, 2));
                int month = Integer.parseInt(appointmentSeries.getSeriesPatternString().substring(2, 4));
                targetCal.set(5, day);
                targetCal.set(2, month - 1);
                TimeTool target = new TimeTool(targetCal.getTime());
                if (tt.isBefore(target)) {
                    return target;
                }
                target.add(1, 1);
                return target;
            }
        }
        return tt;
    }

    private List<IAppointment> createSubSequentDates(IAppointmentSeries appointmentSeries) {
        ArrayList<IAppointment> ret = new ArrayList<IAppointment>();
        TimeTool dateIncrementer = new TimeTool(LocalDateTime.of(appointmentSeries.getSeriesStartDate(), appointmentSeries.getSeriesStartTime()));
        int occurences = 0;
        TimeTool endingDate = null;
        if (appointmentSeries.getEndingType().equals((Object)EndingType.AFTER_N_OCCURENCES)) {
            occurences = Integer.parseInt(appointmentSeries.getEndingPatternString()) - 1;
        } else {
            endingDate = new TimeTool(appointmentSeries.getSeriesEndDate());
        }
        switch (appointmentSeries.getSeriesType()) {
            case DAILY: {
                if (appointmentSeries.getEndingType().equals((Object)EndingType.ON_SPECIFIC_DATE)) {
                    occurences = dateIncrementer.daysTo(endingDate) + 1;
                }
                int i = 0;
                while (i < occurences) {
                    dateIncrementer.add(6, 1);
                    ret.add(this.writeSubsequentDateEntry(appointmentSeries, dateIncrementer));
                    ++i;
                }
                break;
            }
            case WEEKLY: {
                String[] separatedSeriesPattern = appointmentSeries.getSeriesPatternString().split(",");
                int weekStepSize = Integer.parseInt(separatedSeriesPattern[0]);
                int i = 1;
                while (i < separatedSeriesPattern[1].length()) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(dateIncrementer.getTime());
                    int dayValue = Integer.parseInt(String.valueOf(separatedSeriesPattern[1].charAt(i)));
                    cal.set(7, dayValue);
                    ret.add(this.writeSubsequentDateEntry(appointmentSeries, new TimeTool(cal.getTime())));
                    ++i;
                }
                if (appointmentSeries.getEndingType().equals((Object)EndingType.ON_SPECIFIC_DATE)) {
                    long milisecondsDiff = 0L;
                    if (endingDate != null) {
                        milisecondsDiff = endingDate.getTime().getTime() - dateIncrementer.getTime().getTime();
                    }
                    int days = (int)(milisecondsDiff / 86400000L);
                    int weeks = days / 7;
                    occurences = weeks / weekStepSize;
                }
                i = 0;
                while (i < occurences) {
                    dateIncrementer.add(3, weekStepSize);
                    int j = 0;
                    while (j < separatedSeriesPattern[1].length()) {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(dateIncrementer.getTime());
                        int dayValue = Integer.parseInt(String.valueOf(separatedSeriesPattern[1].charAt(j)));
                        cal.set(7, dayValue);
                        ret.add(this.writeSubsequentDateEntry(appointmentSeries, new TimeTool(cal.getTime())));
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case MONTHLY: {
                if (appointmentSeries.getEndingType().equals((Object)EndingType.ON_SPECIFIC_DATE) && endingDate != null) {
                    occurences = (endingDate.get(1) - dateIncrementer.get(1)) * 12 + (endingDate.get(2) - dateIncrementer.get(2)) + (endingDate.get(5) >= dateIncrementer.get(5) ? 0 : -1);
                }
                int i = 0;
                while (i < occurences) {
                    dateIncrementer.add(2, 1);
                    ret.add(this.writeSubsequentDateEntry(appointmentSeries, dateIncrementer));
                    ++i;
                }
                break;
            }
            case YEARLY: {
                if (appointmentSeries.getEndingType().equals((Object)EndingType.ON_SPECIFIC_DATE) && endingDate != null) {
                    int monthOccurences = (endingDate.get(1) - dateIncrementer.get(1)) * 12 + (endingDate.get(2) - dateIncrementer.get(2)) + (endingDate.get(5) >= dateIncrementer.get(5) ? 0 : -1);
                    occurences = monthOccurences / 12;
                }
                int i = 0;
                while (i < occurences) {
                    dateIncrementer.add(1, 1);
                    ret.add(this.writeSubsequentDateEntry(appointmentSeries, dateIncrementer));
                    ++i;
                }
                break;
            }
        }
        return ret;
    }

    private IAppointment writeSubsequentDateEntry(IAppointmentSeries appointmentSeries, TimeTool dateIncrementer) {
        IAppointment ret = (IAppointment)CoreModelServiceHolder.get().create(IAppointment.class);
        ret.setStartTime(dateIncrementer.toLocalDateTime());
        ret.setEndTime(LocalDateTime.of(ret.getStartTime().toLocalDate(), appointmentSeries.getSeriesEndTime()));
        ret.setType("series");
        ret.setReason(appointmentSeries.getReason());
        if (appointmentSeries.getContact() != null) {
            ret.setSubjectOrPatient(appointmentSeries.getContact().getId());
        } else {
            ret.setSubjectOrPatient(appointmentSeries.getSubjectOrPatient());
        }
        ret.setSchedule(appointmentSeries.getSchedule());
        ret.setState(appointmentSeries.getState());
        ret.setCreatedBy(appointmentSeries.getCreatedBy());
        ret.setTreatmentReason(appointmentSeries.getTreatmentReason());
        ret.setLinkgroup(appointmentSeries.getRootAppointment().getId());
        return ret;
    }

    public void deleteAppointmentSeries(IAppointmentSeries appointmentSeries) {
        if (appointmentSeries != null && appointmentSeries.isPersistent()) {
            IQuery query = CoreModelServiceHolder.get().getQuery(IAppointment.class);
            query.and("linkgroup", IQuery.COMPARATOR.EQUALS, (Object)appointmentSeries.getRootAppointment().getId());
            List appointments = query.execute();
            CoreModelServiceHolder.get().delete(appointments);
        }
    }

    public Map<String, Integer> getPreferredDurations(String areaName) {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        if (StringUtils.isNotBlank((CharSequence)areaName)) {
            String mTimes = this.iConfigService.get("agenda/zeitvorgaben/" + areaName, "");
            if (StringUtils.isNotBlank((CharSequence)mTimes)) {
                String[] types;
                String[] stringArray = types = mTimes.split("::");
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    String t = stringArray[n2];
                    String[] line = t.split("=");
                    if (line.length != 2) {
                        LoggerFactory.getLogger(this.getClass()).warn("Error in preferred duration preference [" + mTimes + "]");
                    } else {
                        try {
                            Integer duration = Integer.parseInt(line[1].trim());
                            ret.put(line[0], duration);
                        }
                        catch (NumberFormatException e) {
                            LoggerFactory.getLogger(this.getClass()).warn("Duration not numeric in preference [" + mTimes + "]");
                        }
                    }
                    ++n2;
                }
            }
            if (ret.get("std") == null) {
                ret.put("std", 30);
            }
        }
        return ret;
    }
}

