/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.tasks.internal.service.fs;

import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.tasks.internal.service.TaskServiceImpl;
import ch.elexis.core.tasks.model.ITaskDescriptor;
import ch.elexis.core.tasks.model.TaskTriggerType;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchServiceHolder {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TaskServiceImpl taskService;
    private final WatchService watchService;
    private WatchServicePoller pollerThread;
    private Map<WatchKey, ITaskDescriptor> incurredTasks;

    public WatchServiceHolder(TaskServiceImpl taskServiceImpl) {
        WatchService initWatchService;
        this.taskService = taskServiceImpl;
        this.incurredTasks = Collections.synchronizedMap(new HashMap());
        try {
            initWatchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException ioe) {
            initWatchService = null;
            this.logger.error("Error instantiating WatchService, filesystem events will not be picked up.", (Throwable)ioe);
        }
        this.watchService = initWatchService;
        this.pollerThread = new WatchServicePoller();
    }

    public boolean triggerIsAvailable() {
        return this.watchService != null && this.pollerThread != null;
    }

    public void startPolling() {
        this.pollerThread.start();
    }

    public void stopPolling() {
    }

    public void incur(ITaskDescriptor taskDescriptor) throws TaskException {
        if (this.watchService != null) {
            String pathParameter = taskDescriptor.getTriggerParameters().get("url");
            if (pathParameter != null && pathParameter.length() > 0) {
                try {
                    Path path = Paths.get(pathParameter, new String[0]);
                    if (!path.toFile().isDirectory() || !path.toFile().canRead()) {
                        throw new TaskException(7, new Throwable("path is not a directory or not readable"));
                    }
                    WatchEvent.Kind[] events = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE};
                    WatchKey watchKey = path.register(this.watchService, events);
                    this.logger.debug("Watching [{}]", (Object)pathParameter);
                    this.incurredTasks.put(watchKey, taskDescriptor);
                }
                catch (IOException | InvalidPathException e) {
                    throw new TaskException(7, (Throwable)e);
                }
            }
        } else {
            throw new TaskException(8, new Throwable());
        }
    }

    public void release(ITaskDescriptor taskDescriptor) {
    }

    private class WatchServicePoller
    extends Thread {
        private WatchServicePoller() {
        }

        @Override
        public void run() {
            WatchServiceHolder.this.logger.debug("Start polling");
            WatchKey key = null;
            while (true) {
                try {
                    while (true) {
                        if ((key = WatchServiceHolder.this.watchService.poll(250L, TimeUnit.MILLISECONDS)) == null) {
                            continue;
                        }
                        ITaskDescriptor taskDescriptor = (ITaskDescriptor)WatchServiceHolder.this.incurredTasks.get(key);
                        List<WatchEvent<?>> pollEvents = key.pollEvents();
                        for (WatchEvent<?> watchEvent : pollEvents) {
                            if (taskDescriptor != null) {
                                String watcherPath = taskDescriptor.getTriggerParameters().get("url");
                                Path name = (Path)watchEvent.context();
                                String fullPath = Paths.get(watcherPath, name.toString()).toString();
                                WatchServiceHolder.this.logger.debug("{} -> {}", watchEvent.kind(), (Object)fullPath);
                                HashMap<String, String> runContext = new HashMap<String, String>();
                                runContext.put("url", fullPath);
                                this.trigger(taskDescriptor, runContext);
                                continue;
                            }
                            WatchServiceHolder.this.logger.error("No taskDescriptor registered for the provided watchKey [{}], removing key", (Object)key);
                            WatchServiceHolder.this.incurredTasks.remove(key);
                        }
                        key.reset();
                    }
                }
                catch (InterruptedException e) {
                    WatchServiceHolder.this.logger.error("Interrupted", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        private void trigger(ITaskDescriptor taskDescriptor, Map<String, String> runContext) {
            try {
                WatchServiceHolder.this.logger.debug("Triggering {}", (Object)taskDescriptor);
                WatchServiceHolder.this.taskService.trigger(taskDescriptor, null, TaskTriggerType.FILESYSTEM_CHANGE, runContext);
            }
            catch (TaskException e) {
                WatchServiceHolder.this.logger.warn("Could not trigger task [" + taskDescriptor.getId() + "]", (Throwable)e);
            }
        }
    }
}

