/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CQ;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class BLC
extends AbstractSegment {
    public BLC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Blood Product Code");
            this.add(CQ.class, false, 1, 267, new Object[]{this.getMessage()}, "Blood Amount");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating BLC - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CWE getBloodProductCode() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getBlc1_BloodProductCode() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CQ getBloodAmount() {
        CQ retVal = (CQ)this.getTypedField(2, 0);
        return retVal;
    }

    public CQ getBlc2_BloodAmount() {
        CQ retVal = (CQ)this.getTypedField(2, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new CQ(this.getMessage());
            }
        }
        return null;
    }
}

