/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.group.EAN_U09_NOTIFICATION;
import ca.uhn.hl7v2.model.v26.segment.EQU;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.ROL;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EAN_U09
extends AbstractMessage {
    public EAN_U09() {
        this(new DefaultModelClassFactory());
    }

    public EAN_U09(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(EQU.class, true, false);
            this.add(EAN_U09_NOTIFICATION.class, true, true);
            this.add(ROL.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EAN_U09 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public EQU getEQU() {
        return this.getTyped("EQU", EQU.class);
    }

    public EAN_U09_NOTIFICATION getNOTIFICATION() {
        return this.getTyped("NOTIFICATION", EAN_U09_NOTIFICATION.class);
    }

    public EAN_U09_NOTIFICATION getNOTIFICATION(int rep) {
        return this.getTyped("NOTIFICATION", rep, EAN_U09_NOTIFICATION.class);
    }

    public int getNOTIFICATIONReps() {
        return this.getReps("NOTIFICATION");
    }

    public List<EAN_U09_NOTIFICATION> getNOTIFICATIONAll() throws HL7Exception {
        return this.getAllAsList("NOTIFICATION", EAN_U09_NOTIFICATION.class);
    }

    public void insertNOTIFICATION(EAN_U09_NOTIFICATION structure, int rep) throws HL7Exception {
        super.insertRepetition("NOTIFICATION", structure, rep);
    }

    public EAN_U09_NOTIFICATION insertNOTIFICATION(int rep) throws HL7Exception {
        return (EAN_U09_NOTIFICATION)super.insertRepetition("NOTIFICATION", rep);
    }

    public EAN_U09_NOTIFICATION removeNOTIFICATION(int rep) throws HL7Exception {
        return (EAN_U09_NOTIFICATION)super.removeRepetition("NOTIFICATION", rep);
    }

    public ROL getROL() {
        return this.getTyped("ROL", ROL.class);
    }
}

