/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.DT;
import ca.uhn.hl7v2.model.v251.datatype.EI;

public class PIP
extends AbstractComposite {
    private Type[] data;

    public PIP(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[5];
        this.data[0] = new CE(this.getMessage());
        this.data[1] = new CE(this.getMessage());
        this.data[2] = new DT(this.getMessage());
        this.data[3] = new DT(this.getMessage());
        this.data[4] = new EI(this.getMessage());
    }

    @Override
    public Type[] getComponents() {
        return this.data;
    }

    @Override
    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public CE getPrivilege() {
        return this.getTyped(0, CE.class);
    }

    public CE getPip1_Privilege() {
        return this.getTyped(0, CE.class);
    }

    public CE getPrivilegeClass() {
        return this.getTyped(1, CE.class);
    }

    public CE getPip2_PrivilegeClass() {
        return this.getTyped(1, CE.class);
    }

    public DT getExpirationDate() {
        return this.getTyped(2, DT.class);
    }

    public DT getPip3_ExpirationDate() {
        return this.getTyped(2, DT.class);
    }

    public DT getActivationDate() {
        return this.getTyped(3, DT.class);
    }

    public DT getPip4_ActivationDate() {
        return this.getTyped(3, DT.class);
    }

    public EI getFacility() {
        return this.getTyped(4, EI.class);
    }

    public EI getPip5_Facility() {
        return this.getTyped(4, EI.class);
    }
}

