/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v23.group.ADT_A39_PATIENT;
import ca.uhn.hl7v2.model.v23.segment.EVN;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ADT_A39
extends AbstractMessage {
    public ADT_A39() {
        this(new DefaultModelClassFactory());
    }

    public ADT_A39(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EVN.class, true, false);
            this.add(ADT_A39_PATIENT.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ADT_A39 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public EVN getEVN() {
        return this.getTyped("EVN", EVN.class);
    }

    public ADT_A39_PATIENT getPATIENT() {
        return this.getTyped("PATIENT", ADT_A39_PATIENT.class);
    }

    public ADT_A39_PATIENT getPATIENT(int rep) {
        return this.getTyped("PATIENT", rep, ADT_A39_PATIENT.class);
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<ADT_A39_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", ADT_A39_PATIENT.class);
    }

    public void insertPATIENT(ADT_A39_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", structure, rep);
    }

    public ADT_A39_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (ADT_A39_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public ADT_A39_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (ADT_A39_PATIENT)super.removeRepetition("PATIENT", rep);
    }
}

