/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.entities;

import ch.elexis.core.jpa.entities.AbstractEntityWithId;
import ch.elexis.core.jpa.entities.EntityWithDeleted;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.TaskDescriptor;
import ch.elexis.core.jpa.entities.converter.BooleanCharacterConverterSafe;
import ch.elexis.core.jpa.entities.converter.TimeMillisConverter;
import ch.elexis.core.jpa.entities.id.ElexisIdGenerator;
import ch.elexis.core.jpa.entities.listener.EntityWithIdListener;
import java.time.LocalDateTime;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@EntityListeners(value={EntityWithIdListener.class})
@Table(name="TASK")
@Cache(expiry=15000)
public class Task
extends AbstractEntityWithId
implements EntityWithId,
EntityWithDeleted,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    protected Long lastupdate;
    @Id
    @GeneratedValue(generator="system-uuid")
    @Column(unique=true, nullable=false, length=32)
    private String id;
    @Column
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean deleted;
    @Column
    protected int state;
    @Column
    protected int triggerEvent;
    @Column
    protected Long createdAt;
    @Column
    protected Long runAt;
    @Column
    protected Long finishedAt;
    @JoinColumn(name="descriptor")
    @ManyToOne(cascade={CascadeType.REFRESH})
    protected TaskDescriptor taskDescriptor;
    @Column
    @Basic(fetch=FetchType.LAZY)
    @Lob
    protected String runContext;
    @Column
    @Basic(fetch=FetchType.LAZY)
    @Lob
    protected String result;
    @Column(length=64)
    protected String runner;
    @Column(name="is_system")
    @Convert(converter=BooleanCharacterConverterSafe.class)
    protected boolean system;
    static final long serialVersionUID = 4424711543885269451L;

    public Task() {
        this.id = ElexisIdGenerator.generateId();
        this.deleted = false;
        this.state = 0;
        this.triggerEvent = 0;
        this.system = false;
    }

    @Override
    public String getId() {
        return this._persistence_get_id();
    }

    @Override
    public void setId(String id) {
        this._persistence_set_id(id);
    }

    @Override
    public boolean isDeleted() {
        return this._persistence_get_deleted();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this._persistence_set_deleted(deleted);
    }

    @Override
    public Long getLastupdate() {
        return this._persistence_get_lastupdate();
    }

    @Override
    public void setLastupdate(Long lastupdate) {
        this._persistence_set_lastupdate(lastupdate);
    }

    public void setState(int state) {
        this._persistence_set_state(state);
    }

    public int getState() {
        return this._persistence_get_state();
    }

    public boolean isSystem() {
        return this._persistence_get_system();
    }

    public void setSystem(boolean system) {
        this._persistence_set_system(system);
    }

    public int getTriggerEvent() {
        return this._persistence_get_triggerEvent();
    }

    public void setTriggerEvent(int triggerEvent) {
        this._persistence_set_triggerEvent(triggerEvent);
    }

    public TaskDescriptor getTaskDescriptor() {
        return this._persistence_get_taskDescriptor();
    }

    public void setTaskDescriptor(TaskDescriptor taskDescriptor) {
        this._persistence_set_taskDescriptor(taskDescriptor);
    }

    public String getRunContext() {
        return this._persistence_get_runContext();
    }

    public void setRunContext(String runContext) {
        this._persistence_set_runContext(runContext);
    }

    public String getResult() {
        return this._persistence_get_result();
    }

    public void setResult(String result) {
        this._persistence_set_result(result);
    }

    public String getRunner() {
        return this._persistence_get_runner();
    }

    public void setRunner(String runner) {
        this._persistence_set_runner(runner);
    }

    public Long getCreatedAt() {
        return this._persistence_get_createdAt();
    }

    public void setCreatedAt(Long createdAt) {
        this._persistence_set_createdAt(createdAt);
    }

    @Transient
    public LocalDateTime getCreatedAtLocalDateTime() {
        return TimeMillisConverter.convertOptionalMillisToLocalDateTime(this.getCreatedAt());
    }

    public Long getRunAt() {
        return this._persistence_get_runAt();
    }

    public void setRunAt(Long runAt) {
        this._persistence_set_runAt(runAt);
    }

    @Transient
    public LocalDateTime getRunAtLocalDateTime() {
        return TimeMillisConverter.convertOptionalMillisToLocalDateTime(this.getRunAt());
    }

    public Long getFinishedAt() {
        return this._persistence_get_finishedAt();
    }

    @Transient
    public LocalDateTime getFinishedAtLocalDateTime() {
        return TimeMillisConverter.convertOptionalMillisToLocalDateTime(this.getFinishedAt());
    }

    public void setFinishedAt(Long finishedAt) {
        this._persistence_set_finishedAt(finishedAt);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Task(persistenceObject);
    }

    public Task(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "runAt") {
            return this.runAt;
        }
        if (string == "runContext") {
            return this.runContext;
        }
        if (string == "taskDescriptor") {
            return this.taskDescriptor;
        }
        if (string == "finishedAt") {
            return this.finishedAt;
        }
        if (string == "result") {
            return this.result;
        }
        if (string == "createdAt") {
            return this.createdAt;
        }
        if (string == "deleted") {
            return this.deleted;
        }
        if (string == "system") {
            return this.system;
        }
        if (string == "triggerEvent") {
            return this.triggerEvent;
        }
        if (string == "lastupdate") {
            return this.lastupdate;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "state") {
            return this.state;
        }
        if (string == "runner") {
            return this.runner;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "runAt") {
            this.runAt = (Long)object;
            return;
        }
        if (string == "runContext") {
            this.runContext = (String)object;
            return;
        }
        if (string == "taskDescriptor") {
            this.taskDescriptor = (TaskDescriptor)object;
            return;
        }
        if (string == "finishedAt") {
            this.finishedAt = (Long)object;
            return;
        }
        if (string == "result") {
            this.result = (String)object;
            return;
        }
        if (string == "createdAt") {
            this.createdAt = (Long)object;
            return;
        }
        if (string == "deleted") {
            this.deleted = (Boolean)object;
            return;
        }
        if (string == "system") {
            this.system = (Boolean)object;
            return;
        }
        if (string == "triggerEvent") {
            this.triggerEvent = (Integer)object;
            return;
        }
        if (string == "lastupdate") {
            this.lastupdate = (Long)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "state") {
            this.state = (Integer)object;
            return;
        }
        if (string == "runner") {
            this.runner = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Long _persistence_get_runAt() {
        this._persistence_checkFetched("runAt");
        return this.runAt;
    }

    public void _persistence_set_runAt(Long l) {
        this._persistence_checkFetchedForSet("runAt");
        this._persistence_propertyChange("runAt", this.runAt, l);
        this.runAt = l;
    }

    public String _persistence_get_runContext() {
        this._persistence_checkFetched("runContext");
        return this.runContext;
    }

    public void _persistence_set_runContext(String string) {
        this._persistence_checkFetchedForSet("runContext");
        this._persistence_propertyChange("runContext", this.runContext, string);
        this.runContext = string;
    }

    public TaskDescriptor _persistence_get_taskDescriptor() {
        this._persistence_checkFetched("taskDescriptor");
        return this.taskDescriptor;
    }

    public void _persistence_set_taskDescriptor(TaskDescriptor taskDescriptor) {
        this._persistence_checkFetchedForSet("taskDescriptor");
        this._persistence_propertyChange("taskDescriptor", this.taskDescriptor, taskDescriptor);
        this.taskDescriptor = taskDescriptor;
    }

    public Long _persistence_get_finishedAt() {
        this._persistence_checkFetched("finishedAt");
        return this.finishedAt;
    }

    public void _persistence_set_finishedAt(Long l) {
        this._persistence_checkFetchedForSet("finishedAt");
        this._persistence_propertyChange("finishedAt", this.finishedAt, l);
        this.finishedAt = l;
    }

    public String _persistence_get_result() {
        this._persistence_checkFetched("result");
        return this.result;
    }

    public void _persistence_set_result(String string) {
        this._persistence_checkFetchedForSet("result");
        this._persistence_propertyChange("result", this.result, string);
        this.result = string;
    }

    public Long _persistence_get_createdAt() {
        this._persistence_checkFetched("createdAt");
        return this.createdAt;
    }

    public void _persistence_set_createdAt(Long l) {
        this._persistence_checkFetchedForSet("createdAt");
        this._persistence_propertyChange("createdAt", this.createdAt, l);
        this.createdAt = l;
    }

    public boolean _persistence_get_deleted() {
        this._persistence_checkFetched("deleted");
        return this.deleted;
    }

    public void _persistence_set_deleted(boolean bl) {
        this._persistence_checkFetchedForSet("deleted");
        this._persistence_propertyChange("deleted", new Boolean(this.deleted), new Boolean(bl));
        this.deleted = bl;
    }

    public boolean _persistence_get_system() {
        this._persistence_checkFetched("system");
        return this.system;
    }

    public void _persistence_set_system(boolean bl) {
        this._persistence_checkFetchedForSet("system");
        this._persistence_propertyChange("system", new Boolean(this.system), new Boolean(bl));
        this.system = bl;
    }

    public int _persistence_get_triggerEvent() {
        this._persistence_checkFetched("triggerEvent");
        return this.triggerEvent;
    }

    public void _persistence_set_triggerEvent(int n) {
        this._persistence_checkFetchedForSet("triggerEvent");
        this._persistence_propertyChange("triggerEvent", new Integer(this.triggerEvent), new Integer(n));
        this.triggerEvent = n;
    }

    public Long _persistence_get_lastupdate() {
        this._persistence_checkFetched("lastupdate");
        return this.lastupdate;
    }

    public void _persistence_set_lastupdate(Long l) {
        this._persistence_checkFetchedForSet("lastupdate");
        this._persistence_propertyChange("lastupdate", this.lastupdate, l);
        this.lastupdate = l;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public int _persistence_get_state() {
        this._persistence_checkFetched("state");
        return this.state;
    }

    public void _persistence_set_state(int n) {
        this._persistence_checkFetchedForSet("state");
        this._persistence_propertyChange("state", new Integer(this.state), new Integer(n));
        this.state = n;
    }

    public String _persistence_get_runner() {
        this._persistence_checkFetched("runner");
        return this.runner;
    }

    public void _persistence_set_runner(String string) {
        this._persistence_checkFetchedForSet("runner");
        this._persistence_propertyChange("runner", this.runner, string);
        this.runner = string;
    }
}

