/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.accessor;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.findings.util.fhir.accessor.AbstractFindingsAccessor;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.DocumentReference;
import org.hl7.fhir.dstu3.model.DomainResource;

public class DocumentReferenceAccessor
extends AbstractFindingsAccessor {
    public List<ICoding> getPracticeSetting(DomainResource resource) {
        CodeableConcept codeableConcept;
        DocumentReference fhirResource = (DocumentReference)resource;
        DocumentReference.DocumentReferenceContextComponent fhirContext = fhirResource.getContext();
        if (fhirContext != null && (codeableConcept = fhirContext.getPracticeSetting()) != null) {
            return ModelUtil.getCodingsFromConcept(codeableConcept);
        }
        return Collections.emptyList();
    }

    public void setPracticeSetting(DomainResource resource, ICoding coding) {
        DocumentReference fhirResource = (DocumentReference)resource;
        DocumentReference.DocumentReferenceContextComponent fhirContext = fhirResource.getContext();
        if (fhirContext != null) {
            CodeableConcept codeableConcept = new CodeableConcept();
            ModelUtil.setCodingToConcept(codeableConcept, coding);
            fhirContext.setPracticeSetting(codeableConcept);
        }
    }

    public List<ICoding> getFacilityType(DomainResource resource) {
        CodeableConcept codeableConcept;
        DocumentReference fhirResource = (DocumentReference)resource;
        DocumentReference.DocumentReferenceContextComponent fhirContext = fhirResource.getContext();
        if (fhirContext != null && (codeableConcept = fhirContext.getFacilityType()) != null) {
            return ModelUtil.getCodingsFromConcept(codeableConcept);
        }
        return Collections.emptyList();
    }

    public void setFacilityType(DomainResource resource, ICoding coding) {
        DocumentReference fhirResource = (DocumentReference)resource;
        DocumentReference.DocumentReferenceContextComponent fhirContext = fhirResource.getContext();
        if (fhirContext != null) {
            CodeableConcept codeableConcept = new CodeableConcept();
            ModelUtil.setCodingToConcept(codeableConcept, coding);
            fhirContext.setFacilityType(codeableConcept);
        }
    }

    public List<ICoding> getDocumentClass(DomainResource resource) {
        DocumentReference fhirResource = (DocumentReference)resource;
        CodeableConcept codeableConcept = fhirResource.getClass_();
        if (codeableConcept != null) {
            return ModelUtil.getCodingsFromConcept(codeableConcept);
        }
        return Collections.emptyList();
    }

    public void setDocumentClass(DomainResource resource, ICoding coding) {
        DocumentReference fhirResource = (DocumentReference)resource;
        CodeableConcept codeableConcept = new CodeableConcept();
        ModelUtil.setCodingToConcept(codeableConcept, coding);
        fhirResource.setClass_(codeableConcept);
    }
}

