/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util;

import ch.elexis.core.findings.util.internal.FindingsFormat;
import ch.elexis.core.findings.util.internal.FindingsFormat20;
import ch.elexis.core.findings.util.internal.FindingsFormat24;
import java.util.Optional;

public class FindingsFormatUtil {
    public static final String CFG_HAPI_FHIR_VERSION = "es.findings.fhir.jpa.service/hapifhirversion";
    public static final String HAPI_FHIR_CURRENT_VERSION = "24";
    private static FindingsFormat24 currentFormat = new FindingsFormat24();
    private static FindingsFormat[] oldFormats = new FindingsFormat[]{new FindingsFormat20()};

    public static FindingsFormat getCurrentFormat() {
        return currentFormat;
    }

    public static boolean isCurrentFindingsFormat(String rawContent) {
        int currentFormatMatches = currentFormat.isFindingsFormat(rawContent);
        int highestFormatMatches = 0;
        FindingsFormat[] findingsFormatArray = oldFormats;
        int n = oldFormats.length;
        int n2 = 0;
        while (n2 < n) {
            FindingsFormat findingsFormat = findingsFormatArray[n2];
            int matches = findingsFormat.isFindingsFormat(rawContent);
            if (matches > highestFormatMatches) {
                highestFormatMatches = matches;
            }
            ++n2;
        }
        return currentFormatMatches >= highestFormatMatches;
    }

    public static Optional<String> convertToCurrentFindingsFormat(String rawContent) {
        FindingsFormat highestFormat = null;
        int highestFormatMatches = 0;
        FindingsFormat[] findingsFormatArray = oldFormats;
        int n = oldFormats.length;
        int n2 = 0;
        while (n2 < n) {
            FindingsFormat findingsFormat = findingsFormatArray[n2];
            int matches = findingsFormat.isFindingsFormat(rawContent);
            if (matches >= highestFormatMatches) {
                highestFormat = findingsFormat;
                highestFormatMatches = matches;
            }
            ++n2;
        }
        if (highestFormat != null) {
            return highestFormat.convertToCurrentFormat(rawContent);
        }
        return Optional.empty();
    }
}

