/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.format;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.types.Gender;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;

public class PersonFormatUtil {
    private static DateTimeFormatter defaultDateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

    public static String getDateOfBirth(IPerson person) {
        LocalDateTime dob = person.getDateOfBirth();
        if (dob != null) {
            return dob.format(defaultDateFormatter);
        }
        return "";
    }

    public static char getGenderCharLocalized(IPerson person) {
        Gender gender = person.getGender();
        if (gender != null) {
            if (Gender.MALE == gender) {
                return 'm';
            }
            if (Gender.FEMALE == gender) {
                return 'w';
            }
        }
        return '?';
    }

    public static String getPersonalia(IPerson person) {
        StringBuilder sb = new StringBuilder(64);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{person.getLastName()})) {
            sb.append(person.getLastName());
        }
        if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
            sb.append(" ");
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{person.getFirstName()})) {
            sb.append(person.getFirstName());
        }
        if (PersonFormatUtil.getGenderCharLocalized(person) != '?') {
            sb.append(" (").append(PersonFormatUtil.getGenderCharLocalized(person)).append("), ");
        }
        String dob = PersonFormatUtil.getDateOfBirth(person);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{dob})) {
            sb.append(dob);
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{person.getTitel()})) {
            sb.append(",").append(person.getTitel());
        }
        return sb.toString();
    }

    public static String getFullName(IPerson person) {
        StringBuilder sb = new StringBuilder(64);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{person.getTitel()})) {
            sb.append(person.getTitel());
        }
        if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
            sb.append(" ");
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{person.getLastName()})) {
            sb.append(person.getLastName());
        }
        if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
            sb.append(" ");
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{person.getFirstName()})) {
            sb.append(person.getFirstName());
        }
        return sb.toString();
    }

    public static String getSalutation(IPerson person) {
        if (person.getGender().equals((Object)Gender.MALE)) {
            return Messages.KontakteView_SalutationM;
        }
        if (person.getGender().equals((Object)Gender.FEMALE)) {
            return Messages.KontakteView_SalutationF;
        }
        return "";
    }
}

